/*
 * Decompiled with CFR 0.152.
 */
package glmath.jglm;

import glmath.jglm.Jglm;
import glmath.jglm.Mat;
import glmath.jglm.Mat3;
import glmath.jglm.Quat;
import glmath.jglm.Vec3;
import glmath.jglm.Vec4;

public class Mat4
extends Mat {
    public Vec4 c0;
    public Vec4 c1;
    public Vec4 c2;
    public Vec4 c3;

    public Mat4() {
        this.order = 4;
        this.c0 = new Vec4();
        this.c1 = new Vec4();
        this.c2 = new Vec4();
        this.c3 = new Vec4();
    }

    public Mat4(float value) {
        this();
        for (int i = 0; i < this.order; ++i) {
            this.set(i * (this.order + 1), value);
        }
    }

    public Mat4(Mat3 mat3) {
        this.order = 4;
        this.c0 = new Vec4(mat3.c0, 0.0f);
        this.c1 = new Vec4(mat3.c1, 0.0f);
        this.c2 = new Vec4(mat3.c2, 0.0f);
        this.c3 = new Vec4(new Vec3(), 1.0f);
    }

    public Mat4(float[] floatArray) {
        this.order = 4;
        this.c0 = new Vec4(floatArray, 0);
        this.c1 = new Vec4(floatArray, this.order);
        this.c2 = new Vec4(floatArray, this.order * 2);
        this.c3 = new Vec4(floatArray, this.order * 3);
    }

    public Mat4(Vec4 v0, Vec4 v1, Vec4 v2, Vec4 v3) {
        this.order = 4;
        this.c0 = v0;
        this.c1 = v1;
        this.c2 = v2;
        this.c3 = v3;
    }

    public Mat4(Vec4 diag) {
        this();
        this.c0.x = diag.x;
        this.c1.y = diag.y;
        this.c2.z = diag.z;
        this.c3.w = diag.w;
    }

    public float[] toFloatArray() {
        return new float[]{this.c0.x, this.c0.y, this.c0.z, this.c0.w, this.c1.x, this.c1.y, this.c1.z, this.c1.w, this.c2.x, this.c2.y, this.c2.z, this.c2.w, this.c3.x, this.c3.y, this.c3.z, this.c3.w};
    }

    public void setDiagonal(Vec3 vec3) {
        this.c0.x = vec3.x;
        this.c1.y = vec3.y;
        this.c2.z = vec3.z;
    }

    public Mat4 mult(Mat4 second) {
        float[] result = new float[16];
        for (int i = 0; i < this.order; ++i) {
            for (int j = 0; j < this.order; ++j) {
                float partial = 0.0f;
                for (int k = 0; k < this.order; ++k) {
                    partial += this.toFloatArray()[4 * k + j] * second.toFloatArray()[4 * i + k];
                }
                result[4 * i + j] = partial;
            }
        }
        return new Mat4(result);
    }

    public Vec4 mult(Vec4 second) {
        float[] result = new float[4];
        for (int i = 0; i < this.order; ++i) {
            float partial = 0.0f;
            for (int j = 0; j < this.order; ++j) {
                partial += this.toFloatArray()[4 * j + i] * second.toFloatArray()[j];
            }
            result[i] = partial;
        }
        return new Vec4(result);
    }

    public Mat4 transpose() {
        float[] transposed = new float[]{this.c0.x, this.c1.x, this.c2.x, this.c3.x, this.c0.y, this.c1.y, this.c2.y, this.c3.y, this.c0.z, this.c1.z, this.c2.z, this.c3.z, this.c0.w, this.c1.w, this.c2.w, this.c3.w};
        return new Mat4(transposed);
    }

    public Quat toQuaternion() {
        float w;
        float z;
        float y;
        float x;
        float trace = this.c0.x + this.c1.y + this.c2.z;
        if (trace > 0.0f) {
            float s = (float)(Math.sqrt(trace + 1.0f) * 2.0);
            x = (this.c1.z - this.c2.y) / s;
            y = (this.c2.x - this.c0.z) / s;
            z = (this.c0.y - this.c1.x) / s;
            w = 0.25f * s;
        } else if (this.c0.x > this.c1.y && this.c0.x > this.c2.z) {
            float s = (float)(Math.sqrt(1.0f + this.c0.x - this.c1.y - this.c2.z) * 2.0);
            x = 0.25f * s;
            y = (this.c1.x + this.c0.y) / s;
            z = (this.c2.x + this.c0.z) / s;
            w = (this.c1.z - this.c2.y) / s;
        } else if (this.c1.y > this.c2.z) {
            float s = (float)(Math.sqrt(1.0f + this.c1.y - this.c0.x - this.c2.z) * 2.0);
            x = (this.c1.x + this.c0.y) / s;
            y = 0.25f * s;
            z = (this.c2.y + this.c1.z) / s;
            w = (this.c2.x - this.c0.z) / s;
        } else {
            float s = (float)(Math.sqrt(1.0f + this.c2.z - this.c0.x - this.c1.y) * 2.0);
            x = (this.c2.x + this.c0.z) / s;
            y = (this.c2.y + this.c1.z) / s;
            z = 0.25f * s;
            w = (this.c0.y - this.c1.x) / s;
        }
        Quat quat = new Quat(x, y, z, w);
        quat.normalize();
        return quat;
    }

    public static Mat4 translate(Vec3 translation) {
        Mat4 translationMat = new Mat4(1.0f);
        translationMat.c3 = new Vec4(translation, 1.0f);
        return translationMat;
    }

    public static Mat4 rotationX(float angle) {
        float sina = (float)Math.sin(angle);
        float cosa = (float)Math.cos(angle);
        Mat4 result = new Mat4(1.0f);
        result.c1.y = cosa;
        result.c1.z = sina;
        result.c2.y = -sina;
        result.c2.z = cosa;
        return result;
    }

    public static Mat4 rotationY(float angle) {
        float sina = (float)Math.sin(angle);
        float cosa = (float)Math.cos(angle);
        Mat4 result = new Mat4(1.0f);
        result.c0.x = cosa;
        result.c0.z = -sina;
        result.c2.x = sina;
        result.c2.z = cosa;
        return result;
    }

    public static Mat4 rotationZ(float angle) {
        float sina = (float)Math.sin(angle);
        float cosa = (float)Math.cos(angle);
        Mat4 result = new Mat4(1.0f);
        result.c0.x = cosa;
        result.c0.y = sina;
        result.c1.x = -sina;
        result.c1.y = cosa;
        return result;
    }

    public static Mat4 CalcLookAtMatrix(Vec3 cameraPt, Vec3 lookPt, Vec3 upPt) {
        Vec3 lookDir = lookPt.minus(cameraPt);
        lookDir = lookDir.normalize();
        Vec3 upDir = upPt.normalize();
        Vec3 crossProduct = lookDir.crossProduct(upDir);
        Vec3 rightDir = crossProduct.normalize();
        Vec3 perpUpDir = rightDir.crossProduct(lookDir);
        Mat4 rotationMat = new Mat4(1.0f);
        rotationMat.c0 = new Vec4(rightDir, 0.0f);
        rotationMat.c1 = new Vec4(perpUpDir, 0.0f);
        rotationMat.c2 = new Vec4(lookDir.negated(), 0.0f);
        rotationMat = rotationMat.transpose();
        Mat4 translationMat = new Mat4(1.0f);
        translationMat.c3 = new Vec4(cameraPt.negated(), 1.0f);
        return rotationMat.mult(translationMat);
    }

    public boolean isEqual(Mat4 second) {
        boolean equal = true;
        for (int i = 0; i < this.toFloatArray().length; ++i) {
            if (this.toFloatArray()[i] == second.toFloatArray()[i]) continue;
            equal = false;
        }
        return equal;
    }

    public void print() {
        System.out.println(this.c0.x + " " + this.c1.x + " " + this.c2.x + " " + this.c3.x + "\n");
        System.out.println(this.c0.y + " " + this.c1.y + " " + this.c2.y + " " + this.c3.y + "\n");
        System.out.println(this.c0.z + " " + this.c1.z + " " + this.c2.z + " " + this.c3.z + "\n");
        System.out.println(this.c0.w + " " + this.c1.w + " " + this.c2.w + " " + this.c3.w + "\n");
    }

    public void print(String title) {
        System.out.println("" + title);
        System.out.println(this.c0.x + " " + this.c1.x + " " + this.c2.x + " " + this.c3.x + "\n");
        System.out.println(this.c0.y + " " + this.c1.y + " " + this.c2.y + " " + this.c3.y + "\n");
        System.out.println(this.c0.z + " " + this.c1.z + " " + this.c2.z + " " + this.c3.z + "\n");
        System.out.println(this.c0.w + " " + this.c1.w + " " + this.c2.w + " " + this.c3.w + "\n");
    }

    public final void set(int index, float value) {
        switch (index) {
            case 0: {
                this.c0.x = value;
                break;
            }
            case 1: {
                this.c0.y = value;
                break;
            }
            case 2: {
                this.c0.z = value;
                break;
            }
            case 3: {
                this.c0.w = value;
                break;
            }
            case 4: {
                this.c1.x = value;
                break;
            }
            case 5: {
                this.c1.y = value;
                break;
            }
            case 6: {
                this.c1.z = value;
                break;
            }
            case 7: {
                this.c1.w = value;
                break;
            }
            case 8: {
                this.c2.x = value;
                break;
            }
            case 9: {
                this.c2.y = value;
                break;
            }
            case 10: {
                this.c2.z = value;
                break;
            }
            case 11: {
                this.c2.w = value;
                break;
            }
            case 12: {
                this.c3.x = value;
                break;
            }
            case 13: {
                this.c3.y = value;
                break;
            }
            case 14: {
                this.c3.z = value;
                break;
            }
            case 15: {
                this.c3.w = value;
            }
        }
    }

    public final float get(int index) {
        switch (index) {
            case 0: {
                return this.c0.x;
            }
            case 1: {
                return this.c0.y;
            }
            case 2: {
                return this.c0.z;
            }
            case 3: {
                return this.c0.w;
            }
            case 4: {
                return this.c1.x;
            }
            case 5: {
                return this.c1.y;
            }
            case 6: {
                return this.c1.z;
            }
            case 7: {
                return this.c1.w;
            }
            case 8: {
                return this.c2.x;
            }
            case 9: {
                return this.c2.y;
            }
            case 10: {
                return this.c2.z;
            }
            case 11: {
                return this.c2.w;
            }
            case 12: {
                return this.c3.x;
            }
            case 13: {
                return this.c3.y;
            }
            case 14: {
                return this.c3.z;
            }
            case 15: {
                return this.c3.w;
            }
        }
        return -1.0f;
    }

    public Mat4 inverse() {
        float coeff00 = this.c2.z * this.c3.w - this.c3.z * this.c2.w;
        float coeff02 = this.c1.z * this.c3.w - this.c3.z * this.c1.w;
        float coeff03 = this.c1.z * this.c2.w - this.c2.z * this.c1.w;
        float coeff04 = this.c2.y * this.c3.w - this.c3.y * this.c2.w;
        float coeff06 = this.c1.y * this.c3.w - this.c3.y * this.c1.w;
        float coeff07 = this.c1.y * this.c2.w - this.c2.y * this.c1.w;
        float coeff08 = this.c2.y * this.c3.z - this.c3.y * this.c2.z;
        float coeff10 = this.c1.y * this.c3.z - this.c3.y * this.c1.z;
        float coeff11 = this.c1.y * this.c2.z - this.c2.y * this.c1.z;
        float coeff12 = this.c2.x * this.c3.w - this.c3.x * this.c2.w;
        float coeff14 = this.c1.x * this.c3.w - this.c3.x * this.c1.w;
        float coeff15 = this.c1.x * this.c2.w - this.c2.x * this.c1.w;
        float coeff16 = this.c2.x * this.c3.z - this.c3.x * this.c2.z;
        float coeff18 = this.c1.x * this.c3.z - this.c3.x * this.c1.z;
        float coeff19 = this.c1.x * this.c2.z - this.c2.x * this.c1.z;
        float coeff20 = this.c2.x * this.c3.y - this.c3.x * this.c2.y;
        float coeff22 = this.c1.x * this.c3.y - this.c3.x * this.c1.y;
        float coeff23 = this.c1.x * this.c2.y - this.c2.x * this.c1.y;
        Vec4 signA = new Vec4(1.0f, -1.0f, 1.0f, -1.0f);
        Vec4 signB = new Vec4(-1.0f, 1.0f, -1.0f, 1.0f);
        Vec4 fac0 = new Vec4(coeff00, coeff00, coeff02, coeff03);
        Vec4 fac1 = new Vec4(coeff04, coeff04, coeff06, coeff07);
        Vec4 fac2 = new Vec4(coeff08, coeff08, coeff10, coeff11);
        Vec4 fac3 = new Vec4(coeff12, coeff12, coeff14, coeff15);
        Vec4 fac4 = new Vec4(coeff16, coeff16, coeff18, coeff19);
        Vec4 fac5 = new Vec4(coeff20, coeff20, coeff22, coeff23);
        Vec4 vec0 = new Vec4(this.c1.x, this.c0.x, this.c0.x, this.c0.x);
        Vec4 vec1 = new Vec4(this.c1.y, this.c0.y, this.c0.y, this.c0.y);
        Vec4 vec2 = new Vec4(this.c1.z, this.c0.z, this.c0.z, this.c0.z);
        Vec4 vec3 = new Vec4(this.c1.w, this.c0.w, this.c0.w, this.c0.w);
        Vec4 one = vec1.mult(fac0);
        Vec4 two = vec2.mult(fac1);
        Vec4 three = vec3.mult(fac2);
        Vec4 inv0 = signA.mult(one.minus(two).plus(three));
        one = vec0.mult(fac0);
        two = vec2.mult(fac3);
        three = vec3.mult(fac4);
        Vec4 inv1 = signB.mult(one.minus(two).plus(three));
        one = vec0.mult(fac1);
        two = vec1.mult(fac3);
        three = vec3.mult(fac5);
        Vec4 inv2 = signA.mult(one.minus(two).plus(three));
        one = vec0.mult(fac2);
        two = vec1.mult(fac4);
        three = vec2.mult(fac5);
        Vec4 inv3 = signB.mult(one.minus(two).plus(three));
        Mat4 inverse = new Mat4(inv0, inv1, inv2, inv3);
        Vec4 row0 = new Vec4(inverse.c0.x, inverse.c1.x, inverse.c2.x, inverse.c3.x);
        float determinant = Jglm.dot(this.c0, row0);
        return inverse.divide(determinant);
    }

    public Mat4 divide(float s) {
        Vec4 newC0 = new Vec4(this.c0.x / s, this.c0.y / s, this.c0.z / s, this.c0.w / s);
        Vec4 newC1 = new Vec4(this.c1.x / s, this.c1.y / s, this.c1.z / s, this.c1.w / s);
        Vec4 newC2 = new Vec4(this.c2.x / s, this.c2.y / s, this.c2.z / s, this.c2.w / s);
        Vec4 newC3 = new Vec4(this.c3.x / s, this.c3.y / s, this.c3.z / s, this.c3.w / s);
        return new Mat4(newC0, newC1, newC2, newC3);
    }
}

