/*
 * Decompiled with CFR 0.152.
 */
package glmath.glm.vec._4;

import glmath.glm.Glm;
import glmath.glm.vec._4.ArithmeticOperators;
import glmath.glm.vec._4.Vec4;
import glmath.glm.vec._4.b.Vec4b;
import glmath.glm.vec._4.i.Vec4i;

abstract class funcCommon
extends ArithmeticOperators {
    funcCommon() {
    }

    public Vec4 abs() {
        return this.abs((Vec4)this);
    }

    public Vec4 abs_() {
        return this.abs(new Vec4());
    }

    public Vec4 abs(Vec4 result) {
        return funcCommon.abs((Vec4)this, result);
    }

    public static Vec4 abs(Vec4 x, Vec4 result) {
        result.x = Math.abs(x.x);
        result.y = Math.abs(x.y);
        result.z = Math.abs(x.z);
        result.w = Math.abs(x.w);
        return result;
    }

    public Vec4 ceil() {
        return this.ceil((Vec4)this);
    }

    public Vec4 ceil_() {
        return this.ceil(new Vec4());
    }

    public Vec4 ceil(Vec4 result) {
        return funcCommon.ceil((Vec4)this, (Vec4)this);
    }

    public static Vec4 ceil(Vec4 x, Vec4 result) {
        result.x = (float)Math.ceil(x.x);
        result.y = (float)Math.ceil(x.y);
        result.z = (float)Math.ceil(x.z);
        result.w = (float)Math.ceil(x.w);
        return result;
    }

    public Vec4 clamp(float minVal, float maxVal) {
        return this.clamp(minVal, maxVal, (Vec4)this);
    }

    public Vec4 clamp_(float minVal, float maxVal) {
        return this.clamp(minVal, maxVal, new Vec4());
    }

    public Vec4 clamp(float minVal, float maxVal, Vec4 result) {
        return funcCommon.clamp((Vec4)this, minVal, maxVal, result);
    }

    public static Vec4 clamp(Vec4 x, float minVal, float maxVal, Vec4 result) {
        result.x = Math.min(Math.max(x.x, minVal), maxVal);
        result.y = Math.min(Math.max(x.y, minVal), maxVal);
        result.z = Math.min(Math.max(x.z, minVal), maxVal);
        result.w = Math.min(Math.max(x.w, minVal), maxVal);
        return result;
    }

    public Vec4 clamp(Vec4 minVal, Vec4 maxVal) {
        return this.clamp(minVal, maxVal, (Vec4)this);
    }

    public Vec4 clamp_(Vec4 minVal, Vec4 maxVal) {
        return this.clamp(minVal, maxVal, new Vec4());
    }

    public Vec4 clamp(Vec4 minVal, Vec4 maxVal, Vec4 result) {
        return funcCommon.clamp((Vec4)this, minVal, maxVal, result);
    }

    public static Vec4 clamp(Vec4 x, Vec4 minVal, Vec4 maxVal, Vec4 result) {
        result.x = Math.min(Math.max(x.x, minVal.x), maxVal.x);
        result.y = Math.min(Math.max(x.y, minVal.y), maxVal.y);
        result.z = Math.min(Math.max(x.z, minVal.z), maxVal.z);
        result.w = Math.min(Math.max(x.w, minVal.w), maxVal.w);
        return result;
    }

    public Vec4i floatToIntBits_() {
        return funcCommon.floatToIntBits((Vec4)this, new Vec4i());
    }

    public Vec4i floatToIntBits(Vec4i result) {
        return funcCommon.floatToIntBits((Vec4)this, result);
    }

    public static Vec4i floatToIntBits(Vec4 x, Vec4i result) {
        result.x = Float.floatToIntBits(x.x);
        result.y = Float.floatToIntBits(x.y);
        result.z = Float.floatToIntBits(x.z);
        result.w = Float.floatToIntBits(x.w);
        return result;
    }

    public Vec4 floor() {
        return this.floor((Vec4)this);
    }

    public Vec4 floor_() {
        return this.floor(new Vec4());
    }

    public Vec4 floor(Vec4 result) {
        return funcCommon.floor((Vec4)this, result);
    }

    public static Vec4 floor(Vec4 x, Vec4 result) {
        result.x = (float)Math.floor(x.x);
        result.y = (float)Math.floor(x.y);
        result.z = (float)Math.floor(x.z);
        result.w = (float)Math.floor(x.w);
        return result;
    }

    public Vec4 fma(Vec4 b, Vec4 c) {
        return this.fma(b, c, (Vec4)this);
    }

    public Vec4 fma_(Vec4 b, Vec4 c) {
        return this.fma(b, c, new Vec4());
    }

    public Vec4 fma(Vec4 b, Vec4 c, Vec4 result) {
        return funcCommon.fma((Vec4)this, b, c, result);
    }

    public static Vec4 fma(Vec4 a, Vec4 b, Vec4 c, Vec4 result) {
        result.x = a.x * b.x + c.x;
        result.y = a.y * b.y + c.y;
        result.z = a.z * b.z + c.z;
        result.w = a.w * b.w + c.w;
        return result;
    }

    public Vec4 fract() {
        return this.fract((Vec4)this);
    }

    public Vec4 fract_() {
        return this.fract(new Vec4());
    }

    public Vec4 fract(Vec4 result) {
        return funcCommon.fract((Vec4)this, result);
    }

    public static Vec4 fract(Vec4 x, Vec4 result) {
        result.x = (float)((double)x.x - Math.floor(x.x));
        result.y = (float)((double)x.y - Math.floor(x.y));
        result.z = (float)((double)x.z - Math.floor(x.z));
        result.w = (float)((double)x.w - Math.floor(x.w));
        return result;
    }

    public Vec4b isInf_() {
        return funcCommon.isInf((Vec4)this, new Vec4b());
    }

    public Vec4b isInf(Vec4b result) {
        return funcCommon.isInf((Vec4)this, result);
    }

    public static Vec4b isInf(Vec4 x, Vec4b result) {
        result.x = (byte)(Float.isInfinite(x.x) ? 1 : 0);
        result.y = (byte)(Float.isInfinite(x.y) ? 1 : 0);
        result.z = (byte)(Float.isInfinite(x.z) ? 1 : 0);
        result.w = (byte)(Float.isInfinite(x.w) ? 1 : 0);
        return result;
    }

    public Vec4b isNan() {
        return funcCommon.isNan((Vec4)this, new Vec4b());
    }

    public Vec4b isNan(Vec4b result) {
        return funcCommon.isNan((Vec4)this, result);
    }

    public static Vec4b isNan(Vec4 x, Vec4b result) {
        result.x = (byte)(Float.isNaN(x.x) ? 1 : 0);
        result.y = (byte)(Float.isNaN(x.y) ? 1 : 0);
        result.z = (byte)(Float.isNaN(x.z) ? 1 : 0);
        result.w = (byte)(Float.isNaN(x.z) ? 1 : 0);
        return result;
    }

    public Vec4 max(Vec4 y) {
        return this.max(y, (Vec4)this);
    }

    public Vec4 max_(Vec4 y) {
        return funcCommon.max((Vec4)this, y, new Vec4());
    }

    public Vec4 max(Vec4 y, Vec4 result) {
        return funcCommon.max((Vec4)this, y, result);
    }

    public static Vec4 max(Vec4 x, Vec4 y, Vec4 result) {
        result.x = Math.max(x.x, y.x);
        result.y = Math.max(x.y, y.y);
        result.z = Math.max(x.z, y.z);
        result.w = Math.max(x.z, y.z);
        return result;
    }

    public Vec4 min(Vec4 y) {
        return this.min(y, (Vec4)this);
    }

    public Vec4 min_(Vec4 y) {
        return this.min(y, new Vec4());
    }

    public Vec4 min(Vec4 y, Vec4 result) {
        return funcCommon.min((Vec4)this, y, result);
    }

    public static Vec4 min(Vec4 x, Vec4 y, Vec4 result) {
        result.x = Math.min(x.x, y.x);
        result.y = Math.min(x.y, y.y);
        result.z = Math.min(x.z, y.z);
        result.w = Math.min(x.w, y.w);
        return result;
    }

    public Vec4 mix(Vec4 y, boolean a) {
        return this.mix(y, a, (Vec4)this);
    }

    public Vec4 mix_(Vec4 y, boolean a) {
        return this.mix(y, a, new Vec4());
    }

    public Vec4 mix(Vec4 y, boolean a, Vec4 result) {
        return funcCommon.mix((Vec4)this, y, a, result);
    }

    public static Vec4 mix(Vec4 x, Vec4 y, boolean a, Vec4 result) {
        return funcCommon.mix(x, y, a, a, a, a, result);
    }

    public Vec4 mix(Vec4 y, Vec4b a) {
        return this.mix(y, a, (Vec4)this);
    }

    public Vec4 mix_(Vec4 y, Vec4b a) {
        return this.mix(y, a, new Vec4());
    }

    public Vec4 mix(Vec4 y, Vec4b a, Vec4 result) {
        return funcCommon.mix((Vec4)this, y, a, result);
    }

    public static Vec4 mix(Vec4 x, Vec4 y, Vec4b a, Vec4 result) {
        return funcCommon.mix(x, y, a.x, a.y, a.z, a.w, result);
    }

    public static Vec4 mix(Vec4 x, Vec4 y, boolean a0, boolean a1, boolean a2, boolean a3, Vec4 result) {
        result.x = a0 ? y.x : x.x;
        result.y = a1 ? y.y : x.y;
        result.z = a2 ? y.z : x.z;
        result.w = a3 ? y.w : x.w;
        return result;
    }

    public Vec4 mix(Vec4 y, float a) {
        return this.mix(y, a, (Vec4)this);
    }

    public Vec4 mix_(Vec4 y, float a) {
        return this.mix(y, a, new Vec4());
    }

    public Vec4 mix(Vec4 y, float a, Vec4 result) {
        return funcCommon.mix((Vec4)this, y, a, result);
    }

    public static Vec4 mix(Vec4 x, Vec4 y, float a, Vec4 result) {
        return funcCommon.mix(x, y, a, a, a, a, result);
    }

    public Vec4 mix(Vec4 y, Vec4 a) {
        return this.mix(y, a, (Vec4)this);
    }

    public Vec4 mix_(Vec4 y, Vec4 a) {
        return this.mix(y, a, new Vec4());
    }

    public Vec4 mix(Vec4 y, Vec4 a, Vec4 result) {
        return funcCommon.mix((Vec4)this, y, a, result);
    }

    public static Vec4 mix(Vec4 x, Vec4 y, Vec4 a, Vec4 result) {
        return funcCommon.mix(x, y, a.x, a.y, a.z, a.w, result);
    }

    public static Vec4 mix(Vec4 x, Vec4 y, float a0, float a1, float a2, float a3, Vec4 result) {
        result.x = x.x + a0 * (y.x - x.x);
        result.y = x.y + a1 * (y.y - x.y);
        result.z = x.z + a2 * (y.z - x.z);
        result.w = x.w + a3 * (y.w - x.w);
        return result;
    }

    public Vec4 mod(Vec4 y) {
        return this.mod(y, (Vec4)this);
    }

    public Vec4 mod_(Vec4 y) {
        return this.mod(y, new Vec4());
    }

    public Vec4 mod(Vec4 y, Vec4 result) {
        return funcCommon.mod((Vec4)this, y, result);
    }

    public static Vec4 mod(Vec4 x, Vec4 y, Vec4 result) {
        result.x = x.x - y.x * Glm.floor(x.x / y.x);
        result.y = x.y - y.y * Glm.floor(x.y / y.y);
        result.z = x.z - y.z * Glm.floor(x.z / y.z);
        result.w = x.w - y.w * Glm.floor(x.w / y.w);
        return result;
    }

    public Vec4i round_() {
        return this.round(new Vec4i());
    }

    public Vec4i round(Vec4i result) {
        return funcCommon.round((Vec4)this, result);
    }

    public static Vec4i round(Vec4 x, Vec4i result) {
        result.x = Math.round(x.x);
        result.y = Math.round(x.y);
        result.z = Math.round(x.z);
        result.w = Math.round(x.z);
        return result;
    }

    public Vec4 sign() {
        return funcCommon.sign((Vec4)this, (Vec4)this);
    }

    public Vec4 sign_() {
        return this.sign(new Vec4());
    }

    public Vec4 sign(Vec4 result) {
        return funcCommon.sign((Vec4)this, result);
    }

    public static Vec4 sign(Vec4 x, Vec4 result) {
        result.x = Math.signum(x.x);
        result.y = Math.signum(x.y);
        result.z = Math.signum(x.z);
        result.w = Math.signum(x.w);
        return result;
    }

    public Vec4 smoothStep(Vec4 edge0, Vec4 edge1) {
        return this.smoothStep(edge0, edge1, (Vec4)this);
    }

    public Vec4 smoothStep_(Vec4 edge0, Vec4 edge1) {
        return this.smoothStep(edge0, edge1, new Vec4());
    }

    public Vec4 smoothStep(Vec4 edge0, Vec4 edge1, Vec4 result) {
        return funcCommon.smoothStep(edge0, edge1, (Vec4)this, result);
    }

    public static Vec4 smoothStep(Vec4 edge0, Vec4 edge1, Vec4 x, Vec4 result) {
        float tmpX = Math.min(Math.max((x.x - edge0.x) / (edge1.x - edge0.x), 0.0f), 1.0f);
        float tmpY = Math.min(Math.max((x.y - edge0.y) / (edge1.y - edge0.y), 0.0f), 1.0f);
        float tmpZ = Math.min(Math.max((x.z - edge0.z) / (edge1.z - edge0.z), 0.0f), 1.0f);
        float tmpW = Math.min(Math.max((x.w - edge0.w) / (edge1.w - edge0.w), 0.0f), 1.0f);
        result.x = tmpX * tmpX * (3.0f - 2.0f * tmpX);
        result.y = tmpY * tmpY * (3.0f - 2.0f * tmpY);
        result.z = tmpZ * tmpZ * (3.0f - 2.0f * tmpZ);
        result.w = tmpW * tmpW * (3.0f - 2.0f * tmpW);
        return result;
    }

    public Vec4 step(Vec4 edge) {
        return this.step(edge, (Vec4)this);
    }

    public Vec4 step_(Vec4 edge) {
        return this.step(edge, new Vec4());
    }

    public Vec4 step(Vec4 edge, Vec4 result) {
        return funcCommon.step(edge, (Vec4)this, result);
    }

    public static Vec4 step(Vec4 edge, Vec4 x, Vec4 result) {
        result.x = x.x < edge.x ? 0.0f : 1.0f;
        result.y = x.y < edge.y ? 0.0f : 1.0f;
        result.z = x.z < edge.z ? 0.0f : 1.0f;
        result.w = x.w < edge.w ? 0.0f : 1.0f;
        return result;
    }

    public Vec4 toUnsignedFloat() {
        return this.toUnsignedFloat((Vec4)this);
    }

    public Vec4 toUnsignedFloat_() {
        return this.toUnsignedFloat(new Vec4());
    }

    public Vec4 toUnsignedFloat(Vec4 result) {
        return funcCommon.toUnsignedFloat((Vec4)this, result);
    }

    public static Vec4 toUnsignedFloat(Vec4 x, Vec4 result) {
        result.x = Float.intBitsToFloat((int)x.x);
        result.y = Float.intBitsToFloat((int)x.y);
        result.z = Float.intBitsToFloat((int)x.z);
        result.w = Float.intBitsToFloat((int)x.w);
        return result;
    }
}

