/*
 * Decompiled with CFR 0.152.
 */
package glmath.glm.quat;

import glmath.glm.mat._4.Mat4;
import glmath.glm.quat.funcGeometric;
import glmath.glm.vec._3.Vec3;

public class Quat
extends funcGeometric {
    public Quat() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Quat(float x, float y, float z) {
        this(1.0f, x, y, z);
    }

    public Quat(Quat q) {
        this(q.w, q.x, q.y, q.z);
    }

    public Quat(float f, Vec3 v) {
        this(f, v.x, v.y, v.z);
    }

    public Quat(float w, float x, float y, float z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Quat set() {
        return this.set(0.0f, 0.0f, 0.0f);
    }

    public Quat set(float x, float y, float z) {
        return this.set(1.0f, x, y, z);
    }

    public Quat set(Quat q) {
        return this.set(q.w, q.x, q.y, q.z);
    }

    public Quat set(float f, Vec3 v) {
        return this.set(f, v.x, v.y, v.z);
    }

    public Quat set(float w, float x, float y, float z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Quat conjugate_() {
        return this.conjugate(new Quat());
    }

    public Quat conjugate() {
        return this.conjugate(this);
    }

    public Quat conjugate(Quat res) {
        return res.set(this.w, -this.x, -this.y, -this.z);
    }

    public static Quat cast_(Mat4 m) {
        return Quat.cast(m, new Quat());
    }

    public static Quat cast(Mat4 m, Quat res) {
        float fourXSquaredMinus1 = m.m00 - m.m11 - m.m22;
        float fourYSquaredMinus1 = m.m11 - m.m00 - m.m22;
        float fourZSquaredMinus1 = m.m22 - m.m00 - m.m11;
        float fourWSquaredMinus1 = m.m00 + m.m11 + m.m22;
        int biggestIndex = 0;
        float fourBiggestSquaredMinus1 = fourWSquaredMinus1;
        if (fourXSquaredMinus1 > fourBiggestSquaredMinus1) {
            fourBiggestSquaredMinus1 = fourXSquaredMinus1;
            biggestIndex = 1;
        }
        if (fourYSquaredMinus1 > fourBiggestSquaredMinus1) {
            fourBiggestSquaredMinus1 = fourYSquaredMinus1;
            biggestIndex = 2;
        }
        if (fourZSquaredMinus1 > fourBiggestSquaredMinus1) {
            fourBiggestSquaredMinus1 = fourZSquaredMinus1;
            biggestIndex = 3;
        }
        float biggestVal = (float)(Math.sqrt(fourBiggestSquaredMinus1 + 1.0f) * 0.5);
        float mult = 0.25f / biggestVal;
        switch (biggestIndex) {
            case 0: {
                res.w = biggestVal;
                res.x = (m.m12 - m.m21) * mult;
                res.y = (m.m20 - m.m02) * mult;
                res.z = (m.m01 - m.m10) * mult;
                break;
            }
            case 1: {
                res.w = (m.m12 - m.m21) * mult;
                res.x = biggestVal;
                res.y = (m.m01 + m.m10) * mult;
                res.z = (m.m20 + m.m02) * mult;
                break;
            }
            case 2: {
                res.w = (m.m20 - m.m02) * mult;
                res.x = (m.m01 + m.m10) * mult;
                res.y = biggestVal;
                res.z = (m.m12 + m.m21) * mult;
                break;
            }
            case 3: {
                res.w = (m.m01 - m.m10) * mult;
                res.x = (m.m20 + m.m02) * mult;
                res.y = (m.m12 + m.m21) * mult;
                res.z = biggestVal;
            }
        }
        return res;
    }

    public Mat4 toMat_() {
        return this.toMat(new Mat4());
    }

    public Mat4 toMat(Mat4 res) {
        float dx = this.x + this.x;
        float dy = this.y + this.y;
        float dz = this.z + this.z;
        float q00 = dx * this.x;
        float q11 = dy * this.y;
        float q22 = dz * this.z;
        float q01 = dx * this.y;
        float q02 = dx * this.z;
        float q03 = dx * this.w;
        float q12 = dy * this.z;
        float q13 = dy * this.w;
        float q23 = dz * this.w;
        res.m00 = 1.0f - q11 - q22;
        res.m01 = q01 + q23;
        res.m02 = q02 - q13;
        res.m03 = 0.0f;
        res.m10 = q01 - q23;
        res.m11 = 1.0f - q22 - q00;
        res.m12 = q12 + q03;
        res.m13 = 0.0f;
        res.m20 = q02 + q13;
        res.m21 = q12 - q03;
        res.m22 = 1.0f - q11 - q00;
        res.m23 = 0.0f;
        res.m30 = 0.0f;
        res.m31 = 0.0f;
        res.m32 = 0.0f;
        res.m33 = 1.0f;
        return res;
    }
}

