/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;

public class TileEntityTurretRichard
extends TileEntityTurretBaseNT {
    static List<Integer> configs = new ArrayList<Integer>();
    int timer;
    public int loaded;
    int reload;

    @Override
    protected List<Integer> getAmmoList() {
        return configs;
    }

    @Override
    public String getName() {
        return "container.turretRichard";
    }

    @Override
    public double getTurretDepression() {
        return 25.0;
    }

    @Override
    public double getTurretElevation() {
        return 25.0;
    }

    @Override
    public double getBarrelLength() {
        return 1.25;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public double getDecetorGrace() {
        return 8.0;
    }

    @Override
    public double getDecetorRange() {
        return 64.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.reload > 0) {
                --this.reload;
                if (this.reload == 0) {
                    this.loaded = 17;
                }
            }
            if (this.loaded <= 0 && this.reload <= 0 && this.getFirstConfigLoaded() != null) {
                this.reload = 100;
            }
            if (this.getFirstConfigLoaded() == null) {
                this.loaded = 0;
            }
            if (this.shouldSendNetworkUpdate()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74768_a("loaded", this.loaded);
                this.networkPack(data, 250);
            }
        }
    }

    @Override
    public void updateFiringTick() {
        if (this.reload > 0) {
            return;
        }
        ++this.timer;
        if (this.timer > 0 && this.timer % 10 == 0) {
            BulletConfiguration conf = this.getFirstConfigLoaded();
            if (conf != null) {
                this.spawnBullet(conf);
                this.conusmeAmmo(conf.ammo);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.richard_fire, SoundCategory.BLOCKS, 2.0f, 1.0f);
                --this.loaded;
                if (conf.ammo == ModItems.ammo_rocket_nuclear) {
                    this.timer = -50;
                }
            } else {
                this.loaded = 0;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        if (nbt.func_74764_b("loaded")) {
            this.loaded = nbt.func_74762_e("loaded");
        } else {
            super.networkUnpack(nbt);
        }
    }

    @Override
    public void spawnBullet(BulletConfiguration bullet) {
        Vec3 pos = new Vec3(this.getTurretPos());
        Vec3 vec = Vec3.createVectorHelper(this.getBarrelLength(), 0.0, 0.0);
        vec.rotateAroundZ((float)(-this.rotationPitch));
        vec.rotateAroundY((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityBulletBase proj = new EntityBulletBase(this.field_145850_b, BulletConfigSyncingUtil.getKey(bullet));
        proj.func_70080_a(pos.xCoord + vec.xCoord, pos.yCoord + vec.yCoord, pos.zCoord + vec.zCoord, 0.0f, 0.0f);
        proj.func_70186_c(vec.xCoord, vec.yCoord, vec.zCoord, bullet.velocity * 0.75f, bullet.spread);
        this.field_145850_b.func_72838_d((Entity)proj);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.loaded = nbt.func_74762_e("loaded");
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("loaded", this.loaded);
        return super.func_189515_b(nbt);
    }

    static {
        configs.add(BulletConfigSyncingUtil.ROCKET_NORMAL);
        configs.add(BulletConfigSyncingUtil.ROCKET_HE);
        configs.add(BulletConfigSyncingUtil.ROCKET_INCENDIARY);
        configs.add(BulletConfigSyncingUtil.ROCKET_SHRAPNEL);
        configs.add(BulletConfigSyncingUtil.ROCKET_EMP);
        configs.add(BulletConfigSyncingUtil.ROCKET_GLARE);
        configs.add(BulletConfigSyncingUtil.ROCKET_SLEEK);
        configs.add(BulletConfigSyncingUtil.ROCKET_NUKE);
        configs.add(BulletConfigSyncingUtil.ROCKET_CHAINSAW);
        configs.add(BulletConfigSyncingUtil.ROCKET_TOXIC);
        configs.add(BulletConfigSyncingUtil.ROCKET_PHOSPHORUS);
        configs.add(BulletConfigSyncingUtil.ROCKET_CANISTER);
    }
}

