/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network.energy;

import api.hbm.energy.Nodespace;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.network.energy.TileEntityCableBaseNT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityPylonBase
extends TileEntityCableBaseNT {
    public List<int[]> connected = new ArrayList<int[]>();

    public static int canConnect(TileEntityPylonBase first, TileEntityPylonBase second) {
        if (first.getConnectionType() != second.getConnectionType()) {
            return 1;
        }
        if (first == second) {
            return 2;
        }
        double len = Math.min(first.getMaxWireLength(), second.getMaxWireLength());
        Vec3 firstPos = first.getConnectionPoint();
        Vec3 secondPos = second.getConnectionPoint();
        Vec3 delta = Vec3.createVectorHelper(secondPos.xCoord - firstPos.xCoord, secondPos.yCoord - firstPos.yCoord, secondPos.zCoord - firstPos.zCoord);
        return len >= delta.lengthVector() ? 0 : 3;
    }

    @Override
    public Nodespace.PowerNode createNode() {
        TileEntityPylonBase tile = this;
        Nodespace.PowerNode node = new Nodespace.PowerNode(new BlockPos(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p())).setConnections(new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), ForgeDirection.UNKNOWN));
        for (int[] pos : this.connected) {
            this.field_145850_b.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
            node.addConnection(new DirPos(pos[0], pos[1], pos[2], ForgeDirection.UNKNOWN));
        }
        return node;
    }

    public void addConnection(int x, int y, int z) {
        this.connected.add(new int[]{x, y, z});
        Nodespace.PowerNode node = Nodespace.getNode(this.field_145850_b, this.field_174879_c);
        if (node != null) {
            node.recentlyChanged = true;
            node.addConnection(new DirPos(x, y, z, ForgeDirection.UNKNOWN));
        }
        this.func_70296_d();
        if (this.field_145850_b instanceof WorldServer) {
            WorldServer worldS = (WorldServer)this.field_145850_b;
            worldS.func_184138_a(this.field_174879_c, worldS.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public void removeConnection(BlockPos pos) {
        this.connected.remove(pos);
    }

    public void disconnectAll() {
        for (int[] pos : this.connected) {
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
            if (te == this || !(te instanceof TileEntityPylonBase)) continue;
            TileEntityPylonBase pylon = (TileEntityPylonBase)te;
            Nodespace.destroyNode(this.field_145850_b, new BlockPos(pos[0], pos[1], pos[2]));
            for (int i = 0; i < pylon.connected.size(); ++i) {
                int[] conPos = pylon.connected.get(i);
                if (conPos[0] != this.field_174879_c.func_177958_n() || conPos[1] != this.field_174879_c.func_177956_o() || conPos[2] != this.field_174879_c.func_177952_p()) continue;
                pylon.connected.remove(i);
                --i;
            }
            pylon.func_70296_d();
            if (!(this.field_145850_b instanceof WorldServer)) continue;
            WorldServer worldS = (WorldServer)this.field_145850_b;
            worldS.func_184138_a(pylon.field_174879_c, worldS.func_180495_p(pylon.field_174879_c), this.field_145850_b.func_180495_p(pylon.field_174879_c), 3);
        }
        Nodespace.destroyNode(this.field_145850_b, this.field_174879_c);
    }

    public abstract ConnectionType getConnectionType();

    public abstract Vec3[] getMountPos();

    public abstract double getMaxWireLength();

    public Vec3 getConnectionPoint() {
        Vec3[] mounts = this.getMountPos();
        if (mounts == null || mounts.length == 0) {
            return Vec3.createVectorHelper((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        }
        return mounts[0].addVector(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("conCount", this.connected.size());
        for (int i = 0; i < this.connected.size(); ++i) {
            nbt.func_74783_a("con" + i, this.connected.get(i));
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int count = nbt.func_74762_e("conCount");
        this.connected.clear();
        for (int i = 0; i < count; ++i) {
            this.connected.add(nbt.func_74759_k("con" + i));
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static enum ConnectionType {
        SINGLE,
        QUAD;

    }
}

