/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.tileentity.TileEntityTickingBase;
import com.hbm.tileentity.machine.TileEntitySolarBoiler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarMirror
extends TileEntityTickingBase {
    public int tX;
    public int tY;
    public int tZ;
    public boolean isOn;
    public static int maxTU = 500;
    AxisAlignedBB bb = null;

    @Override
    public String getInventoryName() {
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldSendNetworkUpdate()) {
                this.sendUpdate();
            }
            if (this.tY < this.field_174879_c.func_177956_o()) {
                this.isOn = false;
                return;
            }
            int sunHeat = (int)((float)maxTU * TileEntitySolarMirror.getBrightness(this.field_145850_b));
            if (sunHeat <= 0 || !this.field_145850_b.func_175678_i(this.field_174879_c.func_177984_a())) {
                this.isOn = false;
                return;
            }
            this.isOn = true;
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.tX, this.tY - 1, this.tZ));
            if (te instanceof TileEntitySolarBoiler) {
                TileEntitySolarBoiler boiler = (TileEntitySolarBoiler)te;
                boiler.heatInput += sunHeat;
            }
        }
    }

    public static float getBrightness(World world) {
        float starAngle = world.func_72929_e(1.0f);
        starAngle = starAngle < (float)Math.PI ? (starAngle += (0.0f - starAngle) * 0.2f) : (starAngle += ((float)Math.PI * 2 - starAngle) * 0.2f);
        int lightValue = EnumSkyBlock.SKY.field_77198_c - world.func_175657_ab();
        lightValue = MathHelper.func_76125_a((int)Math.round((float)lightValue * MathHelper.func_76134_b((float)starAngle)), (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    public void sendUpdate() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("posX", this.tX);
        data.func_74768_a("posY", this.tY);
        data.func_74768_a("posZ", this.tZ);
        data.func_74757_a("isOn", this.isOn);
        this.networkPack(data, 200);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tX = nbt.func_74762_e("posX");
        this.tY = nbt.func_74762_e("posY");
        this.tZ = nbt.func_74762_e("posZ");
        this.isOn = nbt.func_74767_n("isOn");
    }

    public void setTarget(int x, int y, int z) {
        this.tX = x;
        this.tY = y;
        this.tZ = z;
        this.func_70296_d();
        this.sendUpdate();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.tX = compound.func_74762_e("targetX");
        this.tY = compound.func_74762_e("targetY");
        this.tZ = compound.func_74762_e("targetZ");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("targetX", this.tX);
        compound.func_74768_a("targetY", this.tY);
        compound.func_74768_a("targetZ", this.tZ);
        return super.func_189515_b(compound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.25, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.25, (double)this.field_174879_c.func_177958_n() + 1.25, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 1.25);
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

