/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyGenerator;
import com.google.common.base.Predicate;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.FluidTypePacketTest;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineTurbine
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator,
ITankPacketAcceptor,
IFluidHandler {
    public ItemStackHandler inventory;
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public boolean needsTankTypeUpdate;
    private String customName;
    private long detectPower;
    private FluidTank[] detectTanks = new FluidTank[]{null, null};
    private Fluid[] detectFluids = new Fluid[]{null, null};

    public TileEntityMachineTurbine() {
        this.inventory = new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineTurbine.this.func_70296_d();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 0) {
                    return stack != null && stack.func_77973_b() == ModItems.forge_fluid_identifier;
                }
                if (slot == 4 && stack != null && stack.func_77973_b() instanceof IBatteryItem) {
                    return true;
                }
                return slot != 4 && stack != null;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (this.isItemValid(slot, stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return ItemStack.field_190927_a;
            }
        };
        this.tanks = new FluidTank[2];
        this.tankTypes = new Fluid[2];
        this.tanks[0] = new FluidTank(64000);
        this.tankTypes[0] = ModForgeFluids.steam;
        this.tanks[1] = new FluidTank(128000);
        this.tankTypes[1] = ModForgeFluids.spentsteam;
        this.needsTankTypeUpdate = false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Object[] outs;
            Fluid f;
            if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.forge_fluid_identifier && this.inventory.getStackInSlot(1).func_190926_b() && this.isValidFluidForTank(0, new FluidStack(f = ItemForgeFluidIdentifier.getType(this.inventory.getStackInSlot(0)), 1000))) {
                if (this.tankTypes[0] != f) {
                    this.tankTypes[0] = f;
                    this.tanks[0].setFluid(null);
                    this.tanks[1].setFluid(null);
                }
                this.inventory.setStackInSlot(1, this.inventory.getStackInSlot(0));
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.tankTypes), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 4, this.power, 1000000L);
            this.fillFluidInit(this.tanks[1]);
            this.sendPower(this.field_145850_b, this.field_174879_c);
            if (this.inputValidForTank(0, 2) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 3) && this.tanks[0].getFluid() != null) {
                this.tankTypes[0] = this.tanks[0].getFluid().getFluid();
            }
            if ((outs = MachineRecipes.getTurbineOutput(this.tanks[0].getFluid() == null ? null : this.tanks[0].getFluid().getFluid())) != null) {
                this.tankTypes[1] = (Fluid)outs[0];
                int processMax = 1200;
                int processSteam = this.tanks[0].getFluidAmount() / (Integer)outs[2];
                int processWater = (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / (Integer)outs[1];
                int cycles = Math.min(processMax, Math.min(processSteam, processWater));
                this.tanks[0].drain((Integer)outs[2] * cycles, true);
                this.tanks[1].fill(new FluidStack(this.tankTypes[1], (Integer)outs[1] * cycles), true);
                this.power += (long)((Integer)outs[3] * cycles);
                if (this.power > 1000000L) {
                    this.power = 1000000L;
                }
            }
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 5, 6);
            this.detectAndSendChanges();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.tankTypes[0] = nbt.func_74764_b("tankType0") ? FluidRegistry.getFluid((String)nbt.func_74779_i("tankType0")) : null;
        this.tankTypes[1] = nbt.func_74764_b("tankType1") ? FluidRegistry.getFluid((String)nbt.func_74779_i("tankType1")) : null;
        this.power = nbt.func_74763_f("power");
        this.detectPower = this.power + 1L;
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.tankTypes[0] != null) {
            nbt.func_74778_a("tankType0", this.tankTypes[0].getName());
        }
        if (this.tankTypes[1] != null) {
            nbt.func_74778_a("tankType1", this.tankTypes[1].getName());
        }
        nbt.func_74772_a("power", this.power);
        return super.func_189515_b(nbt);
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (this.inventory.getStackInSlot(slot) != ItemStack.field_190927_a && this.tanks[tank] != null) {
            return FFUtils.checkRestrictions(this.inventory.getStackInSlot(slot), (Predicate<FluidStack>)((Predicate)f -> f.getFluid() == this.tankTypes[tank]));
        }
        return false;
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == ModForgeFluids.steam || stack.getFluid() == ModForgeFluids.hotsteam || stack.getFluid() == ModForgeFluids.superhotsteam || stack.getFluid() == ModForgeFluids.ultrahotsteam;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.machineTurbine";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.tankTypes[0] && resource.amount > 0) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public void fillFluidInit(FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177974_f(), 64000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177976_e(), 64000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177984_a(), 64000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177977_b(), 64000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177968_d(), 64000);
        FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177978_c(), 64000);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.tankTypes[1] && resource.amount > 0) {
            return this.tanks[1].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain > 0) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(cap, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing)));
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        if (!FFUtils.areTanksEqual(this.detectTanks[0], this.tanks[0])) {
            mark = true;
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
        }
        if (!FFUtils.areTanksEqual(this.detectTanks[1], this.tanks[1])) {
            mark = true;
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
        }
        if (this.detectFluids[0] != this.tankTypes[0]) {
            mark = true;
            this.detectFluids[0] = this.tankTypes[0];
        }
        if (this.detectFluids[1] != this.tankTypes[1]) {
            mark = true;
            this.detectFluids[1] = this.tankTypes[1];
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }
}

