/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.MissileStruct;
import com.hbm.items.weapon.ItemCustomMissile;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ItemStackHandlerWrapper;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEMissileMultipartPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineMissileAssembly
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            TileEntityMachineMissileAssembly.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public MissileStruct load;
    private String customName;
    public static int xCooldown = 20;
    public int cooldown = 20;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.missileAssembly";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            MissileStruct multipart = new MissileStruct(this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2), this.inventory.getStackInSlot(3), this.inventory.getStackInSlot(4));
            if (this.cooldown == 0 && this.field_145850_b.func_175640_z(this.field_174879_c)) {
                this.construct();
                this.cooldown = xCooldown;
            } else {
                this.cooldown = Math.max(0, this.cooldown - 1);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEMissileMultipartPacket(this.field_174879_c, multipart), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        }
    }

    public int fuselageState() {
        if (this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemMissile) {
            ItemMissile part = (ItemMissile)this.inventory.getStackInSlot(2).func_77973_b();
            if (part.type == ItemMissile.PartType.FUSELAGE) {
                return 1;
            }
        }
        return 0;
    }

    public int chipState() {
        if (this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemMissile) {
            ItemMissile part = (ItemMissile)this.inventory.getStackInSlot(0).func_77973_b();
            if (part.type == ItemMissile.PartType.CHIP) {
                return 1;
            }
        }
        return 0;
    }

    public int warheadState() {
        if (this.inventory.getStackInSlot(1).func_77973_b() instanceof ItemMissile && this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemMissile && this.inventory.getStackInSlot(4).func_77973_b() instanceof ItemMissile) {
            ItemMissile part = (ItemMissile)this.inventory.getStackInSlot(1).func_77973_b();
            ItemMissile fuselage = (ItemMissile)this.inventory.getStackInSlot(2).func_77973_b();
            ItemMissile thruster = (ItemMissile)this.inventory.getStackInSlot(4).func_77973_b();
            if (part.attributes.length <= 2 || thruster.attributes.length <= 2) {
                return 0;
            }
            float weight = ((Float)part.attributes[2]).floatValue();
            float thrust = ((Float)thruster.attributes[2]).floatValue();
            if (part.type == ItemMissile.PartType.WARHEAD && fuselage.type == ItemMissile.PartType.FUSELAGE && part.bottom == fuselage.top && weight <= thrust) {
                return 1;
            }
        }
        return 0;
    }

    public int stabilityState() {
        if (this.inventory.getStackInSlot(3).func_190926_b()) {
            return -1;
        }
        if (this.inventory.getStackInSlot(3).func_77973_b() instanceof ItemMissile && this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemMissile) {
            ItemMissile part = (ItemMissile)this.inventory.getStackInSlot(3).func_77973_b();
            ItemMissile fuselage = (ItemMissile)this.inventory.getStackInSlot(2).func_77973_b();
            if (part.type == ItemMissile.PartType.FINS && fuselage.type == ItemMissile.PartType.FUSELAGE && part.top == fuselage.bottom) {
                return 1;
            }
        }
        return 0;
    }

    public int thrusterState() {
        if (this.inventory.getStackInSlot(4).func_77973_b() instanceof ItemMissile && this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemMissile) {
            ItemMissile part = (ItemMissile)this.inventory.getStackInSlot(4).func_77973_b();
            ItemMissile fuselage = (ItemMissile)this.inventory.getStackInSlot(2).func_77973_b();
            if (part.type == ItemMissile.PartType.THRUSTER && fuselage.type == ItemMissile.PartType.FUSELAGE && part.top == fuselage.bottom && (ItemMissile.FuelType)((Object)part.attributes[0]) == (ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
                return 1;
            }
        }
        return 0;
    }

    public boolean canBuild() {
        if (this.inventory.getStackInSlot(5).func_190926_b() && this.chipState() == 1 && this.warheadState() == 1 && this.fuselageState() == 1 && this.thrusterState() == 1) {
            return this.stabilityState() != 0;
        }
        return false;
    }

    public void construct() {
        if (!this.canBuild()) {
            return;
        }
        this.inventory.setStackInSlot(5, ItemCustomMissile.buildMissile(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2), this.inventory.getStackInSlot(3), this.inventory.getStackInSlot(4)).func_77946_l());
        if (this.stabilityState() == 1) {
            this.inventory.setStackInSlot(3, ItemStack.field_190927_a);
        }
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
        this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
        this.inventory.setStackInSlot(4, ItemStack.field_190927_a);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.missileAssembly2, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemMissile) {
            ItemMissile missilePart = (ItemMissile)stack.func_77973_b();
            if (slot == 0) {
                return missilePart.type == ItemMissile.PartType.CHIP;
            }
            if (slot == 1) {
                return missilePart.type == ItemMissile.PartType.WARHEAD;
            }
            if (slot == 2) {
                return missilePart.type == ItemMissile.PartType.FUSELAGE;
            }
            if (slot == 3) {
                return missilePart.type == ItemMissile.PartType.FINS;
            }
            if (slot == 4) {
                return missilePart.type == ItemMissile.PartType.THRUSTER;
            }
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 5;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemStackHandlerWrapper(this.inventory, this.getAccessibleSlotsFromSide(facing)){

                @Override
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (TileEntityMachineMissileAssembly.this.canExtractItem(slot, TileEntityMachineMissileAssembly.this.inventory.getStackInSlot(slot), amount)) {
                        return super.extractItem(slot, amount, simulate);
                    }
                    return ItemStack.field_190927_a;
                }

                @Override
                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (TileEntityMachineMissileAssembly.this.canInsertItem(slot, stack, stack.func_190916_E())) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
            });
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null || super.hasCapability(capability, facing);
    }
}

