/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.interfaces.Untested;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.FluidTypePacketTest;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineLargeTurbine
extends TileEntityMachineBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor {
    public long power;
    public static final long maxPower = 100000000L;
    public int age = 0;
    public FluidTank[] tanks;
    public Fluid[] types = new Fluid[2];
    private boolean shouldTurn;
    public float rotor;
    public float lastRotor;

    public TileEntityMachineLargeTurbine() {
        super(7);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(512000);
        this.tanks[1] = new FluidTank(10240000);
        this.types[0] = ModForgeFluids.steam;
        this.types[1] = ModForgeFluids.spentsteam;
    }

    @Untested
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Fluid f;
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            this.fillFluidInit(this.tanks[1]);
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * -4, 0, dir.offsetZ * -4), dir.getOpposite());
            if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.forge_fluid_identifier && this.inventory.getStackInSlot(1).func_190926_b() && this.isValidFluidForTank(0, new FluidStack(f = ItemForgeFluidIdentifier.getType(this.inventory.getStackInSlot(0)), 1000))) {
                this.types[0] = f;
                if (this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != this.types[0]) {
                    this.tanks[0].setFluid(null);
                }
                this.inventory.setStackInSlot(1, this.inventory.getStackInSlot(0));
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (this.inputValidForTank(0, 2)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 3);
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 4, this.power, 100000000L);
            boolean operational = false;
            Object[] outs = MachineRecipes.getTurbineOutput(this.types[0]);
            if (outs == null) {
                this.types[1] = null;
                this.tanks[1].setFluid(null);
            } else {
                this.types[1] = (Fluid)outs[0];
                if (this.tanks[1].getFluid() != null && this.tanks[1].getFluid().getFluid() != this.types[1]) {
                    this.tanks[1].setFluid(null);
                }
                int processMax = (int)Math.ceil(Math.ceil((float)this.tanks[0].getFluidAmount() / 10.0f) / (double)((Integer)outs[2]).intValue());
                int processSteam = this.tanks[0].getFluidAmount() / (Integer)outs[2];
                int processWater = (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / (Integer)outs[1];
                int cycles = Math.min(processMax, Math.min(processSteam, processWater));
                this.tanks[0].drain((Integer)outs[2] * cycles, true);
                this.tanks[1].fill(new FluidStack(this.types[1], (Integer)outs[1] * cycles), true);
                this.power += (long)((Integer)outs[3] * cycles);
                if (this.power > 100000000L) {
                    this.power = 100000000L;
                }
                if (cycles > 0) {
                    operational = true;
                }
            }
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 5, 6);
            if (this.shouldSendNetworkUpdate()) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTypePacketTest(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new Fluid[]{this.types[0], this.types[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
                NBTTagCompound data = new NBTTagCompound();
                data.func_74772_a("power", this.power);
                data.func_74757_a("operational", operational);
                this.networkPack(data, 50);
            }
        } else {
            this.lastRotor = this.rotor;
            if (this.shouldTurn) {
                this.rotor += 15.0f;
                if (this.rotor >= 360.0f) {
                    this.rotor -= 360.0f;
                    this.lastRotor -= 360.0f;
                }
            }
        }
    }

    protected boolean inputValidForTank(int tank, int slot) {
        FluidStack f;
        return this.inventory.getStackInSlot(slot) != ItemStack.field_190927_a && this.tanks[tank] != null && (f = FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot))) != null && f.getFluid() == this.types[tank];
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == ModForgeFluids.steam || stack.getFluid() == ModForgeFluids.hotsteam || stack.getFluid() == ModForgeFluids.superhotsteam || stack.getFluid() == ModForgeFluids.ultrahotsteam;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.shouldTurn = data.func_74767_n("operational");
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 100000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.types[0] = compound.func_74764_b("tankType0") ? FluidRegistry.getFluid((String)compound.func_74779_i("tankType0")) : null;
        this.types[1] = compound.func_74764_b("tankType1") ? FluidRegistry.getFluid((String)compound.func_74779_i("tankType1")) : null;
        FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        this.power = compound.func_74763_f("power");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        compound.func_74772_a("power", this.power);
        if (this.types[0] != null) {
            compound.func_74778_a("tankType0", this.types[0].getName());
        }
        if (this.types[1] != null) {
            compound.func_74778_a("tankType1", this.types[1].getName());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public String getName() {
        return "container.machineLargeTurbine";
    }

    public void fillFluidInit(FluidTank type) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        dir = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * 2, type);
        this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX * -2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ * -2, type);
    }

    public void fillFluid(int x, int y, int z, FluidTank type) {
        FFUtils.fillFluid(this, type, this.field_145850_b, new BlockPos(x, y, z), 10239000);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.types[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.types[1]) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }
}

