/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineFluidTank
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor,
IControllable {
    public FluidTank tank = new FluidTank(256000);
    public short mode = 0;
    public static final short modes = 4;
    public int age = 0;
    public static int[] slots = new int[]{2};
    private FluidTank detectTank;

    public TileEntityMachineFluidTank() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.fluidtank";
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.tank.readFromNBT(compound);
        this.mode = compound.func_74765_d("mode");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.tank.writeToNBT(compound);
        compound.func_74777_a("mode", this.mode);
        return super.func_189515_b(compound);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return slots;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (!(this.mode != 1 && this.mode != 2 || this.age != 9 && this.age != 19)) {
                this.fillFluidInit();
            }
            FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 2, 3);
            FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 4, 5);
            if (this.tank.getFluid() != null && (this.tank.getFluid().getFluid() == ModForgeFluids.amat || this.tank.getFluid().getFluid() == ModForgeFluids.aschrab)) {
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
                this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5.0f, true, true);
            }
            if (this.shouldSendNetworkUpdate()) {
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tank}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
                NBTTagCompound data = new NBTTagCompound();
                data.func_74777_a("mode", this.mode);
                this.networkPack(data, 50);
            }
            this.detectAndSendChanges();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.mode = nbt.func_74765_d("mode");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        super.handleButtonPacket(value, meta);
        this.mode = (short)((this.mode + 1) % 4);
        if (!this.field_145850_b.field_72995_K) {
            this.broadcastControlEvt();
        }
        this.func_70296_d();
    }

    private void fillFluidInit() {
        if (this.tank.getFluid() != null) {
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 1), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, -1), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 2), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), 64000);
            FFUtils.fillFluid(this, this.tank, this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -2), 64000);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (!FFUtils.areTanksEqual(this.tank, this.detectTank)) {
            mark = true;
            this.detectTank = FFUtils.copyTank(this.tank);
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.canFill(resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (this.canDrain(resource.getFluid())) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.canDrain(null)) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(Fluid fluid) {
        if (!this.field_145850_b.field_72995_K) {
            return this.mode != 2 && this.mode != 3 && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid);
        }
        return false;
    }

    public boolean canDrain(Fluid fluid) {
        if (!this.field_145850_b.field_72995_K) {
            return this.tank.getFluid() != null;
        }
        return false;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        HashMap<String, DataValue> data = new HashMap<String, DataValue>();
        if (this.tank.getFluid() != null) {
            data.put("t0_fluidType", new DataValueString(this.tank.getFluid().getLocalizedName()));
        }
        data.put("t0_fluidAmount", new DataValueFloat(this.tank.getFluidAmount()));
        data.put("mode", new DataValueFloat(this.mode));
        return data;
    }

    @Override
    public void receiveEvent(BlockPos from, ControlEvent e) {
        if (e.name.equals("tank_set_mode")) {
            this.mode = (short)(e.vars.get("mode").getNumber() % 4.0f);
            this.broadcastControlEvt();
        }
    }

    public void broadcastControlEvt() {
        ControlEventSystem.get(this.field_145850_b).broadcastToSubscribed(this, ControlEvent.newEvent("tank_set_mode").setVar("mode", new DataValueFloat(this.mode)));
    }

    @Override
    public List<String> getInEvents() {
        return Collections.singletonList("tank_set_mode");
    }

    @Override
    public List<String> getOutEvents() {
        return Collections.singletonList("tank_set_mode");
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }
}

