/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.energy.Nodespace;
import com.hbm.lib.DirPos;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.TileEntityMachineBattery;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineFENSU
extends TileEntityMachineBattery {
    public EnumDyeColor color = EnumDyeColor.LIGHT_BLUE;
    public static final long maxTransfer = 10000000000000000L;
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            super.func_73660_a();
        } else {
            this.prevRotation = this.rotation;
            this.rotation += this.getSpeed();
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    public long getProviderSpeed() {
        short mode = this.getRelevantMode(true);
        return mode == 2 || mode == 1 ? 10000000000000000L : 0L;
    }

    @Override
    public long getReceiverSpeed() {
        short mode = this.getRelevantMode(true);
        return mode == 0 || mode == 1 ? 10000000000000000L : 0L;
    }

    @Override
    public NBTTagCompound packNBT() {
        NBTTagCompound nbt = super.packNBT();
        nbt.func_74774_a("color", (byte)this.color.func_176765_a());
        return nbt;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.powerDelta = nbt.func_74763_f("delta");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.color = EnumDyeColor.func_176764_b((int)nbt.func_74771_c("color"));
        this.priority = IEnergyUser.ConnectionPriority.values()[nbt.func_74771_c("priority")];
    }

    @Override
    public Nodespace.PowerNode createNode() {
        return new Nodespace.PowerNode(this.field_174879_c).setConnections(new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), Library.NEG_Y));
    }

    @Override
    public long getPowerRemainingScaled(long i) {
        double powerScaled = (double)this.power / (double)this.getMaxPower();
        return (long)((double)i * powerScaled);
    }

    public float getSpeed() {
        return (float)Math.pow(Math.log((double)this.power * 0.75 + 1.0) * (double)0.05f, 5.0);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long transferPower(long power) {
        long freespace;
        long overshoot = 0L;
        if (power > 10000000000000000L) {
            overshoot += power - 10000000000000000L;
            power = 10000000000000000L;
        }
        if ((freespace = this.getMaxPower() - this.getPower()) < power) {
            overshoot += power - freespace;
            power = freespace;
        }
        this.setPower(this.getPower() + power);
        return overshoot;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.color = EnumDyeColor.func_176764_b((int)compound.func_74771_c("color"));
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("color", (byte)this.color.func_176765_a());
        return super.func_189515_b(compound);
    }

    @Override
    public long getMaxPower() {
        return Long.MAX_VALUE;
    }
}

