/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.IDrillInteraction;
import api.hbm.block.IMiningDrill;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.gas.BlockGasBase;
import com.hbm.blocks.generic.BlockBedrockOreTE;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.BedrockOreRegistry;
import com.hbm.inventory.ShredderRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineExcavator;
import com.hbm.inventory.gui.GUIMachineExcavator;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemDrillbit;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import com.hbm.util.ItemStackUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineExcavator
extends TileEntityMachineBase
implements IEnergyUser,
IFluidHandler,
ITickable,
ITankPacketAcceptor,
IControlReceiver,
IGUIProvider,
IMiningDrill {
    public static final long maxPower = 10000000L;
    public long power;
    public boolean operational = false;
    public boolean enableDrill = false;
    public boolean enableCrusher = false;
    public boolean enableWalling = false;
    public boolean enableVeinMiner = false;
    public boolean enableSilkTouch = false;
    public boolean hasNullifier = false;
    protected int ticksWorked = 0;
    protected int targetDepth = 0;
    protected boolean bedrockDrilling = false;
    public float drillRotation = 0.0f;
    public float prevDrillRotation = 0.0f;
    public float drillExtension = 0.0f;
    public float prevDrillExtension = 0.0f;
    public float crusherRotation = 0.0f;
    public float prevCrusherRotation = 0.0f;
    public int chuteTimer = 0;
    public double speed = 1.0;
    public final long baseConsumption = 10000L;
    public long consumption = 10000L;
    protected int drillRating = 0;
    public FluidTank tank;
    public Fluid fluidType = null;
    private final UpgradeManager upgradeManager = new UpgradeManager();
    private HashSet<BlockPos> recursionBrake = new HashSet();
    private int minX = 0;
    private int minY = 0;
    private int minZ = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int maxZ = 0;

    public TileEntityMachineExcavator() {
        super(14);
        this.tank = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.machineExcavator";
    }

    public boolean hasEnoughPower() {
        if (this.bedrockDrilling) {
            return this.power >= this.getPowerConsumption() * 20L;
        }
        return this.power >= this.getPowerConsumption();
    }

    public void func_73660_a() {
        this.upgradeManager.eval((IItemHandler)this.inventory, 2, 3);
        int speedLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 10);
        int powerLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
        this.hasNullifier = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.NULLIFIER) > 0;
        this.consumption = 10000L * (long)(1 + speedLevel);
        this.consumption /= (long)(1 + powerLevel);
        if (!this.field_145850_b.field_72995_K) {
            this.updateTankType();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.tryEjectBuffer();
                for (DirPos posDir : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, posDir.getPos(), posDir.getDir());
                }
            }
            if (this.chuteTimer > 0) {
                --this.chuteTimer;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.getPower(), this.getMaxPower());
            this.operational = false;
            int radiusLevel = Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT), 3);
            ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
            if (this.enableDrill && type != null && this.hasEnoughPower()) {
                this.drillRating = (int)(type.speed * 80.0);
                this.operational = true;
                this.power = this.bedrockDrilling ? (this.power -= this.getPowerConsumption() * 10L) : (this.power -= this.getPowerConsumption());
                this.speed = type.speed;
                this.speed *= 1.0 + (double)speedLevel / 2.0;
                int maxDepth = this.field_174879_c.func_177956_o() - 4;
                if ((this.bedrockDrilling || this.targetDepth <= maxDepth) && this.tryDrill(1 + radiusLevel * 2)) {
                    ++this.targetDepth;
                    if (this.targetDepth > maxDepth) {
                        this.enableDrill = false;
                    }
                }
            } else {
                this.targetDepth = 0;
                this.drillRating = 0;
            }
            if (this.shouldSendNetworkUpdate()) {
                NBTTagCompound data = new NBTTagCompound();
                this.tank.writeToNBT(data);
                if (this.fluidType != null) {
                    data.func_74778_a("f", this.fluidType.getName());
                }
                data.func_74757_a("d", this.enableDrill);
                data.func_74757_a("c", this.enableCrusher);
                data.func_74757_a("w", this.enableWalling);
                data.func_74757_a("v", this.enableVeinMiner);
                data.func_74757_a("s", this.enableSilkTouch);
                data.func_74757_a("o", this.operational);
                data.func_74768_a("t", this.targetDepth);
                data.func_74768_a("g", this.chuteTimer);
                data.func_74772_a("p", this.power);
                this.networkPack(data, 150);
            }
        } else {
            this.prevDrillExtension = this.drillExtension;
            if (this.drillExtension != (float)this.targetDepth) {
                float speed;
                float diff = Math.abs(this.drillExtension - (float)this.targetDepth);
                if (diff <= (speed = Math.max(0.15f, diff / 10.0f))) {
                    this.drillExtension = this.targetDepth;
                } else {
                    float sig = Math.signum(this.drillExtension - (float)this.targetDepth);
                    this.drillExtension -= sig * speed;
                }
            }
            this.prevDrillRotation = this.drillRotation;
            this.prevCrusherRotation = this.crusherRotation;
            if (this.operational) {
                this.drillRotation += 5.0f;
                if (this.enableCrusher) {
                    this.crusherRotation += 10.0f;
                }
            }
            if (this.drillRotation >= 360.0f) {
                this.drillRotation -= 360.0f;
                this.prevDrillRotation -= 360.0f;
            }
            if (this.crusherRotation >= 360.0f) {
                this.crusherRotation -= 360.0f;
                this.prevCrusherRotation -= 360.0f;
            }
        }
    }

    private void updateTankType() {
        Fluid fluid;
        ItemStack slotStack = this.inventory.getStackInSlot(1);
        if (slotStack.func_77973_b() == ModItems.forge_fluid_identifier && this.fluidType != (fluid = ItemForgeFluidIdentifier.getType(slotStack))) {
            this.fluidType = fluid;
            this.tank.setFluid(null);
            this.func_70296_d();
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX * 4 + rot.offsetX, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + dir.offsetZ * 4 + rot.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX * 4 - rot.offsetX, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + dir.offsetZ * 4 - rot.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() + rot.offsetX * 4, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + rot.offsetZ * 4, rot), new DirPos(this.field_174879_c.func_177958_n() - rot.offsetX * 4, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - rot.offsetZ * 4, rot.getOpposite())};
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt);
        if (nbt.func_74764_b("f")) {
            this.fluidType = FluidRegistry.getFluid((String)nbt.func_74779_i("f"));
        }
        this.enableDrill = nbt.func_74767_n("d");
        this.enableCrusher = nbt.func_74767_n("c");
        this.enableWalling = nbt.func_74767_n("w");
        this.enableVeinMiner = nbt.func_74767_n("v");
        this.enableSilkTouch = nbt.func_74767_n("s");
        this.operational = nbt.func_74767_n("o");
        this.targetDepth = nbt.func_74762_e("t");
        this.chuteTimer = nbt.func_74762_e("g");
        this.power = nbt.func_74763_f("p");
    }

    protected int getY() {
        return this.field_174879_c.func_177956_o() - this.targetDepth - 4;
    }

    protected boolean tryDrill(int radius) {
        int y = this.getY();
        if (this.targetDepth == 0 || y == 0) {
            radius = 1;
        }
        int installedTier = this.getInstalledDrill().tier;
        for (int ring = 1; ring <= radius; ++ring) {
            boolean ignoreAll = true;
            float combinedHardness = 0.0f;
            BlockPos bedrockOre = null;
            this.bedrockDrilling = false;
            block1: for (int x = this.field_174879_c.func_177958_n() - ring; x <= this.field_174879_c.func_177958_n() + ring; ++x) {
                for (int z = this.field_174879_c.func_177952_p() - ring; z <= this.field_174879_c.func_177952_p() + ring; ++z) {
                    if (ring != 1 && x != this.field_174879_c.func_177958_n() - ring && x != this.field_174879_c.func_177958_n() + ring && z != this.field_174879_c.func_177952_p() - ring && z != this.field_174879_c.func_177952_p() + ring) continue;
                    BlockPos drillPos = new BlockPos(x, y, z);
                    IBlockState bState = this.field_145850_b.func_180495_p(drillPos);
                    Block b = bState.func_177230_c();
                    if (b == ModBlocks.ore_bedrock_block) {
                        double tierDiff = (double)((BlockBedrockOreTE.TileEntityBedrockOre)this.field_145850_b.func_175625_s((BlockPos)drillPos)).tier / (double)installedTier;
                        combinedHardness = (int)(2400.0 * tierDiff);
                        bedrockOre = new BlockPos(x, y, z);
                        this.bedrockDrilling = true;
                        this.enableCrusher = false;
                        this.enableSilkTouch = false;
                        ignoreAll = false;
                        continue block1;
                    }
                    if (this.shouldIgnoreBlock(bState, drillPos)) continue;
                    ignoreAll = false;
                    combinedHardness += bState.func_185887_b(this.field_145850_b, drillPos);
                }
            }
            if (!ignoreAll) {
                ++this.ticksWorked;
                int ticksToWork = (int)Math.ceil((double)combinedHardness / this.speed);
                if (this.ticksWorked >= ticksToWork) {
                    if (bedrockOre == null) {
                        this.breakBlocks(ring);
                        this.buildWall(ring + 1, ring == radius && this.enableWalling);
                        if (ring == radius) {
                            this.mineOresFromWall(ring + 1);
                        }
                        this.tryCollect(radius + 1);
                    } else {
                        this.collectBedrock(bedrockOre);
                    }
                    this.ticksWorked = 0;
                }
                return false;
            }
            this.tryCollect(radius + 1);
        }
        this.buildWall(radius + 1, this.enableWalling);
        this.ticksWorked = 0;
        return true;
    }

    protected void breakBlocks(int ring) {
        int y = this.getY();
        for (int x = this.field_174879_c.func_177958_n() - ring; x <= this.field_174879_c.func_177958_n() + ring; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - ring; z <= this.field_174879_c.func_177952_p() + ring; ++z) {
                BlockPos drillPos;
                IBlockState bState;
                if (ring != 1 && x != this.field_174879_c.func_177958_n() - ring && x != this.field_174879_c.func_177958_n() + ring && z != this.field_174879_c.func_177952_p() - ring && z != this.field_174879_c.func_177952_p() + ring || this.shouldIgnoreBlock(bState = this.field_145850_b.func_180495_p(drillPos = new BlockPos(x, y, z)), drillPos)) continue;
                this.tryMineAtLocation(bState, drillPos);
            }
        }
    }

    public void tryMineAtLocation(IBlockState bState, BlockPos drillPos) {
        if (this.enableVeinMiner && this.getInstalledDrill().vein && this.isOreDictOre(bState.func_177230_c())) {
            this.minX = drillPos.func_177958_n();
            this.minY = drillPos.func_177956_o();
            this.minZ = drillPos.func_177952_p();
            this.maxX = drillPos.func_177958_n();
            this.maxY = drillPos.func_177956_o();
            this.maxZ = drillPos.func_177952_p();
            this.breakRecursively(drillPos, 10);
            this.recursionBrake.clear();
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1)));
            for (EntityItem item : items) {
                item.func_70107_b((double)drillPos.func_177958_n() + 0.5, (double)drillPos.func_177956_o() + 0.5, (double)drillPos.func_177952_p() + 0.5);
            }
            return;
        }
        this.breakSingleBlock(bState, drillPos);
    }

    protected boolean isOreDictOre(Block b) {
        Item blockItem = Item.func_150898_a((Block)b);
        if (blockItem != null && blockItem != Items.field_190931_a) {
            List<String> names = ItemStackUtil.getOreDictNames(new ItemStack(blockItem));
            for (String name : names) {
                if (!name.startsWith("ore")) continue;
                return true;
            }
        }
        return false;
    }

    protected void breakRecursively(BlockPos drillPos, int depth) {
        if (depth < 0) {
            return;
        }
        if (this.recursionBrake.contains(drillPos)) {
            return;
        }
        this.recursionBrake.add(drillPos);
        IBlockState bState = this.field_145850_b.func_180495_p(drillPos);
        Block b = bState.func_177230_c();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockPos veinPos = drillPos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ);
            if (this.field_145850_b.func_180495_p(veinPos).func_177230_c() != b) continue;
            this.breakRecursively(veinPos, depth - 1);
        }
        this.breakSingleBlock(bState, drillPos);
        int x = drillPos.func_177958_n();
        int y = drillPos.func_177956_o();
        int z = drillPos.func_177952_p();
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        if (this.enableWalling) {
            this.field_145850_b.func_175656_a(drillPos, ModBlocks.barricade.func_176223_P());
        }
    }

    @Override
    public IMiningDrill.DrillType getDrillTier() {
        return IMiningDrill.DrillType.INDUSTRIAL;
    }

    @Override
    public int getDrillRating() {
        return this.drillRating;
    }

    protected void breakSingleBlock(IBlockState bState, BlockPos drillPos) {
        Block b = bState.func_177230_c();
        NonNullList items = NonNullList.func_191196_a();
        b.getDrops(items, (IBlockAccess)this.field_145850_b, drillPos, bState, this.getFortuneLevel());
        if (b == ModBlocks.barricade) {
            items.clear();
        } else {
            Iterator drop;
            IDrillInteraction in;
            if (this.canSilkTouch()) {
                ItemStack result = new ItemStack(Item.func_150898_a((Block)b), 1, b.func_176201_c(bState));
                if (result != null && !result.func_190926_b()) {
                    items.clear();
                    items.add((Object)result.func_77946_l());
                }
            } else if (b instanceof IDrillInteraction && (in = (IDrillInteraction)b).canBreak(this.field_145850_b, drillPos.func_177958_n(), drillPos.func_177956_o(), drillPos.func_177952_p(), bState, this) && (drop = in.extractResource(this.field_145850_b, drillPos.func_177958_n(), drillPos.func_177956_o(), drillPos.func_177952_p(), bState, this)) != null) {
                items.clear();
                items.add((Object)drop.func_77946_l());
            }
            if (this.enableCrusher) {
                NonNullList list = NonNullList.func_191196_a();
                for (ItemStack stack : items) {
                    ItemStack crushed = ShredderRecipes.getShredderResult(stack).func_77946_l();
                    if (crushed.func_77973_b() == ModItems.scrap || crushed.func_77973_b() == ModItems.dust) {
                        list.add((Object)stack);
                        continue;
                    }
                    crushed.func_190920_e(crushed.func_190916_E() * stack.func_190916_E());
                    list.add((Object)crushed);
                }
                items = list;
            }
            if (this.hasNullifier) {
                NonNullList goodList = NonNullList.func_191196_a();
                for (ItemStack stack : items) {
                    if (ItemMachineUpgrade.scrapItems.contains(stack.func_77973_b())) continue;
                    goodList.add((Object)stack);
                }
                items = goodList;
            }
        }
        for (ItemStack item : items) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)drillPos.func_177958_n() + 0.5, (double)drillPos.func_177956_o() + 0.5, (double)drillPos.func_177952_p() + 0.5, item));
        }
        this.field_145850_b.func_175655_b(drillPos, false);
    }

    protected void buildWall(int ring, boolean wallEverything) {
        int y = this.getY();
        for (int x = this.field_174879_c.func_177958_n() - ring; x <= this.field_174879_c.func_177958_n() + ring; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - ring; z <= this.field_174879_c.func_177952_p() + ring; ++z) {
                BlockPos wallPos = new BlockPos(x, y, z);
                IBlockState bState = this.field_145850_b.func_180495_p(wallPos);
                if (x == this.field_174879_c.func_177958_n() - ring || x == this.field_174879_c.func_177958_n() + ring || z == this.field_174879_c.func_177952_p() - ring || z == this.field_174879_c.func_177952_p() + ring) {
                    if (!bState.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, wallPos) || !wallEverything && !bState.func_185904_a().func_76224_d()) continue;
                    this.field_145850_b.func_175656_a(wallPos, ModBlocks.barricade.func_176223_P());
                    continue;
                }
                if (!bState.func_185904_a().func_76224_d()) continue;
                this.field_145850_b.func_175698_g(wallPos);
            }
        }
    }

    protected void mineOresFromWall(int ring) {
        int y = this.getY();
        for (int x = this.field_174879_c.func_177958_n() - ring; x <= this.field_174879_c.func_177958_n() + ring; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - ring; z <= this.field_174879_c.func_177952_p() + ring; ++z) {
                BlockPos drillPos;
                IBlockState bState;
                if (ring != 1 && x != this.field_174879_c.func_177958_n() - ring && x != this.field_174879_c.func_177958_n() + ring && z != this.field_174879_c.func_177952_p() - ring && z != this.field_174879_c.func_177952_p() + ring || this.shouldIgnoreBlock(bState = this.field_145850_b.func_180495_p(drillPos = new BlockPos(x, y, z)), drillPos) || !this.isOreDictOre(bState.func_177230_c())) continue;
                this.tryMineAtLocation(bState, drillPos);
            }
        }
    }

    protected void tryEjectBuffer() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX * 4, -3, dir.offsetZ * 4));
        if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.toEnumFacing())) {
            return;
        }
        IItemHandler h = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.toEnumFacing());
        for (int i = 5; i < 14; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() && this.inventory.getStackInSlot(i).func_190916_E() > 0) continue;
            this.tryFillContainerCap(h, i);
        }
    }

    @Override
    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        return this.tryInsertItemCap(chest, this.inventory.getStackInSlot(slot));
    }

    public boolean tryInsertItemCap(IItemHandler chest, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = stack.func_77946_l();
            if (outputStack.func_190926_b() || outputStack.func_190916_E() == 0) {
                return true;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            int fillAmount = Math.min(chestItem.func_77976_d() - chestItem.func_190916_E(), outputStack.func_190916_E());
            outputStack.func_190920_e(fillAmount);
            ItemStack rest = chest.insertItem(i, outputStack, true);
            if (rest.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) continue;
            stack.func_190918_g(outputStack.func_190916_E());
            chest.insertItem(i, outputStack, false);
        }
        return false;
    }

    protected void tryCollect(int radius) {
        int yLevel = this.getY();
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - radius), (double)(yLevel - 1), (double)(this.field_174879_c.func_177952_p() - radius), (double)(this.field_174879_c.func_177958_n() + radius + 1), (double)(yLevel + 2), (double)(this.field_174879_c.func_177952_p() + radius + 1)));
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(dir.offsetX * 4, -3, dir.offsetZ * 4));
        this.supplyContainer(tile, items, dir.getOpposite());
        for (EntityItem entityItem : items) {
            if (entityItem.field_70128_L) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_190916_E() <= 0 || stack.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            if ((stack = InventoryUtil.tryAddItemToInventory((IItemHandlerModifiable)this.inventory, 5, 13, stack)).func_190916_E() <= 0 || stack.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            entityItem.func_92058_a(stack);
            this.chuteTimer = 40;
        }
    }

    protected void supplyContainer(TileEntity te, List<EntityItem> items, ForgeDirection dir) {
        if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.toEnumFacing())) {
            return;
        }
        IItemHandler h = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.toEnumFacing());
        if (!(h instanceof IItemHandlerModifiable)) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)h;
        for (EntityItem entityItem : items) {
            if (entityItem.field_70128_L) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_190916_E() <= 0 || stack.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            stack = InventoryUtil.tryAddItemToInventory(inv, 0, inv.getSlots() - 1, stack);
            this.chuteTimer = 40;
            if (stack.func_190916_E() <= 0 || stack.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            entityItem.func_92058_a(stack);
        }
    }

    protected void collectBedrock(BlockPos pos) {
        if (this.tank.getFluid() == null) {
            return;
        }
        TileEntity oreTile = this.field_145850_b.func_175625_s(pos);
        if (oreTile instanceof BlockBedrockOreTE.TileEntityBedrockOre) {
            BlockBedrockOreTE.TileEntityBedrockOre ore = (BlockBedrockOreTE.TileEntityBedrockOre)oreTile;
            if (ore.oreName == null) {
                return;
            }
            if (ore.tier > this.getInstalledDrill().tier) {
                return;
            }
            if (ore.acidRequirement != null) {
                if (ore.acidRequirement.getFluid() != this.tank.getFluid().getFluid() || ore.acidRequirement.amount > this.tank.getFluidAmount()) {
                    return;
                }
                this.tank.drain(ore.acidRequirement.amount, true);
            }
            ItemStack bedrockOreStack = new ItemStack(ModItems.ore_bedrock, 1, BedrockOreRegistry.getOreIndex(ore.oreName));
            InventoryUtil.tryAddItemToInventory((IItemHandlerModifiable)this.inventory, 5, 13, bedrockOreStack);
        }
    }

    public long getPowerConsumption() {
        return this.consumption;
    }

    public int getFortuneLevel() {
        ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
        if (type != null) {
            return type.fortune;
        }
        return 0;
    }

    public boolean shouldIgnoreBlock(IBlockState block, BlockPos pos) {
        Block b = block.func_177230_c();
        if (b == Blocks.field_150350_a) {
            return true;
        }
        if (b == Blocks.field_150357_h) {
            return true;
        }
        if (b instanceof BlockGasBase) {
            return true;
        }
        float hardness = block.func_185887_b(this.field_145850_b, pos);
        if (hardness < 0.0f || hardness > 3500000.0f) {
            return true;
        }
        return block.func_185904_a().func_76224_d();
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("drill")) {
            boolean bl = this.enableDrill = !this.enableDrill;
        }
        if (data.func_74764_b("walling")) {
            boolean bl = this.enableWalling = !this.enableWalling;
        }
        if (data.func_74764_b("veinminer")) {
            boolean bl = this.enableVeinMiner = !this.enableVeinMiner;
        }
        if (data.func_74764_b("silktouch")) {
            if (!this.enableSilkTouch && this.enableCrusher) {
                this.enableCrusher = false;
            }
            boolean bl = this.enableSilkTouch = !this.enableSilkTouch;
        }
        if (data.func_74764_b("crusher")) {
            if (!this.enableCrusher && this.enableSilkTouch) {
                this.enableSilkTouch = false;
            }
            this.enableCrusher = !this.enableCrusher;
        }
        this.func_70296_d();
    }

    public ItemDrillbit.EnumDrillType getInstalledDrill() {
        ItemStack slotItem = this.inventory.getStackInSlot(4);
        if (slotItem != null && slotItem.func_77973_b() instanceof ItemDrillbit) {
            return ((ItemDrillbit)slotItem.func_77973_b()).drillType;
        }
        return null;
    }

    public boolean canVeinMine() {
        ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
        return this.enableVeinMiner && type != null && type.vein;
    }

    public boolean canSilkTouch() {
        ItemDrillbit.EnumDrillType type = this.getInstalledDrill();
        return this.enableSilkTouch && type != null && type.silk;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt);
        if (nbt.func_74764_b("f")) {
            this.fluidType = FluidRegistry.getFluid((String)nbt.func_74779_i("f"));
        }
        this.enableDrill = nbt.func_74767_n("d");
        this.enableCrusher = nbt.func_74767_n("c");
        this.enableWalling = nbt.func_74767_n("w");
        this.enableVeinMiner = nbt.func_74767_n("v");
        this.enableSilkTouch = nbt.func_74767_n("s");
        this.targetDepth = nbt.func_74762_e("t");
        this.power = nbt.func_74763_f("p");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.tank.writeToNBT(nbt);
        if (this.fluidType != null) {
            nbt.func_74778_a("f", this.fluidType.getName());
        }
        nbt.func_74757_a("d", this.enableDrill);
        nbt.func_74757_a("c", this.enableCrusher);
        nbt.func_74757_a("w", this.enableWalling);
        nbt.func_74757_a("v", this.enableVeinMiner);
        nbt.func_74757_a("s", this.enableSilkTouch);
        nbt.func_74768_a("t", this.targetDepth);
        nbt.func_74772_a("p", this.power);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.isUseableByPlayer(player);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineExcavator(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineExcavator(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && (this.fluidType == null || resource.getFluid() == this.fluidType) && resource.amount > 0) {
            this.fluidType = resource.getFluid();
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }
}

