/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineBoiler;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.HeatRecipes;
import com.hbm.items.machine.ItemRTGPellet;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineBoilerRTG
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public int rtgPower;
    public int heat = 2000;
    public static final int maxRTGPower = 6000;
    public static final int maxHeat = 100000;
    public int age = 0;
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{4};
    private static final int[] slots_bottom = new int[]{7};
    private static final int[] slots_side = new int[]{4};
    private boolean needsUpdate = false;
    private int detectRTGPower;
    private int detectHeat;
    private FluidTank[] detectTanks = new FluidTank[]{null, null};

    public TileEntityMachineBoilerRTG() {
        super(8);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(16000);
    }

    @Override
    public String getName() {
        return "container.machineRTGBoiler";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 4 || i == 5) {
            return stack != null && stack.func_77973_b() instanceof ItemRTGPellet;
        }
        if (i == 2 || i == 6) {
            return stack != null && !(stack.func_77973_b() instanceof ItemRTGPellet);
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.heat = nbt.func_74762_e("heat");
        this.rtgPower = nbt.func_74762_e("rtgPower");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("rtgPower", this.rtgPower);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 100000;
    }

    public long getRTGPowerScaled(int i) {
        return this.rtgPower * i / 6000;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[1]);
            }
            Object[] outs = this.tanks[0].getFluid() != null ? HeatRecipes.getBoilerOutput(this.tanks[0].getFluid().getFluid()) : HeatRecipes.getBoilerOutput(null);
            if (this.inputValidForTank(0, 2) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 2, 3)) {
                this.needsUpdate = true;
            }
            if (FFUtils.fillFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 6, 7)) {
                this.needsUpdate = true;
            }
            if (this.heat > 2000) {
                this.heat -= 40;
            }
            this.rtgPower = Math.min(RTGUtil.updateRTGs(this.inventory, new int[]{4, 5}), 6000);
            this.heat = this.rtgPower > 0 ? (this.heat += this.rtgPower * 5) : (this.heat -= 100);
            if (this.rtgPower <= 0 && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.machine_boiler_rtg_on) {
                this.rtgPower = 0;
                MachineBoiler.updateBlockState(false, this.field_145850_b, this.field_174879_c);
            }
            if (this.heat > 100000) {
                this.heat = 100000;
            }
            if (this.rtgPower > 0 && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.machine_boiler_rtg_off) {
                MachineBoiler.updateBlockState(true, this.field_145850_b, this.field_174879_c);
            }
            if (outs != null) {
                for (int i = 0; i < this.heat / (Integer)outs[3]; ++i) {
                    if (this.tanks[0].getFluidAmount() < (Integer)outs[2] * 5 || this.tanks[1].getFluidAmount() + (Integer)outs[1] * 5 > this.tanks[1].getCapacity()) continue;
                    this.tanks[0].drain((Integer)outs[2] * 5, true);
                    this.tanks[1].fill(new FluidStack((Fluid)outs[0], (Integer)outs[1] * 5), true);
                    this.needsUpdate = true;
                    if (i == 0) {
                        this.heat -= 45;
                        continue;
                    }
                    this.heat -= 60;
                }
            }
            if (this.heat < 2000) {
                this.heat = 2000;
            }
            this.detectAndSendChanges();
        }
    }

    public void fillFluidInit(FluidTank tank) {
        boolean update = this.needsUpdate;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177976_e(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177974_f(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177977_b(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177984_a(), 16000) || update;
        update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177978_c(), 16000) || update;
        this.needsUpdate = update = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177968_d(), 16000) || update;
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return HeatRecipes.hasBoilRecipe(stack.getFluid());
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tanks[1].getFluid())) {
            return null;
        }
        return this.tanks[1].drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectHeat != this.heat) {
            this.detectHeat = this.heat;
            mark = true;
        }
        if (this.detectRTGPower != this.rtgPower) {
            this.detectRTGPower = this.rtgPower;
            mark = true;
        }
        if (!FFUtils.areTanksEqual(this.tanks[0], this.detectTanks[0])) {
            this.needsUpdate = true;
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
            mark = true;
        }
        if (!FFUtils.areTanksEqual(this.tanks[1], this.detectTanks[1])) {
            this.needsUpdate = true;
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
            mark = true;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.heat, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rtgPower, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (mark) {
            this.func_70296_d();
        }
    }
}

