/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyGenerator;
import api.hbm.energy.IEnergyUser;
import api.hbm.energy.Nodespace;
import com.hbm.blocks.machine.MachineBattery;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandlerModifiable;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineBattery
extends TileEntityMachineBase
implements ITickable,
IEnergyConductor,
IEnergyGenerator,
IEnergyUser,
SimpleComponent {
    public long[] log = new long[20];
    public long powerDelta = 0L;
    public long power = 0L;
    public long prevPowerState = 0L;
    protected Nodespace.PowerNode node;
    public static final int mode_input = 0;
    public static final int mode_buffer = 1;
    public static final int mode_output = 2;
    public static final int mode_none = 3;
    public short redLow = 0;
    public short redHigh = (short)2;
    public IEnergyUser.ConnectionPriority priority = IEnergyUser.ConnectionPriority.NORMAL;
    public byte lastRedstone = 0;
    private String customName;
    private short modeCache = 0;
    private long bufferedMax;

    public TileEntityMachineBattery() {
        super(4);
    }

    public static ForgeDirection[] getSendDirections() {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    @Override
    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.battery";
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
    }

    @Override
    public String getName() {
        return "container.battery";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / this.getMaxPower();
    }

    public byte getComparatorPower() {
        if (this.power == 0L) {
            return 0;
        }
        double frac = (double)this.power / (double)this.getMaxPower() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74777_a("redLow", this.redLow);
        compound.func_74777_a("redHigh", this.redHigh);
        compound.func_74774_a("lastRedstone", this.lastRedstone);
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.redLow = compound.func_74765_d("redLow");
        this.redHigh = compound.func_74765_d("redHigh");
        this.lastRedstone = compound.func_74771_c("lastRedstone");
        this.priority = IEnergyUser.ConnectionPriority.values()[compound.func_74771_c("priority")];
        super.func_145839_a(compound);
    }

    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74772_a("prevPowerState", this.prevPowerState);
        data.func_74777_a("redLow", this.redLow);
        data.func_74777_a("redHigh", this.redHigh);
        data.func_74768_a("priority", this.priority.ordinal());
        nbt.func_74782_a("NBT_PERSISTENT_KEY", (NBTBase)data);
    }

    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("NBT_PERSISTENT_KEY");
        this.power = data.func_74763_f("power");
        this.prevPowerState = data.func_74763_f("prevPowerState");
        this.redLow = data.func_74765_d("redLow");
        this.redHigh = data.func_74765_d("redHigh");
        this.priority = IEnergyUser.ConnectionPriority.values()[data.func_74762_e("priority")];
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing p_94128_1_) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        IBatteryItem batteryItem;
        if (i == 0 && stack.func_77973_b() instanceof IBatteryItem && (batteryItem = (IBatteryItem)stack.func_77973_b()).getCharge(stack) > 0L && batteryItem.getDischargeRate() > 0L) {
            return true;
        }
        return i == 2 && stack.func_77973_b() instanceof IBatteryItem && (batteryItem = (IBatteryItem)stack.func_77973_b()).getCharge(stack) < batteryItem.getMaxCharge() && batteryItem.getChargeRate() > 0L;
    }

    @Override
    public boolean canInsertItem(int i, ItemStack itemStack, int j) {
        return this.isItemValidForSlot(i, itemStack);
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i == 1 || i == 3;
    }

    public void tryMoveItems() {
        IBatteryItem itemFill;
        ItemStack itemStackFill;
        IBatteryItem itemDrain;
        ItemStack itemStackDrain = this.inventory.getStackInSlot(0);
        if (itemStackDrain.func_77973_b() instanceof IBatteryItem && (itemDrain = (IBatteryItem)itemStackDrain.func_77973_b()).getCharge(itemStackDrain) == 0L && (this.inventory.getStackInSlot(1) == null || this.inventory.getStackInSlot(1).func_190926_b())) {
            this.inventory.setStackInSlot(1, itemStackDrain);
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if ((itemStackFill = this.inventory.getStackInSlot(2)).func_77973_b() instanceof IBatteryItem && (itemFill = (IBatteryItem)itemStackFill.func_77973_b()).getCharge(itemStackFill) == itemFill.getMaxCharge() && (this.inventory.getStackInSlot(3) == null || this.inventory.getStackInSlot(3).func_190926_b())) {
            this.inventory.setStackInSlot(3, itemStackFill);
            this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.priority == null || this.priority.ordinal() == 0 || this.priority.ordinal() == 4) {
                this.priority = IEnergyUser.ConnectionPriority.LOW;
            }
            short mode = this.getRelevantMode(false);
            if (this.node == null || this.node.expired) {
                this.node = Nodespace.getNode(this.field_145850_b, this.field_174879_c);
                if (this.node == null || this.node.expired) {
                    this.node = this.createNode();
                    Nodespace.createNode(this.field_145850_b, this.node);
                }
            }
            long prevPower = this.power;
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 2, this.power, this.getMaxPower());
            if (mode == 2 || mode == 1) {
                this.sendPower(this.field_145850_b, this.field_174879_c, ForgeDirection.UNKNOWN);
            } else if (this.node != null && this.node.hasValidNet()) {
                this.node.net.removeProvider(this);
            }
            byte comp = this.getComparatorPower();
            this.tryMoveItems();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            if (mode == 0 || mode == 1) {
                if (this.node != null && this.node.hasValidNet()) {
                    this.node.net.addReceiver(this);
                }
            } else if (this.node != null && this.node.hasValidNet()) {
                this.node.net.removeReceiver(this);
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, this.getMaxPower());
            long avg = (this.power + prevPower) / 2L;
            this.powerDelta = avg - this.log[0];
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[19] = avg;
            this.prevPowerState = this.power;
            this.networkPack(this.packNBT(), 20);
        }
    }

    public NBTTagCompound packNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("delta", this.powerDelta);
        nbt.func_74777_a("redLow", this.redLow);
        nbt.func_74777_a("redHigh", this.redHigh);
        nbt.func_74774_a("priority", (byte)this.priority.ordinal());
        return nbt;
    }

    public void onNodeDestroyedCallback() {
        this.node = null;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.node != null) {
            Nodespace.destroyNode(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public long getProviderSpeed() {
        short mode = this.getRelevantMode(true);
        return mode == 2 || mode == 1 ? this.getMaxPower() / 20L : 0L;
    }

    @Override
    public long getReceiverSpeed() {
        short mode = this.getRelevantMode(true);
        return mode == 0 || mode == 1 ? this.getMaxPower() / 20L : 0L;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        super.networkUnpack(nbt);
        this.power = nbt.func_74763_f("power");
        this.powerDelta = nbt.func_74763_f("delta");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.priority = IEnergyUser.ConnectionPriority.values()[nbt.func_74771_c("priority")];
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public short getRelevantMode(boolean useCache) {
        if (useCache) {
            return this.modeCache;
        }
        boolean isPowered = this.field_145850_b.func_175640_z(this.field_174879_c) || this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        this.modeCache = isPowered ? this.redHigh : this.redLow;
        return this.modeCache;
    }

    @Override
    public long getMaxPower() {
        if (this.bufferedMax == 0L) {
            this.bufferedMax = ((MachineBattery)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getMaxPower();
        }
        return this.bufferedMax;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public IEnergyUser.ConnectionPriority getPriority() {
        return this.priority;
    }

    public String getComponentName() {
        return "battery";
    }

    @Callback(doc="getPower(); returns the current power level - long")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    @Callback(doc="getMaxPower(); returns the maximum power level - long")
    public Object[] getMaxPower(Context context, Arguments args) {
        return new Object[]{this.getMaxPower()};
    }

    @Callback(doc="getChargePercent(); returns the charge in percent - double")
    public Object[] getChargePercent(Context context, Arguments args) {
        return new Object[]{100.0 * (double)this.getPower() / (double)this.getMaxPower()};
    }

    @Callback(doc="getPowerDelta(); returns the in/out power flow - long")
    public Object[] getPowerDelta(Context context, Arguments args) {
        return new Object[]{this.powerDelta};
    }

    @Callback(doc="getPriority(); returns the priority (1:low, 2:normal, 3:high) - int")
    public Object[] getPriority(Context context, Arguments args) {
        return new Object[]{1 + this.getPriority().ordinal()};
    }

    @Callback(doc="setPriority(int prio); sets the priority (1:low, 2:normal, 3:high)")
    public Object[] setPriority(Context context, Arguments args) {
        int prio = args.checkInteger(0);
        if (prio == 1) {
            this.priority = IEnergyUser.ConnectionPriority.LOW;
        }
        if (prio == 2) {
            this.priority = IEnergyUser.ConnectionPriority.NORMAL;
        }
        if (prio == 3) {
            this.priority = IEnergyUser.ConnectionPriority.HIGH;
        }
        return new Object[]{null};
    }
}

