/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandler;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachineAssembler
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public static final long maxPower = 2000000L;
    public int progress;
    public boolean needsProcess = true;
    public int maxProgress = 100;
    public boolean isProgressing;
    protected int age = 0;
    protected int consumption = 100;
    protected int speed = 100;
    @SideOnly(value=Side.CLIENT)
    public int recipe;
    private AudioWrapper audio;

    public TileEntityMachineAssembler(int scount) {
        super(scount);
    }

    public TileEntityMachineAssembler() {
        super(18);
        this.inventory = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                TileEntityMachineAssembler.this.func_70296_d();
                TileEntityMachineAssembler.this.OnContentsChanged(slot);
                super.onContentsChanged(slot);
            }
        };
    }

    public void OnContentsChanged(int slot) {
        this.needsProcess = true;
    }

    @Override
    public String getName() {
        return "container.assembler";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.isProgressing = nbt.func_74767_n("progressing");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("progressing", this.isProgressing);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 2000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / Math.max(10, this.maxProgress);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IItemHandler cap;
            this.updateConnections();
            this.consumption = 100;
            this.speed = 100;
            double c = 100.0;
            double s = 100.0;
            for (int i = 1; i < 4; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                    s *= 0.75;
                    c *= 3.0;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                    s *= 0.65;
                    c *= 6.0;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                    s *= 0.5;
                    c *= 9.0;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                    c *= 0.8;
                    s *= 1.25;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                    c *= 0.4;
                    s *= 1.5;
                }
                if (stack.func_77973_b() != ModItems.upgrade_power_3) continue;
                c *= 0.2;
                s *= 2.0;
            }
            this.speed = (int)s;
            this.consumption = (int)c;
            if (this.speed < 2) {
                this.speed = 2;
            }
            if (this.consumption < 2) {
                this.consumption = 2;
            }
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 2000000L);
            if (this.needsProcess && AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)) != ItemStack.field_190927_a && AssemblerRecipes.getRecipeFromTemplate(this.inventory.getStackInSlot(4)) != null) {
                this.maxProgress = ItemAssemblyTemplate.getProcessTime(this.inventory.getStackInSlot(4)) * this.speed / 100;
                if (this.removeItems(AssemblerRecipes.getRecipeFromTemplate(this.inventory.getStackInSlot(4)), (IItemHandlerModifiable)this.cloneItemStackProper((IItemHandlerModifiable)this.inventory))) {
                    if (this.power >= (long)this.consumption && (this.inventory.getStackInSlot(5).func_190926_b() || !this.inventory.getStackInSlot(5).func_190926_b() && this.inventory.getStackInSlot(5).func_77973_b() == AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l().func_77973_b() && this.inventory.getStackInSlot(5).func_190916_E() + AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l().func_190916_E() <= this.inventory.getStackInSlot(5).func_77976_d())) {
                        ++this.progress;
                        this.isProgressing = true;
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (this.inventory.getStackInSlot(5).func_190926_b()) {
                                this.inventory.setStackInSlot(5, AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l());
                            } else {
                                this.inventory.getStackInSlot(5).func_190917_f(AssemblerRecipes.getOutputFromTempate(this.inventory.getStackInSlot(4)).func_77946_l().func_190916_E());
                            }
                            this.removeItems(AssemblerRecipes.getRecipeFromTemplate(this.inventory.getStackInSlot(4)), (IItemHandlerModifiable)this.inventory);
                            if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.meteorite_sword_alloyed) {
                                this.inventory.setStackInSlot(0, new ItemStack(ModItems.meteorite_sword_machined));
                            }
                        }
                        this.power -= (long)this.consumption;
                    }
                } else {
                    this.progress = 0;
                    this.needsProcess = false;
                }
            } else {
                this.progress = 0;
            }
            int meta = this.func_145832_p();
            TileEntity te = null;
            TileEntity te2 = null;
            if (meta == 2) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, 0, 0));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(3, 0, -1));
            }
            if (meta == 3) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, 0, 0));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-3, 0, 1));
            }
            if (meta == 4) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 2));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-1, 0, -3));
            }
            if (meta == 5) {
                te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -2));
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(1, 0, 3));
            }
            if (!this.isProgressing) {
                this.tryExchangeTemplates(te, te2);
            }
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e()) && (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) != null) {
                this.tryFillContainerCap(cap, 5);
            }
            if (te2 != null && te2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e())) {
                cap = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                ItemStack template = this.inventory.getStackInSlot(4);
                List<RecipesCommon.AStack> recipes = AssemblerRecipes.getRecipeFromTemplate(template);
                if (recipes != null && AssemblerRecipes.getOutputFromTempate(template) != null) {
                    ArrayList<RecipesCommon.AStack> recipeIngredients = new ArrayList<RecipesCommon.AStack>(recipes);
                    if (te2 instanceof TileEntityMachineBase) {
                        int[] slots = ((TileEntityMachineBase)te2).getAccessibleSlotsFromSide(MultiblockHandler.intToEnumFacing(meta).func_176746_e());
                        this.tryFillAssemblerCap(cap, slots, (TileEntityMachineBase)te2, 6, 18, recipeIngredients);
                    } else if (cap != null) {
                        int[] slots = new int[cap.getSlots()];
                        for (int i = 0; i < slots.length; ++i) {
                            slots[i] = i;
                        }
                        this.tryFillAssemblerCap(cap, slots, null, 6, 18, recipeIngredients);
                    }
                }
            }
            if (this.shouldSendNetworkUpdate()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74772_a("power", this.power);
                data.func_74768_a("progress", this.progress);
                data.func_74768_a("maxProgress", this.maxProgress);
                data.func_74757_a("isProgressing", this.isProgressing);
                data.func_74768_a("recipe", !this.inventory.getStackInSlot(4).func_190926_b() ? ItemAssemblyTemplate.getRecipeIndex(this.inventory.getStackInSlot(4)) : -1);
                this.networkPack(data, 150);
            }
        } else {
            float volume = this.getVolume(2);
            if (this.isProgressing && volume > 0.0f) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound(HBMSoundHandler.assemblerOperate, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), volume, 1.0f);
                    this.audio.startSound();
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    private void updateConnections() {
        int meta = this.func_145832_p();
        if (meta == 5) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 0), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-2, 0, 1), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(3, 0, 1), Library.POS_X);
        } else if (meta == 3) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -2), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, -2), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 3), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 3), Library.POS_Z);
        } else if (meta == 4) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, 0), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(2, 0, -1), Library.POS_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, 0), Library.NEG_X);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-3, 0, -1), Library.NEG_X);
        } else if (meta == 2) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 2), Library.POS_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -3), Library.NEG_Z);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, -3), Library.NEG_Z);
        }
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.maxProgress = nbt.func_74762_e("maxProgress");
        this.isProgressing = nbt.func_74767_n("isProgressing");
        this.recipe = nbt.func_74762_e("recipe");
    }

    public boolean tryExchangeTemplates(TileEntity te1, TileEntity te2) {
        boolean te1Valid = this.validateTe(te1);
        boolean te2Valid = this.validateTe(te2);
        if (te1Valid && te2Valid) {
            int i;
            IItemHandlerModifiable iTe1 = Objects.requireNonNull((IItemHandlerModifiable)te1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            IItemHandlerModifiable iTe2 = Objects.requireNonNull((IItemHandlerModifiable)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            boolean openSlot = false;
            boolean existingTemplate = false;
            boolean filledContainer = false;
            for (i = 0; i < iTe1.getSlots(); ++i) {
                if (!iTe1.getStackInSlot(i).func_190926_b()) continue;
                openSlot = true;
                break;
            }
            if (!this.inventory.getStackInSlot(4).func_190926_b()) {
                existingTemplate = true;
            }
            for (i = 0; i < iTe2.getSlots(); ++i) {
                if (!(iTe2.getStackInSlot(i).func_77973_b() instanceof ItemAssemblyTemplate)) continue;
                if (openSlot && existingTemplate) {
                    filledContainer = this.tryFillContainerCap((IItemHandler)iTe1, 4);
                }
                if (!filledContainer && existingTemplate) continue;
                ItemStack copy = iTe2.getStackInSlot(i).func_77946_l();
                iTe2.setStackInSlot(i, ItemStack.field_190927_a);
                this.inventory.setStackInSlot(4, copy);
                return false;
            }
        }
        return false;
    }

    private boolean validateTe(TileEntity te) {
        return te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) instanceof IItemHandlerModifiable;
    }

    public ItemStackHandler cloneItemStackProper(IItemHandlerModifiable array) {
        ItemStackHandler stack = new ItemStackHandler(array.getSlots());
        for (int i = 0; i < array.getSlots(); ++i) {
            if (!array.getStackInSlot(i).func_190926_b()) {
                stack.setStackInSlot(i, array.getStackInSlot(i).func_77946_l());
                continue;
            }
            stack.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return stack;
    }

    protected int getValidSlot(RecipesCommon.AStack nextIngredient, int minSlot, int maxSlot) {
        int firstFreeSlot = -1;
        int stackCount = (int)Math.ceil((float)nextIngredient.count() / 64.0f);
        int stacksFound = 0;
        nextIngredient = nextIngredient.singulize();
        for (int k = minSlot; k < maxSlot; ++k) {
            if (stacksFound < stackCount) {
                ItemStack assStack = this.inventory.getStackInSlot(k);
                if (assStack.func_190926_b()) {
                    if (firstFreeSlot >= minSlot) continue;
                    firstFreeSlot = k;
                    continue;
                }
                if (!nextIngredient.isApplicable(assStack)) continue;
                if (this.inventory.getStackInSlot(k).func_190916_E() < assStack.func_77976_d()) {
                    return k;
                }
                ++stacksFound;
                continue;
            }
            return -1;
        }
        if (firstFreeSlot < minSlot) {
            return -2;
        }
        return firstFreeSlot;
    }

    public boolean tryFillAssemblerCap(IItemHandler container, int[] allowedSlots, TileEntityMachineBase te, int minSlot, int maxSlot, List<RecipesCommon.AStack> recipeIngredients) {
        if (allowedSlots.length < 1) {
            return false;
        }
        if (recipeIngredients == null) {
            return false;
        }
        HashMap<Integer, ItemStack> itemStackMap = new HashMap<Integer, ItemStack>();
        for (int slot : allowedSlots) {
            container.getStackInSlot(slot);
            if (container.getStackInSlot(slot).func_190926_b()) continue;
            itemStackMap.put(slot, container.getStackInSlot(slot));
        }
        if (itemStackMap.isEmpty()) {
            return false;
        }
        Object object = recipeIngredients.iterator();
        block1: while (object.hasNext()) {
            RecipesCommon.AStack recipeIngredient = (RecipesCommon.AStack)object.next();
            RecipesCommon.AStack nextIngredient = recipeIngredient.copy();
            nextIngredient.singulize();
            int ingredientSlot = this.getValidSlot(nextIngredient, minSlot, maxSlot);
            if (ingredientSlot < minSlot) continue;
            int possibleAmount = this.inventory.getStackInSlot(ingredientSlot).func_77976_d() - this.inventory.getStackInSlot(ingredientSlot).func_190916_E();
            if (possibleAmount == 0) {
                System.out.println("This should never happen method getValidSlot broke");
                continue;
            }
            for (Map.Entry set : itemStackMap.entrySet()) {
                ItemStack stack = (ItemStack)set.getValue();
                int slot = (Integer)set.getKey();
                RecipesCommon.NbtComparableStack comparable = new RecipesCommon.NbtComparableStack(stack);
                comparable.singulize();
                if (!nextIngredient.isApplicable(comparable)) continue;
                int foundCount = Math.min(stack.func_190916_E(), possibleAmount);
                if (te != null && !te.canExtractItem(slot, stack, foundCount)) continue;
                if (foundCount <= 0) continue block1;
                possibleAmount -= foundCount;
                ItemStack result = container.extractItem(slot, foundCount, false);
                this.inventory.insertItem(ingredientSlot, result, false);
            }
        }
        return true;
    }

    public boolean removeItems(List<RecipesCommon.AStack> stack, IItemHandlerModifiable array) {
        if (stack == null) {
            return false;
        }
        for (RecipesCommon.AStack aStack : stack) {
            for (int j = 0; j < aStack.count(); ++j) {
                RecipesCommon.AStack sta = aStack.copy();
                sta.singulize();
                if (this.canRemoveItemFromArray(sta, array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveItemFromArray(RecipesCommon.AStack stack, IItemHandlerModifiable array) {
        RecipesCommon.AStack st = stack.copy();
        if (st == null) {
            return true;
        }
        for (int i = 6; i < 18; ++i) {
            if (array.getStackInSlot(i).func_190926_b()) continue;
            ItemStack sta = array.getStackInSlot(i).func_77946_l();
            sta.func_190920_e(1);
            if (!st.isApplicable(sta) || array.getStackInSlot(i).func_190916_E() <= 0) continue;
            array.getStackInSlot(i).func_190918_g(1);
            if (array.getStackInSlot(i).func_190926_b()) {
                array.setStackInSlot(i, ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public boolean isItemAcceptable(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null && !stack1.func_190926_b() && !stack2.func_190926_b()) {
            if (Library.areItemStacksCompatible(stack1, stack2, false)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length > 0 && ids2.length > 0) {
                for (int i = 0; i < ids1.length; ++i) {
                    for (int j = 0; j < ids2.length; ++j) {
                        if (ids1[i] != ids2[j]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 2000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b(2.0, 1.0, 2.0).func_186662_g(10.0);
    }

    @Override
    public int countMufflers() {
        int count = 0;
        for (int x = this.field_174879_c.func_177958_n() - 1; x <= this.field_174879_c.func_177958_n() + 1; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - 1; z <= this.field_174879_c.func_177952_p() + 1; ++z) {
                if (this.field_145850_b.func_180495_p(new BlockPos(x, this.field_174879_c.func_177956_o() - 1, z)).func_177230_c() != ModBlocks.muffler) continue;
                ++count;
            }
        }
        return count;
    }
}

