/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.inventory.container.ContainerFurnaceSteel;
import com.hbm.inventory.gui.GUIFurnaceSteel;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ItemStackUtil;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFurnaceSteel
extends TileEntityMachineBase
implements IGUIProvider,
ITickable {
    public int[] progress = new int[3];
    public int[] bonus = new int[3];
    public static final int processTime = 40000;
    public int heat;
    public static final int maxHeat = 100000;
    public static final double diffusion = 0.05;
    private ItemStack[] lastItems = new ItemStack[3];
    public boolean wasOn = false;

    public TileEntityFurnaceSteel() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.furnaceSteel";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tryPullHeat();
            this.wasOn = false;
            int burn = (this.heat - 33333) / 10;
            for (int i = 0; i < 3; ++i) {
                ItemStack input = this.inventory.getStackInSlot(i);
                if (input == ItemStack.field_190927_a || this.lastItems[i] == ItemStack.field_190927_a || !input.func_77969_a(this.lastItems[i])) {
                    this.progress[i] = 0;
                    this.bonus[i] = 0;
                }
                if (this.canSmelt(i)) {
                    int n = i;
                    this.progress[n] = this.progress[n] + burn;
                    this.heat -= burn;
                    this.wasOn = true;
                }
                this.lastItems[i] = input;
                if (this.progress[i] < 40000) continue;
                ItemStack outputs = this.inventory.getStackInSlot(i + 3);
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(i));
                ItemStack copy = outputs;
                if (outputs == ItemStack.field_190927_a) {
                    copy = result.func_77946_l();
                    this.inventory.setStackInSlot(i + 3, copy);
                } else {
                    outputs.func_190920_e(copy.func_190916_E() + result.func_190916_E());
                }
                this.addBonus(this.inventory.getStackInSlot(i), i);
                while (this.bonus[i] >= 100) {
                    copy = outputs;
                    outputs.func_190920_e(Math.min(outputs.func_77976_d(), outputs.func_190916_E() + result.func_190916_E()));
                    int n = i;
                    this.bonus[n] = this.bonus[n] - 100;
                }
                input.func_190918_g(1);
                this.progress[i] = 0;
            }
            if (this.shouldSendNetworkUpdate()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74783_a("progress", this.progress);
                data.func_74783_a("bonus", this.bonus);
                data.func_74768_a("heat", this.heat);
                data.func_74757_a("wasOn", this.wasOn);
                this.networkPack(data, 50);
            }
        } else if (this.wasOn) {
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 1.125 - (double)rot.offsetX * 0.75, (double)this.field_174879_c.func_177956_o() + 2.625, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 1.125 - (double)rot.offsetZ * 0.75, 0.0, 0.05, 0.0, new int[0]);
            if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 0.75, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 0.75, 0.0, 0.05, 0.0, new int[0]);
            }
            if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 1.5 + (double)rot.offsetX * (this.field_145850_b.field_73012_v.nextDouble() - 0.5), (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 1.5 + (double)rot.offsetZ * (this.field_145850_b.field_73012_v.nextDouble() - 0.5), (double)dir.offsetX * 0.5, 0.05, (double)dir.offsetZ * 0.5, new int[0]);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.progress = nbt.func_74759_k("progress");
        this.bonus = nbt.func_74759_k("bonus");
        this.heat = nbt.func_74762_e("heat");
        this.wasOn = nbt.func_74767_n("wasOn");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74759_k("progress");
        this.bonus = nbt.func_74759_k("bonus");
        this.heat = nbt.func_74762_e("heat");
        NBTTagList list = nbt.func_150295_c("lastItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("lastItem");
            if (b0 < 0 || b0 >= this.lastItems.length) continue;
            this.lastItems[b0] = new ItemStack(nbt1);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74783_a("progress", this.progress);
        nbt.func_74783_a("bonus", this.bonus);
        nbt.func_74768_a("heat", this.heat);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.lastItems.length; ++i) {
            if (this.lastItems[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("lastItem", (byte)i);
            this.lastItems[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("lastItems", (NBTBase)list);
        return super.func_189515_b(nbt);
    }

    protected void addBonus(ItemStack stack, int index) {
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        for (String name : names) {
            if (name.startsWith("ore")) {
                int n = index;
                this.bonus[n] = this.bonus[n] + 25;
                return;
            }
            if (name.startsWith("log")) {
                int n = index;
                this.bonus[n] = this.bonus[n] + 50;
                return;
            }
            if (!name.equals("anyTar")) continue;
            int n = index;
            this.bonus[n] = this.bonus[n] + 50;
            return;
        }
    }

    protected void tryPullHeat() {
        if (this.heat >= 100000) {
            return;
        }
        BlockPos blockBelow = this.field_174879_c.func_177977_b();
        TileEntity con = this.field_145850_b.func_175625_s(blockBelow);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * 0.05);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > 100000) {
                    this.heat = 100000;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    public boolean canSmelt(int index) {
        if (this.heat < 33333) {
            return false;
        }
        if (this.inventory.getStackInSlot(index).func_190926_b()) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(index));
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (this.inventory.getStackInSlot(index + 3).func_190926_b()) {
            return true;
        }
        if (!this.inventory.getStackInSlot(index + 3).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(index + 3).func_190916_E() < this.inventory.getSlotLimit(index + 3) && this.inventory.getStackInSlot(index + 3).func_190916_E() < this.inventory.getStackInSlot(index + 3).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(index + 3).func_190916_E() < itemStack.func_77976_d();
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        if (i < 3) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i > 2;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceSteel(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceSteel(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

