/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityCoreTitanium
extends TileEntityMachineBase
implements ITickable,
IEnergyUser,
INBTPacketReceiver {
    public int progress = 0;
    public int progressStep = 1;
    public long power = 0L;
    public int soundCycle = 0;
    public boolean hasCluster = false;
    public static final long powerPerStep = 200L;
    public static final int processTime = 400;
    public static final long maxPower = 1000000L;

    public TileEntityCoreTitanium() {
        super(23);
    }

    @Override
    public String getName() {
        return "container.factoryTitanium";
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.progress = compound.func_74762_e("cookTime");
        this.progressStep = compound.func_74762_e("speed");
        this.power = compound.func_74763_f("power");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("cookTime", this.progress);
        compound.func_74768_a("speed", this.progressStep);
        compound.func_74772_a("power", this.power);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void moveToSlotIfProcessable(int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            for (int i = 0; i < 9; ++i) {
                if (!this.isProcessable(this.inventory.getStackInSlot(i))) continue;
                this.inventory.setStackInSlot(slot, this.inventory.getStackInSlot(i).func_77946_l());
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                break;
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b() || !Library.areItemStacksEqualIgnoreCount(this.inventory.getStackInSlot(i), this.inventory.getStackInSlot(slot))) continue;
                if (this.inventory.getStackInSlot(slot).func_190916_E() + this.inventory.getStackInSlot(i).func_190916_E() <= this.inventory.getStackInSlot(i).func_77976_d()) {
                    this.inventory.getStackInSlot(slot).func_190917_f(this.inventory.getStackInSlot(i).func_190916_E());
                    this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                } else {
                    int j = this.inventory.getStackInSlot(slot).func_77976_d() - this.inventory.getStackInSlot(slot).func_190916_E();
                    this.inventory.getStackInSlot(slot).func_190917_f(j);
                    this.inventory.getStackInSlot(i).func_190918_g(j);
                }
                break;
            }
        }
    }

    public boolean hasSpace(int input, int output) {
        boolean isEmpty = this.inventory.getStackInSlot(output).func_190926_b();
        if (isEmpty) {
            return true;
        }
        ItemStack outputStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(input));
        return Library.areItemStacksEqualIgnoreCount(outputStack, this.inventory.getStackInSlot(output)) && this.inventory.getStackInSlot(output).func_190916_E() < this.inventory.getStackInSlot(output).func_77976_d();
    }

    public boolean hasSpaceForAll() {
        return this.hasSpace(9, 11) && this.hasSpace(10, 12);
    }

    public boolean hasSomethingToProcess() {
        return this.isProcessable(this.inventory.getStackInSlot(9)) || this.isProcessable(this.inventory.getStackInSlot(10));
    }

    public void process(int input, int output) {
        if (this.isProcessable(this.inventory.getStackInSlot(input))) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(input));
            if (this.inventory.getStackInSlot(output).func_190926_b()) {
                this.inventory.setStackInSlot(output, itemStack.func_77946_l());
            } else if (Library.areItemStacksEqualIgnoreCount(this.inventory.getStackInSlot(output), itemStack)) {
                this.inventory.getStackInSlot(output).func_190917_f(itemStack.func_190916_E());
            }
            this.inventory.getStackInSlot(input).func_190918_g(1);
            if (this.inventory.getStackInSlot(input).func_190926_b()) {
                this.inventory.setStackInSlot(input, ItemStack.field_190927_a);
            }
        }
    }

    public void moveToOuput(int slot) {
        if (!this.inventory.getStackInSlot(slot).func_190926_b()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                int k;
                int j = i + 13;
                if (this.inventory.getStackInSlot(j).func_190926_b()) {
                    this.inventory.setStackInSlot(j, this.inventory.getStackInSlot(slot).func_77946_l());
                    this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
                    return;
                }
                if (!Library.areItemStacksEqualIgnoreCount(this.inventory.getStackInSlot(j), this.inventory.getStackInSlot(slot)) || (k = (stack = this.inventory.getStackInSlot(j)).func_77976_d() - stack.func_190916_E()) <= 0) continue;
                if (stack.func_190916_E() + this.inventory.getStackInSlot(slot).func_190916_E() <= this.inventory.getStackInSlot(slot).func_77976_d()) {
                    this.inventory.getStackInSlot(j).func_190917_f(this.inventory.getStackInSlot(slot).func_190916_E());
                    this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
                    return;
                }
                if (k >= 0) continue;
                this.inventory.getStackInSlot(j).func_190917_f(k);
                this.inventory.getStackInSlot(26).func_190918_g(k);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isStructureValid(this.field_145850_b)) {
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 2, 0), ForgeDirection.UP);
            this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -2, 0), ForgeDirection.DOWN);
            this.hasCluster = this.inventory.getStackInSlot(22).func_77973_b() == ModItems.factory_core_titanium;
            this.moveToSlotIfProcessable(9);
            this.moveToSlotIfProcessable(10);
            if (this.power > (long)this.progressStep * 200L && this.hasSomethingToProcess() && this.hasSpaceForAll()) {
                this.progress += this.progressStep;
                this.power -= (long)this.progressStep * 200L;
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 0.75f, 0.5f);
                }
                ++this.soundCycle;
                if (this.soundCycle >= 50) {
                    this.soundCycle = 0;
                }
            } else {
                if (this.hasCluster && this.progressStep > 1 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    --this.progressStep;
                }
                this.progress = 0;
            }
            if (this.progress >= 400) {
                this.process(9, 11);
                this.process(10, 12);
                this.progress = 0;
                if (this.hasCluster) {
                    this.progressStep = Math.min(100, this.progressStep + 1);
                }
            }
            this.moveToOuput(11);
            this.moveToOuput(12);
            if (this.shouldSendNetworkUpdate()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74768_a("cookTime", this.progress);
                data.func_74768_a("speed", this.progressStep);
                data.func_74772_a("power", this.power);
                this.networkPack(data, 250);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.progress = nbt.func_74762_e("cookTime");
        this.progressStep = nbt.func_74762_e("speed");
        this.power = nbt.func_74763_f("power");
    }

    public boolean isStructureValid(World world) {
        int z;
        int y;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int x = this.field_174879_c.func_177958_n();
        return !(world.func_180495_p((BlockPos)mPos.func_181079_c(x, y = this.field_174879_c.func_177956_o(), z = this.field_174879_c.func_177952_p())).func_177230_c() != ModBlocks.factory_titanium_core || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y - 1, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y - 1, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y - 1, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y - 1, z)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y - 1, z)).func_177230_c() != ModBlocks.factory_titanium_conductor && world.func_180495_p((BlockPos)mPos.func_181079_c(x, y - 1, z)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y - 1, z)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y - 1, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y - 1, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y - 1, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z - 1)).func_177230_c() != ModBlocks.factory_titanium_furnace || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y, z)).func_177230_c() != ModBlocks.factory_titanium_furnace || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y, z)).func_177230_c() != ModBlocks.factory_titanium_furnace || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z + 1)).func_177230_c() != ModBlocks.factory_titanium_furnace || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y + 1, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y + 1, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y + 1, z - 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y + 1, z)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y + 1, z)).func_177230_c() != ModBlocks.factory_titanium_conductor && world.func_180495_p((BlockPos)mPos.func_181079_c(x, y + 1, z)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y + 1, z)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x - 1, y + 1, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x, y + 1, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull || world.func_180495_p((BlockPos)mPos.func_181079_c(x + 1, y + 1, z + 1)).func_177230_c() != ModBlocks.factory_titanium_hull);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 400;
    }

    public boolean isProcessable(ItemStack item) {
        if (item != null && !item.func_190926_b()) {
            return !FurnaceRecipes.func_77602_a().func_151395_a(item).func_190926_b();
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot < 11 && this.isProcessable(stack);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot > 10 && slot != 22;
    }
}

