/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.items.machine.ItemLens;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoreStabilizer
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public static final long maxPower = 10000000000000L;
    public int watts;
    public int beam;
    public boolean isOn;
    public static final int range = 15;

    public TileEntityCoreStabilizer() {
        super(1);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            this.watts = MathHelper.func_76125_a((int)this.watts, (int)1, (int)100);
            long demand = (long)Math.pow(this.watts, 6.0);
            this.isOn = false;
            this.beam = 0;
            ItemLens lens = null;
            if (this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemLens) {
                lens = (ItemLens)this.inventory.getStackInSlot(0).func_77973_b();
            }
            if (lens != null && (float)this.power >= (float)demand * lens.drainMod) {
                this.isOn = true;
                EnumFacing dir = EnumFacing.func_82600_a((int)this.func_145832_p());
                for (int i = 1; i <= 15; ++i) {
                    int z;
                    int y;
                    int x = this.field_174879_c.func_177958_n() + dir.func_82601_c() * i;
                    BlockPos pos1 = new BlockPos(x, y = this.field_174879_c.func_177956_o() + dir.func_96559_d() * i, z = this.field_174879_c.func_177952_p() + dir.func_82599_e() * i);
                    TileEntity te = this.field_145850_b.func_175625_s(pos1);
                    if (te instanceof TileEntityCore) {
                        TileEntityCore core = (TileEntityCore)te;
                        core.field += (int)((float)this.watts * lens.fieldMod);
                        this.power -= (long)((float)demand * lens.drainMod);
                        this.beam = i;
                        long dmg = ItemLens.getLensDamage(this.inventory.getStackInSlot(0));
                        if ((dmg += (long)(this.watts / 100)) >= lens.field_77699_b) {
                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                            break;
                        }
                        ItemLens.setLensDamage(this.inventory.getStackInSlot(0), dmg);
                        break;
                    }
                    if (!(te instanceof TileEntityCoreStabilizer) && this.field_145850_b.func_180495_p(pos1).func_177230_c() != Blocks.field_150350_a) break;
                }
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.beam, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.watts = data.func_74762_e("watts");
        this.isOn = data.func_74767_n("isOn");
    }

    @Override
    public String getName() {
        return "container.dfcStabilizer";
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000000000000L;
    }

    public int getWattsScaled(int i) {
        return this.watts * i / 100;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.watts = compound.func_74762_e("watts");
        this.isOn = compound.func_74767_n("isOn");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("watts", this.watts);
        compound.func_74757_a("isOn", this.isOn);
        return super.func_189515_b(compound);
    }
}

