/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ILaserable;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoreReceiver
extends TileEntityMachineBase
implements ITickable,
IEnergyGenerator,
IFluidHandler,
ILaserable,
ITankPacketAcceptor {
    public long power;
    public long joules;
    public long syncJoules;
    public FluidTank tank = new FluidTank(64000);

    public TileEntityCoreReceiver() {
        super(0);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = (Long.MAX_VALUE - this.power) / 5000L < this.joules ? Long.MAX_VALUE : (this.power += this.joules * 5000L);
            this.sendPower(this.field_145850_b, this.field_174879_c);
            if (this.joules > 0L) {
                if (this.tank.getFluidAmount() >= 20) {
                    this.tank.drain(20, true);
                } else {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150356_k.func_176223_P());
                    return;
                }
            }
            this.syncJoules = this.joules;
            this.joules = 0L;
        }
    }

    @Override
    public String getName() {
        return "container.dfcReceiver";
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != ModForgeFluids.cryogel) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void addEnergy(long energy, EnumFacing dir) {
        if (dir.func_176734_d().ordinal() == this.func_145832_p()) {
            this.joules = Long.MAX_VALUE - this.joules < energy ? Long.MAX_VALUE : (this.joules += energy);
        } else {
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 2.5f, true);
        }
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tank.readFromNBT(tags[0]);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.joules = compound.func_74763_f("joules");
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74772_a("joules", this.joules);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return this.power;
    }
}

