/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.effect.EntityCloudFleijaRainbow;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.FluidTypeHandler;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.machine.ItemCatalyst;
import com.hbm.items.special.ItemAMSCore;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.AdvancementManager;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCore
extends TileEntityMachineBase
implements ITickable {
    public boolean hasCore = false;
    public int field;
    public int heat;
    public int color;
    public FluidTank[] tanks = new FluidTank[2];
    public int safeTimer = 0;

    public TileEntityCore() {
        super(3);
        this.tanks[0] = new FluidTank(128000);
        this.tanks[1] = new FluidTank(128000);
    }

    @Override
    public String getName() {
        return "container.dfcCore";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.heat > 0 && this.heat >= this.field) {
                if (this.safeTimer > 200) {
                    int fill = this.tanks[0].getFluidAmount() + this.tanks[1].getFluidAmount();
                    int max = this.tanks[0].getCapacity() + this.tanks[1].getCapacity();
                    int mod = this.heat * 10;
                    int size = Math.max(Math.min(fill * mod / max, 1000), 50);
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 100000.0f, 1.0f);
                    EntityNukeExplosionMK3 exp = new EntityNukeExplosionMK3(this.field_145850_b);
                    exp.field_70165_t = this.field_174879_c.func_177958_n();
                    exp.field_70163_u = this.field_174879_c.func_177956_o();
                    exp.field_70161_v = this.field_174879_c.func_177952_p();
                    exp.destructionRange = size;
                    exp.speed = 25;
                    exp.coefficient = 1.0f;
                    exp.waste = false;
                    if (this.safeTimer > 1200 || !EntityNukeExplosionMK3.isJammed(this.field_145850_b, exp)) {
                        this.field_145850_b.func_72838_d((Entity)exp);
                        EntityCloudFleijaRainbow cloud = new EntityCloudFleijaRainbow(this.field_145850_b, size);
                        cloud.field_70165_t = this.field_174879_c.func_177958_n();
                        cloud.field_70163_u = this.field_174879_c.func_177956_o();
                        cloud.field_70161_v = this.field_174879_c.func_177952_p();
                        this.field_145850_b.func_72838_d((Entity)cloud);
                        this.field_145850_b.func_175698_g(this.field_174879_c);
                    }
                }
                ++this.safeTimer;
            } else if (this.safeTimer > 0) {
                --this.safeTimer;
            }
            if (this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemCatalyst && this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemCatalyst) {
                this.color = this.calcAvgHex(((ItemCatalyst)this.inventory.getStackInSlot(0).func_77973_b()).getColor(), ((ItemCatalyst)this.inventory.getStackInSlot(2).func_77973_b()).getColor());
                this.hasCore = true;
            } else {
                this.color = 0;
                this.hasCore = false;
            }
            if (this.heat > 0) {
                this.radiation();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("tank0", this.tanks[0].getFluid() == null ? "HBM_EMPTY" : this.tanks[0].getFluid().getFluid().getName());
            data.func_74778_a("tank1", this.tanks[1].getFluid() == null ? "HBM_EMPTY" : this.tanks[1].getFluid().getFluid().getName());
            data.func_74768_a("fill0", this.tanks[0].getFluidAmount());
            data.func_74768_a("fill1", this.tanks[1].getFluidAmount());
            data.func_74768_a("field", this.field);
            data.func_74768_a("heat", this.heat);
            data.func_74768_a("color", this.color);
            data.func_74757_a("hasCore", this.hasCore);
            this.networkPack(data, 250);
            this.heat = 0;
            this.field = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        String s0 = data.func_74779_i("tank0");
        String s1 = data.func_74779_i("tank1");
        if ("HBM_EMPTY".equals(s0)) {
            this.tanks[0].setFluid(null);
        } else {
            this.tanks[0].setFluid(new FluidStack(FluidRegistry.getFluid((String)s0), data.func_74762_e("fill0")));
        }
        if ("HBM_EMPTY".equals(s1)) {
            this.tanks[1].setFluid(null);
        } else {
            this.tanks[1].setFluid(new FluidStack(FluidRegistry.getFluid((String)s1), data.func_74762_e("fill1")));
        }
        this.field = data.func_74762_e("field");
        this.heat = data.func_74762_e("heat");
        this.color = data.func_74762_e("color");
        this.hasCore = data.func_74767_n("hasCore");
    }

    private void radiation() {
        double scale = (double)((int)Math.log(this.heat)) * 1.25 + 0.5;
        int range = (int)(scale * 4.0);
        List list = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - range) + 0.5, (double)(this.field_174879_c.func_177956_o() - range) + 0.5, (double)(this.field_174879_c.func_177952_p() - range) + 0.5, (double)(this.field_174879_c.func_177958_n() + range) + 0.5, (double)(this.field_174879_c.func_177956_o() + range) + 0.5, (double)(this.field_174879_c.func_177952_p() + range) + 0.5));
        for (Entity e : list) {
            boolean isPlayer = e instanceof EntityPlayer;
            if (!(isPlayer && ArmorUtil.checkForHazmat((EntityLivingBase)((EntityPlayer)e)) || Library.isObstructed(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5 + 6.0, (double)this.field_174879_c.func_177952_p() + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v))) {
                if (!isPlayer || isPlayer && !((EntityPlayer)e).field_71075_bZ.field_75098_d) {
                    e.func_70097_a(ModDamageSource.ams, (float)(this.heat * 100));
                }
                e.func_70015_d(3);
            }
            if (!isPlayer) continue;
            AdvancementManager.grantAchievement((EntityPlayer)e, AdvancementManager.progress_dfc);
        }
        List list2 = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - scale + 0.5, (double)this.field_174879_c.func_177956_o() - scale + 0.5, (double)this.field_174879_c.func_177952_p() - scale + 0.5, (double)this.field_174879_c.func_177958_n() + scale + 0.5, (double)this.field_174879_c.func_177956_o() + scale + 0.5, (double)this.field_174879_c.func_177952_p() + scale + 0.5));
        for (Entity e : list2) {
            boolean isPlayer = e instanceof EntityPlayer;
            if (isPlayer && ArmorUtil.checkForHaz2((EntityLivingBase)((EntityPlayer)e))) continue;
            if (!isPlayer || isPlayer && !((EntityPlayer)e).field_71075_bZ.field_75098_d) {
                e.func_70097_a(ModDamageSource.amsCore, (float)(this.heat * 1000));
            }
            e.func_70015_d(3);
        }
    }

    public int getFieldScaled(int i) {
        return this.field * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 100;
    }

    public boolean isReady() {
        if (this.getCorePower() == 0) {
            return false;
        }
        if (this.color == 0) {
            return false;
        }
        if (this.tanks[0].getFluid() == null || this.tanks[1].getFluid() == null) {
            return false;
        }
        return !(FluidTypeHandler.getDFCEfficiency(this.tanks[0].getFluid().getFluid()) <= 0.0f) && !(FluidTypeHandler.getDFCEfficiency(this.tanks[1].getFluid().getFluid()) <= 0.0f);
    }

    public long burn(long joules) {
        if (!this.isReady()) {
            return joules;
        }
        int demand = (int)Math.sqrt(joules);
        long powerAbs = ItemCatalyst.getPowerAbs(this.inventory.getStackInSlot(0)) + ItemCatalyst.getPowerAbs(this.inventory.getStackInSlot(2));
        float powerMod = ItemCatalyst.getPowerMod(this.inventory.getStackInSlot(0)) * ItemCatalyst.getPowerMod(this.inventory.getStackInSlot(2));
        float heatMod = ItemCatalyst.getHeatMod(this.inventory.getStackInSlot(0)) * ItemCatalyst.getHeatMod(this.inventory.getStackInSlot(2));
        float fuelMod = ItemCatalyst.getFuelMod(this.inventory.getStackInSlot(0)) * ItemCatalyst.getFuelMod(this.inventory.getStackInSlot(2));
        demand = (int)(this.getCoreFuel() * (float)demand * fuelMod);
        if (this.tanks[0].getFluidAmount() < demand || this.tanks[1].getFluidAmount() < demand) {
            return joules;
        }
        this.heat += (int)((double)(this.getCoreHeat() * heatMod) * Math.ceil((double)joules / 10000.0));
        Fluid f1 = this.tanks[0].getFluid().getFluid();
        Fluid f2 = this.tanks[1].getFluid().getFluid();
        this.tanks[0].drain(demand, true);
        this.tanks[1].drain(demand, true);
        long powerOutput = (long)Math.max(0.0f, powerMod * (float)joules * (float)this.getCorePower() * FluidTypeHandler.getDFCEfficiency(f1) * FluidTypeHandler.getDFCEfficiency(f2) + (float)powerAbs);
        if (powerOutput > 0L && this.heat == 0) {
            this.heat = 1;
        }
        return powerOutput;
    }

    public int getCorePower() {
        return ItemAMSCore.getPowerBase(this.inventory.getStackInSlot(1));
    }

    public float getCoreHeat() {
        return ItemAMSCore.getHeatBase(this.inventory.getStackInSlot(1));
    }

    public float getCoreFuel() {
        return ItemAMSCore.getFuelBase(this.inventory.getStackInSlot(1));
    }

    private int calcAvgHex(int h1, int h2) {
        int r1 = (h1 & 0xFF0000) >> 16;
        int g1 = (h1 & 0xFF00) >> 8;
        int b1 = (h1 & 0xFF) >> 0;
        int r2 = (h2 & 0xFF0000) >> 16;
        int g2 = (h2 & 0xFF00) >> 8;
        int b2 = (h2 & 0xFF) >> 0;
        int r = (r1 + r2) / 2 << 16;
        int g = (g1 + g2) / 2 << 8;
        int b = (b1 + b2) / 2 << 0;
        return r | g | b;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }
}

