/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.conductor;

import com.hbm.forgefluid.FFPipeNetworkMk2;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.IFluidPipeMk2;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PipeUpdatePacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityFFDuctBaseMk2
extends TileEntity
implements IFluidPipeMk2,
IFluidHandler {
    public EnumFacing[] connections = new EnumFacing[6];
    protected Fluid type;
    protected FFPipeNetworkMk2 network = null;
    public boolean isBeingDestroyed = false;

    protected void attemptRebuildIfBroken() {
        if (this.network != null && this.network.isValid() || this.isBeingDestroyed) {
            return;
        }
        this.network = null;
        this.updateConnections();
        this.joinOrMakeNetwork();
        this.onNeighborChange();
    }

    @Override
    public void setType(Fluid f) {
        if (f != this.type) {
            PlayerChunkMapEntry entry;
            this.type = f;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.field_145850_b.func_190524_a(this.field_174879_c, this.func_145838_q(), this.field_174879_c);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 2);
            TileEntityFFDuctBaseMk2.rebuildNetworks(this.field_145850_b, this.field_174879_c);
            if (this.field_145850_b instanceof WorldServer && (entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(MathHelper.func_76141_d((float)this.field_174879_c.func_177958_n()) >> 4, MathHelper.func_76141_d((float)this.field_174879_c.func_177952_p()) >> 4)) != null) {
                for (EntityPlayerMP player : entry.getWatchingPlayers()) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound())));
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PipeUpdatePacket(this.field_174879_c, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            }
        }
    }

    @Override
    public Fluid getType() {
        return this.type;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        if (this.type != null) {
            compound.func_74778_a("fluidType", this.type.getName());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("fluidType")) {
            this.type = FluidRegistry.getFluid((String)compound.func_74779_i("fluidType"));
        }
        super.func_145839_a(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        Fluid f = this.type;
        this.func_145839_a(tag);
        if (f == this.type) {
            return;
        }
        for (EnumFacing e : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(e));
            if (!(te instanceof TileEntityFFDuctBaseMk2)) continue;
            ((TileEntityFFDuctBaseMk2)te).onNeighborChange();
        }
        this.onNeighborChange();
    }

    public void onLoad() {
        this.updateConnections();
        this.joinOrMakeNetwork();
        this.onNeighborChange();
    }

    public void onNeighborChange() {
        this.updateConnections();
        if (this.network != null) {
            for (EnumFacing e : this.connections) {
                if (e == null) continue;
                BlockPos offset = this.field_174879_c.func_177972_a(e);
                TileEntity tileEntity = this.field_145850_b.func_175625_s(offset);
                if (tileEntity != null) {
                    this.network.tryAdd(tileEntity);
                    continue;
                }
                this.network.tryRemovePipe(offset);
                this.network.tryRemoveConsumer(offset);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PipeUpdatePacket(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        }
    }

    public void onChunkUnload() {
        if (this.network == null) {
            return;
        }
        for (EnumFacing e : this.connections) {
            if (e == null) continue;
            BlockPos pos = this.field_174879_c.func_177972_a(e);
            this.network.tryRemoveConsumer(pos);
        }
        this.network.checkForRemoval(this);
        this.network = null;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public static void breakBlock(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFFDuctBaseMk2) {
            ((TileEntityFFDuctBaseMk2)te).isBeingDestroyed = true;
        }
        TileEntityFFDuctBaseMk2.rebuildNetworks(world, pos);
    }

    public static void rebuildNetworks(World world, BlockPos pos) {
        TileEntity center = world.func_175625_s(pos);
        EnumFacing[] dirs = EnumFacing.field_82609_l;
        if (center instanceof TileEntityFFDuctBaseMk2) {
            TileEntityFFDuctBaseMk2 duct = (TileEntityFFDuctBaseMk2)center;
            duct.updateConnections();
            dirs = duct.connections;
        }
        for (EnumFacing e : dirs) {
            IFluidPipeMk2 pipe;
            TileEntity te;
            if (e == null || !((te = world.func_175625_s(pos.func_177972_a(e))) instanceof IFluidPipeMk2) || (pipe = (IFluidPipeMk2)te).getNetwork() == null) continue;
            pipe.getNetwork().destroy();
        }
        if (center instanceof IFluidPipeMk2 && ((IFluidPipeMk2)center).getNetwork() != null) {
            ((IFluidPipeMk2)center).getNetwork().destroy();
        }
        for (EnumFacing e : dirs) {
            if (e == null) continue;
            FFPipeNetworkMk2.buildNetwork(world.func_175625_s(pos.func_177972_a(e)));
        }
        FFPipeNetworkMk2.buildNetwork(center);
    }

    @Override
    public void joinOrMakeNetwork() {
        ArrayList<FFPipeNetworkMk2> otherNetworks = new ArrayList<FFPipeNetworkMk2>();
        for (EnumFacing e : this.connections) {
            IFluidPipeMk2 pipe;
            BlockPos offset;
            TileEntity te;
            if (e == null || !((te = this.field_145850_b.func_175625_s(offset = this.field_174879_c.func_177972_a(e))) instanceof IFluidPipeMk2) || (pipe = (IFluidPipeMk2)te).getNetwork() == null || pipe.getNetwork().getType() != this.getType() || otherNetworks.contains(pipe.getNetwork())) continue;
            otherNetworks.add(pipe.getNetwork());
        }
        if (otherNetworks.isEmpty()) {
            this.network = new FFPipeNetworkMk2(this);
            this.network.tryAdd(this);
        } else {
            FFPipeNetworkMk2 net = (FFPipeNetworkMk2)otherNetworks.remove(0);
            while (!otherNetworks.isEmpty()) {
                net = FFPipeNetworkMk2.mergeNetworks(net, (FFPipeNetworkMk2)otherNetworks.remove(0));
            }
            this.network = net;
            net.tryAdd(this);
        }
    }

    public void dumpState(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("Dumping state for the fluid duct at " + this.field_174879_c));
        player.func_145747_a((ITextComponent)new TextComponentString("--------------------------------"));
        player.func_145747_a((ITextComponent)new TextComponentString("DUCT TE STATE"));
        player.func_145747_a((ITextComponent)new TextComponentString("Instance: " + this));
        player.func_145747_a((ITextComponent)new TextComponentString("Connections: " + Arrays.toString(this.connections)));
        player.func_145747_a((ITextComponent)new TextComponentString("Type: " + (this.type == null ? "None" : this.type.getName())));
        player.func_145747_a((ITextComponent)new TextComponentString("Network: " + (this.network == null ? "None" : this.network.toString())));
        player.func_145747_a((ITextComponent)new TextComponentString("Is being destroyed: " + this.isBeingDestroyed));
        player.func_145747_a((ITextComponent)new TextComponentString("--------------------------------"));
        if (this.network != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("NETWORK STATE"));
            player.func_145747_a((ITextComponent)new TextComponentString("Valid: " + this.network.isValid()));
            player.func_145747_a((ITextComponent)new TextComponentString("Type: " + (this.network.getType() == null ? "None" : this.network.getType().getName())));
            player.func_145747_a((ITextComponent)new TextComponentString("Size: " + this.network.size()));
            player.func_145747_a((ITextComponent)new TextComponentString("Pipe Count: " + this.network.pipes.size()));
            player.func_145747_a((ITextComponent)new TextComponentString("Fillables Count: " + this.network.fillables.size()));
            player.func_145747_a((ITextComponent)new TextComponentString("Fillables: "));
            for (Map.Entry<BlockPos, TileEntity> fillable : this.network.fillables.entrySet()) {
                player.func_145747_a((ITextComponent)new TextComponentString("  " + fillable.getKey() + ": " + fillable.getValue()));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("NETWORK DUMP SKIPPED, NO NETWORK"));
        }
    }

    public void updateConnections() {
        this.connections[0] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177984_a(), this.getType(), EnumFacing.UP.func_176734_d()) ? EnumFacing.UP : null;
        this.connections[1] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177977_b(), this.getType(), EnumFacing.DOWN.func_176734_d()) ? EnumFacing.DOWN : null;
        this.connections[2] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177978_c(), this.getType(), EnumFacing.NORTH.func_176734_d()) ? EnumFacing.NORTH : null;
        this.connections[3] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177974_f(), this.getType(), EnumFacing.EAST.func_176734_d()) ? EnumFacing.EAST : null;
        this.connections[4] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177968_d(), this.getType(), EnumFacing.SOUTH.func_176734_d()) ? EnumFacing.SOUTH : null;
        this.connections[5] = FFUtils.checkFluidConnectablesMk2(this.field_145850_b, this.field_174879_c.func_177976_e(), this.getType(), EnumFacing.WEST.func_176734_d()) ? EnumFacing.WEST : null;
    }

    @Override
    public FFPipeNetworkMk2 getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(FFPipeNetworkMk2 net) {
        this.network = net;
    }

    @Override
    public boolean isValidForBuilding() {
        return !this.isBeingDestroyed;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.network != null ? this.network.getTankProperties() : new IFluidTankProperties[]{};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.network != null ? this.network.fill(resource, doFill) : 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.network != null ? this.network.drain(resource, doDrain) : null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.network != null ? this.network.drain(maxDrain, doDrain) : null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }
}

