/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.Spaghetti;
import com.hbm.lib.ItemStackHandlerWrapper;
import com.hbm.lib.Library;
import com.hbm.packet.NBTPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Spaghetti(value="Not spaghetti in itself, but for the love of god please use this base class for all machines")
public abstract class TileEntityMachineBase
extends TileEntityLoadedBase
implements INBTPacketReceiver {
    public static final Random rand = new Random();
    public final int updateOffset = rand.nextInt(20);
    private boolean networkDirty = false;
    public int networkUpdateFrequency = 20;
    public ItemStackHandler inventory;
    private String customName;

    public TileEntityMachineBase(int scount) {
        this(scount, 64);
    }

    public TileEntityMachineBase(int scount, int slotlimit) {
        this.inventory = this.getNewInventory(scount, slotlimit);
    }

    public ItemStackHandler getNewInventory(int scount, final int slotlimit) {
        return new ItemStackHandler(scount){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityMachineBase.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return slotlimit;
            }
        };
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : this.getName();
    }

    public abstract String getName();

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }

    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[0];
    }

    public int getGaugeScaled(int i, FluidTank tank) {
        return tank.getFluidAmount() * i / tank.getCapacity();
    }

    public void networkPack(NBTTagCompound nbt, int range) {
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new NBTPacket(nbt, this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)range));
        }
    }

    public void setNetworkDirty() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.networkDirty = true;
    }

    public boolean shouldSendNetworkUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.networkDirty) {
            this.networkDirty = false;
            return true;
        }
        return (this.field_145850_b.func_82737_E() + (long)this.updateOffset) % 20L == 0L;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
    }

    public void handleButtonPacket(int value, int meta) {
        this.setNetworkDirty();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return true;
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return true;
    }

    public int countMufflers() {
        int count = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir)).func_177230_c() != ModBlocks.muffler) continue;
            ++count;
        }
        return count;
    }

    public float getVolume(int toSilence) {
        float volume = 1.0f - (float)this.countMufflers() / (float)toSilence;
        return Math.max(volume, 0.0f);
    }

    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = this.inventory.getStackInSlot(slot);
            if (outputStack.func_190926_b()) {
                return false;
            }
            ItemStack chestItem = chest.getStackInSlot(i);
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            this.inventory.setStackInSlot(slot, chest.insertItem(i, outputStack, false));
            if (!outputStack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemStackHandlerWrapper(this.inventory, this.getAccessibleSlotsFromSide(facing)){

                @Override
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (TileEntityMachineBase.this.canExtractItem(slot, TileEntityMachineBase.this.inventory.getStackInSlot(slot), amount)) {
                        return super.extractItem(slot, amount, simulate);
                    }
                    return ItemStack.field_190927_a;
                }

                @Override
                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (TileEntityMachineBase.this.canInsertItem(slot, stack, stack.func_190916_E())) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
            });
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null || super.hasCapability(capability, facing);
    }
}

