/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.sound;

import com.hbm.sound.AudioDynamic;
import com.hbm.sound.AudioWrapper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AudioWrapperClient
extends AudioWrapper {
    AudioDynamic sound;

    public AudioWrapperClient(SoundEvent source, SoundCategory cat) {
        if (source != null) {
            this.sound = new AudioDynamic(source, cat);
        }
    }

    @Override
    public void updatePosition(float x, float y, float z) {
        if (this.sound != null) {
            this.sound.setPosition(x, y, z);
        }
    }

    @Override
    public void updateVolume(float volume) {
        if (this.sound != null) {
            this.sound.setVolume(volume);
        }
    }

    @Override
    public void updatePitch(float pitch) {
        if (this.sound != null) {
            this.sound.setPitch(pitch);
        }
    }

    @Override
    public float getVolume() {
        if (this.sound != null) {
            return this.sound.func_147653_e();
        }
        return 1.0f;
    }

    @Override
    public float getPitch() {
        if (this.sound != null) {
            return this.sound.func_147655_f();
        }
        return 1.0f;
    }

    @Override
    public void startSound() {
        if (this.sound != null) {
            this.sound.start();
        }
    }

    @Override
    public void stopSound() {
        if (this.sound != null) {
            this.sound.stop();
        }
    }
}

