/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.blocks.machine.rbmk.RBMKRod;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.Tessellator;
import com.hbm.render.amlfrom1710.WavefrontObject;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBoiler;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKHeater;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderRBMKLid
extends TileEntitySpecialRenderer<TileEntityRBMKBase> {
    private ResourceLocation texture = new ResourceLocation("hbm:textures/blocks/rbmk/rbmk_blank.png");
    private ResourceLocation texture_glass = new ResourceLocation("hbm:textures/blocks/rbmk/rbmk_blank_glass.png");
    private static final ResourceLocation texture_rods = new ResourceLocation("hbm:textures/blocks/rbmk/rbmk_element_colorable.png");

    public boolean isGlobalRenderer(TileEntityRBMKBase te) {
        return true;
    }

    public void render(TileEntityRBMKBase control, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean hasRod = false;
        boolean cherenkov = false;
        float fuelR = 0.0f;
        float fuelG = 0.0f;
        float fuelB = 0.0f;
        float cherenkovR = 0.0f;
        float cherenkovG = 0.0f;
        float cherenkovB = 0.0f;
        float cherenkovA = 0.1f;
        if (control instanceof TileEntityRBMKRod) {
            TileEntityRBMKRod rod = (TileEntityRBMKRod)control;
            if (rod.hasRod) {
                hasRod = true;
                fuelR = rod.fuelR;
                fuelG = rod.fuelG;
                fuelB = rod.fuelB;
                cherenkovR = rod.cherenkovR;
                cherenkovG = rod.cherenkovG;
                cherenkovB = rod.cherenkovB;
            }
            if (rod.fluxFast + rod.fluxSlow > 5.0) {
                cherenkov = true;
                cherenkovA = (float)Math.max(0.25, Math.log(rod.fluxFast + rod.fluxSlow) * 0.01);
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        if (!(control.func_145838_q() instanceof RBMKBase)) {
            return;
        }
        RBMKBase block = (RBMKBase)control.func_145838_q();
        WavefrontObject columnModel = ResourceManager.rbmk_reflector;
        if (block == ModBlocks.rbmk_boiler || block == ModBlocks.rbmk_heater) {
            columnModel = ResourceManager.rbmk_rods;
        } else if (block instanceof RBMKRod) {
            columnModel = ResourceManager.rbmk_element;
        }
        this.func_147499_a(block.columnTexture);
        Tessellator tes = Tessellator.instance;
        tes.startDrawing(4);
        boolean doJump = control.jumpheight > 0.0;
        columnModel.tessellatePartSplit(tes, "Column", 0.5f, (float)control.jumpheight + (float)TileEntityRBMKBase.rbmkHeight);
        tes.draw();
        int offset = TileEntityRBMKBase.rbmkHeight;
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        if (control.hasLid()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)offset, (double)0.0);
            int meta = control.func_145832_p() - 10;
            if (meta == RBMKBase.DIR_GLASS_LID.ordinal()) {
                this.func_147499_a(this.texture_glass);
            } else {
                if (control.func_145838_q() instanceof RBMKBase) {
                    this.func_147499_a(((RBMKBase)control.func_145838_q()).coverTexture);
                } else {
                    this.func_147499_a(this.texture);
                }
                cherenkov = false;
            }
            if (doJump) {
                GL11.glTranslated((double)0.0, (double)control.jumpheight, (double)0.0);
            }
            if ((control instanceof TileEntityRBMKBoiler || control instanceof TileEntityRBMKHeater) && meta != RBMKBase.DIR_GLASS_LID.ordinal()) {
                ResourceManager.rbmk_rods.renderPart("Lid");
            }
            ResourceManager.rbmk_element.renderPart("Lid");
            GL11.glPopMatrix();
        }
        if (hasRod) {
            GL11.glPushMatrix();
            GlStateManager.func_179131_c((float)fuelR, (float)fuelG, (float)fuelB, (float)1.0f);
            this.func_147499_a(texture_rods);
            Tessellator tesss = Tessellator.instance;
            tes.startDrawing(4);
            ResourceManager.rbmk_element.tessellatePartSplit(tesss, "Rods", 0.5f, offset);
            tesss.draw();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (cherenkov) {
            net.minecraft.client.renderer.Tessellator tess = net.minecraft.client.renderer.Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            GL11.glTranslated((double)0.0, (double)0.75, (double)0.0);
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (double j = 0.0; j <= (double)offset; j += 0.25) {
                buf.func_181662_b(-0.5, j, -0.5).func_181666_a(cherenkovR, cherenkovG, cherenkovB, cherenkovA).func_181675_d();
                buf.func_181662_b(-0.5, j, 0.5).func_181666_a(cherenkovR, cherenkovG, cherenkovB, cherenkovA).func_181675_d();
                buf.func_181662_b(0.5, j, 0.5).func_181666_a(cherenkovR, cherenkovG, cherenkovB, cherenkovA).func_181675_d();
                buf.func_181662_b(0.5, j, -0.5).func_181666_a(cherenkovR, cherenkovG, cherenkovB, cherenkovA).func_181675_d();
            }
            tess.func_78381_a();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
        }
        GL11.glPopMatrix();
    }
}

