/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.misc;

import com.hbm.main.ClientProxy;
import com.hbm.main.ResourceManager;
import com.hbm.render.GLCompat;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="hbm")
public class LensVisibilityHandler {
    static Map<Integer, LensSpikeInfo> lensSpikes = new HashMap<Integer, LensSpikeInfo>();
    static int currentId = 0;
    public static int checkSphere = -1;

    public static int findId() {
        while (lensSpikes.containsKey(currentId)) {
            ++currentId;
        }
        return currentId;
    }

    public static int generate(FloatBuffer matrix) {
        int id = LensVisibilityHandler.findId();
        float[] mat = new float[16];
        matrix.get(mat);
        matrix.rewind();
        LensSpikeInfo i = new LensSpikeInfo(mat);
        lensSpikes.put(id, i);
        return id;
    }

    public static void delete(int id) {
        LensSpikeInfo i = lensSpikes.get(id);
        if (i != null) {
            i.cleanup();
            lensSpikes.remove(id);
        }
    }

    public static float getVisibility(int id) {
        LensSpikeInfo i = lensSpikes.get(id);
        if (i != null) {
            return i.visibility;
        }
        return 0.0f;
    }

    public static float[] getMatrixBuf(int id) {
        LensSpikeInfo i = lensSpikes.get(id);
        if (i != null) {
            return i.modelviewMatrix;
        }
        return null;
    }

    public static void putMatrixBuf(int id, FloatBuffer matrix) {
        LensSpikeInfo i = lensSpikes.get(id);
        if (i != null) {
            matrix.get(i.modelviewMatrix);
            matrix.rewind();
        }
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        for (LensSpikeInfo i : lensSpikes.values()) {
            i.updateVisibility();
        }
    }

    public static class LensSpikeInfo {
        public float[] modelviewMatrix;
        public float visibility = 0.0f;
        private int totalFragmentsQuery;
        private int fragmentsPassedQuery;

        public LensSpikeInfo(float[] matrix) {
            this.modelviewMatrix = matrix;
            this.totalFragmentsQuery = GLCompat.genQueries();
            this.fragmentsPassedQuery = GLCompat.genQueries();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.turbofan_blades_tex);
            GL11.glPushMatrix();
            ClientProxy.AUX_GL_BUFFER.put(matrix);
            ClientProxy.AUX_GL_BUFFER.rewind();
            GL11.glLoadMatrix((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
            GL11.glScaled((double)0.05, (double)0.05, (double)0.05);
            GlStateManager.func_179097_i();
            GLCompat.beginQuery(GLCompat.GL_SAMPLES_PASSED, this.totalFragmentsQuery);
            GL11.glCallList((int)checkSphere);
            GLCompat.endQuery(GLCompat.GL_SAMPLES_PASSED);
            GlStateManager.func_179126_j();
            GLCompat.beginQuery(GLCompat.GL_SAMPLES_PASSED, this.fragmentsPassedQuery);
            GL11.glCallList((int)checkSphere);
            GLCompat.endQuery(GLCompat.GL_SAMPLES_PASSED);
            GL11.glPopMatrix();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
        }

        public void updateVisibility() {
            int totalDone = GLCompat.getQueryObject(this.totalFragmentsQuery, GLCompat.GL_QUERY_RESULT_AVAILABLE);
            int passedDone = GLCompat.getQueryObject(this.fragmentsPassedQuery, GLCompat.GL_QUERY_RESULT_AVAILABLE);
            if (totalDone != 0 && passedDone != 0) {
                float total = GLCompat.getQueryObject(this.totalFragmentsQuery, GLCompat.GL_QUERY_RESULT);
                float passed = GLCompat.getQueryObject(this.fragmentsPassedQuery, GLCompat.GL_QUERY_RESULT);
                this.visibility = passed / total;
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179129_p();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.turbofan_blades_tex);
                GL11.glPushMatrix();
                ClientProxy.AUX_GL_BUFFER.put(this.modelviewMatrix);
                ClientProxy.AUX_GL_BUFFER.rewind();
                GL11.glLoadMatrix((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
                GL11.glScaled((double)0.1, (double)0.1, (double)0.1);
                GlStateManager.func_179097_i();
                GLCompat.beginQuery(GLCompat.GL_SAMPLES_PASSED, this.totalFragmentsQuery);
                GL11.glCallList((int)checkSphere);
                GLCompat.endQuery(GLCompat.GL_SAMPLES_PASSED);
                GlStateManager.func_179126_j();
                GLCompat.beginQuery(GLCompat.GL_SAMPLES_PASSED, this.fragmentsPassedQuery);
                GL11.glCallList((int)checkSphere);
                GLCompat.endQuery(GLCompat.GL_SAMPLES_PASSED);
                GL11.glPopMatrix();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179089_o();
            }
        }

        public void cleanup() {
            GLCompat.deleteQueries(this.totalFragmentsQuery);
            GLCompat.deleteQueries(this.fragmentsPassedQuery);
        }
    }
}

