/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity;

import com.hbm.entity.projectile.EntityBullet;
import com.hbm.render.model.ModelBullet;
import java.util.Random;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderBullet
extends Render<EntityBullet> {
    public static final IRenderFactory<EntityBullet> FACTORY = manager -> new RenderBullet(manager);
    private ModelBullet miniNuke = new ModelBullet();

    protected RenderBullet(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityBullet rocket, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(rocket.field_70126_B + (rocket.field_70177_z - rocket.field_70126_B) * partialTicks - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(rocket.field_70127_C + (rocket.field_70125_A - rocket.field_70127_C) * partialTicks + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glRotatef((float)new Random(rocket.func_145782_y()).nextInt(360), (float)1.0f, (float)0.0f, (float)0.0f);
        if (rocket instanceof EntityBullet && rocket.getIsChopper()) {
            this.func_110776_a(new ResourceLocation("hbm:textures/models/projectiles/emplacer.png"));
        } else if (rocket instanceof EntityBullet && rocket.getIsCritical()) {
            this.func_110776_a(new ResourceLocation("hbm:textures/models/projectiles/tau.png"));
        } else if (rocket instanceof EntityBullet) {
            this.func_110776_a(new ResourceLocation("hbm:textures/models/projectiles/bullet.png"));
        }
        this.miniNuke.renderAll(0.0625f);
        GL11.glPopMatrix();
    }

    public void func_76979_b(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
    }

    protected ResourceLocation getEntityTexture(EntityBullet entity) {
        if (entity.getIsChopper()) {
            return new ResourceLocation("hbm:textures/models/projectiles/emplacer.png");
        }
        if (entity.getIsCritical()) {
            return new ResourceLocation("hbm:textures/models/projectiles/tau.png");
        }
        return new ResourceLocation("hbm:textures/models/projectiles/bullet.png");
    }
}

