/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.entity.missile.EntityCarrier;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.lib.Library;
import com.hbm.main.ClientProxy;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.util.BobMathUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.glu.Project;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    public static Field r_setTileEntities;
    public static Field r_viewFrustum;
    public static Method r_getRenderChunk;
    private static FloatBuffer MODELVIEW;
    private static FloatBuffer PROJECTION;
    private static IntBuffer VIEWPORT;
    private static FloatBuffer POSITION;
    public static boolean useFullPost;
    public static boolean flashlightInit;
    public static int shadowFbo;
    public static int shadowFboTex;
    public static int height;
    public static int width;
    public static int deferredFbo;
    public static int deferredColorTex;
    public static int deferredPositionTex;
    public static int deferredProjCoordTex;
    public static int deferredNormalTex;
    public static int deferredDepthTex;
    public static float[] inv_ViewProjectionMatrix;
    public static boolean renderingFlashlights;
    private static boolean flashlightLock;
    private static List<Runnable> flashlightQueue;

    public static float[] getScreenAreaFromQuad(Vec3d lb, Vec3d rb, Vec3d rt, Vec3d lt) {
        FloatBuffer mmatrix = GLAllocation.func_74529_h((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)mmatrix);
        FloatBuffer pmatrix = GLAllocation.func_74529_h((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)pmatrix);
        IntBuffer vport = GLAllocation.func_74527_f((int)16);
        GL11.glGetInteger((int)2978, (IntBuffer)vport);
        FloatBuffer[] points = new FloatBuffer[4];
        FloatBuffer buf0 = GLAllocation.func_74529_h((int)3);
        Project.gluProject((float)((float)lb.field_72450_a), (float)((float)lb.field_72448_b), (float)((float)lb.field_72449_c), (FloatBuffer)mmatrix, (FloatBuffer)pmatrix, (IntBuffer)vport, (FloatBuffer)buf0);
        points[0] = buf0;
        FloatBuffer buf1 = GLAllocation.func_74529_h((int)3);
        Project.gluProject((float)((float)rb.field_72450_a), (float)((float)rb.field_72448_b), (float)((float)rb.field_72449_c), (FloatBuffer)mmatrix, (FloatBuffer)pmatrix, (IntBuffer)vport, (FloatBuffer)buf1);
        points[1] = buf1;
        FloatBuffer buf2 = GLAllocation.func_74529_h((int)3);
        Project.gluProject((float)((float)rt.field_72450_a), (float)((float)rt.field_72448_b), (float)((float)rt.field_72449_c), (FloatBuffer)mmatrix, (FloatBuffer)pmatrix, (IntBuffer)vport, (FloatBuffer)buf2);
        points[2] = buf2;
        FloatBuffer buf3 = GLAllocation.func_74529_h((int)3);
        Project.gluProject((float)((float)lt.field_72450_a), (float)((float)lt.field_72448_b), (float)((float)lt.field_72449_c), (FloatBuffer)mmatrix, (FloatBuffer)pmatrix, (IntBuffer)vport, (FloatBuffer)buf3);
        points[3] = buf3;
        float top = buf0.get(1);
        float bottom = buf0.get(1);
        float left = buf0.get(0);
        float right = buf0.get(0);
        for (FloatBuffer buf : points) {
            if (buf.get(0) > right) {
                right = buf.get(0);
            }
            if (buf.get(0) < left) {
                left = buf.get(0);
            }
            if (buf.get(1) > top) {
                top = buf.get(1);
            }
            if (!(buf.get(1) < bottom)) continue;
            bottom = buf.get(1);
        }
        if (bottom < 0.0f) {
            bottom = 0.0f;
        }
        if (top > (float)Minecraft.func_71410_x().field_71440_d) {
            top = Minecraft.func_71410_x().field_71440_d;
        }
        if (left < 0.0f) {
            left = 0.0f;
        }
        if (right > (float)Minecraft.func_71410_x().field_71443_c) {
            right = Minecraft.func_71410_x().field_71443_c;
        }
        if (right <= 0.0f || top <= 0.0f || bottom >= (float)Minecraft.func_71410_x().field_71440_d || left >= (float)Minecraft.func_71410_x().field_71443_c) {
            return null;
        }
        return new float[]{left, bottom, right, top};
    }

    public static TextureAtlasSprite getItemTexture(Item item, int meta) {
        return RenderHelper.getItemTexture(new ItemStack(item, 1, meta));
    }

    public static TextureAtlasSprite getItemTexture(Item item) {
        return RenderHelper.getItemTexture(item, 0);
    }

    public static TextureAtlasSprite getItemTexture(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(item, null, null).func_177554_e();
    }

    public static void addVertexWithUV(double x, double y, double z, double u, double v) {
        RenderHelper.addVertexWithUV(x, y, z, u, v, Tessellator.func_178181_a());
    }

    public static void addVertex(double x, double y, double z) {
        Tessellator.func_178181_a().func_178180_c().func_181662_b(x, y, z).func_181675_d();
    }

    public static void addVertexWithUV(double x, double y, double z, double u, double v, Tessellator tes) {
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181662_b(x, y, z).func_187315_a(u, v).func_181675_d();
    }

    public static void startDrawingTexturedQuads() {
        RenderHelper.startDrawingTexturedQuads(Tessellator.func_178181_a());
    }

    public static void startDrawingQuads() {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181705_e);
    }

    public static void startDrawingTexturedQuads(Tessellator tes) {
        tes.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
    }

    public static void startDrawingColoredTriangles(Tessellator tes) {
        tes.func_178180_c().func_181668_a(6, DefaultVertexFormats.field_181706_f);
    }

    public static void draw() {
        RenderHelper.draw(Tessellator.func_178181_a());
    }

    public static void draw(Tessellator tes) {
        tes.func_78381_a();
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resource);
    }

    public static void bindBlockTexture() {
        RenderHelper.bindTexture(TextureMap.field_110575_b);
    }

    public static void drawScaledTexture(TextureAtlasSprite icon, int posX, int posY, int sizeX, int sizeY, float zLevel) {
        if (sizeX < 0) {
            sizeX = 0;
        }
        if (sizeX > 16) {
            sizeX = 16;
        }
        if (sizeY < 0) {
            sizeY = 0;
        }
        if (sizeY > 16) {
            sizeY = 16;
        }
        float up = icon.func_94207_b(16.0);
        float down = icon.func_94207_b((double)(16 - sizeY));
        float left = icon.func_94214_a(0.0);
        float right = icon.func_94214_a((double)sizeX);
        RenderHelper.addVertexWithUV(posX, posY + sizeY, zLevel, left, up);
        RenderHelper.addVertexWithUV(posX + sizeX, posY + sizeY, zLevel, right, up);
        RenderHelper.addVertexWithUV(posX + sizeX, posY, zLevel, right, down);
        RenderHelper.addVertexWithUV(posX, posY, zLevel, left, down);
    }

    public static void drawFullTexture(TextureAtlasSprite icon, double posX, double posY, double sizeX, double sizeY, double zLevel, boolean flipped) {
        float up = icon.func_94207_b(0.0);
        float down = icon.func_94207_b(16.0);
        float left = icon.func_94214_a(0.0);
        float right = icon.func_94214_a(16.0);
        if (flipped) {
            RenderHelper.addVertexWithUV(posX + sizeX, posY + sizeY, zLevel, right, up);
            RenderHelper.addVertexWithUV(posX, posY + sizeY, zLevel, left, up);
            RenderHelper.addVertexWithUV(posX, posY, zLevel, left, down);
            RenderHelper.addVertexWithUV(posX + sizeX, posY, zLevel, right, down);
        } else {
            RenderHelper.addVertexWithUV(posX, posY + sizeY, zLevel, left, up);
            RenderHelper.addVertexWithUV(posX + sizeX, posY + sizeY, zLevel, right, up);
            RenderHelper.addVertexWithUV(posX + sizeX, posY, zLevel, right, down);
            RenderHelper.addVertexWithUV(posX, posY, zLevel, left, down);
        }
    }

    public static void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void unpackColor(int color, float[] col) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        col[0] = red;
        col[1] = green;
        col[2] = blue;
    }

    public static void resetColor() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void startDrawingColored(int i) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(i, DefaultVertexFormats.field_181706_f);
    }

    public static void addVertexColor(double x, double y, double z, int red, int green, int blue, int alpha) {
        Tessellator.func_178181_a().func_178180_c().func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_181675_d();
    }

    public static void addVertexColor(double x, double y, double z, float red, float green, float blue, float alpha) {
        Tessellator.func_178181_a().func_178180_c().func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    public static void addVertexColor(double x, double y, double z, float red, float green, float blue, float alpha, Tessellator tess) {
        tess.func_178180_c().func_181662_b(x, y, z).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    public static void renderAll(IBakedModel boxcar) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (BakedQuad quad : boxcar.func_188616_a(null, null, 0L)) {
            buf.func_178981_a(quad.func_178209_a());
        }
        tes.func_78381_a();
    }

    public static double[] getRenderPosFromMissile(EntityMissileBaseAdvanced missile, float partialTicks) {
        double d0 = missile.field_70169_q + (missile.field_70165_t - missile.field_70169_q) * (double)partialTicks;
        double d1 = missile.field_70167_r + (missile.field_70163_u - missile.field_70167_r) * (double)partialTicks;
        double d2 = missile.field_70166_s + (missile.field_70161_v - missile.field_70166_s) * (double)partialTicks;
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return new double[]{d0 - d3, d1 - d4, d2 - d5};
    }

    public static double[] getRenderPosFromMissile(EntityMissileCustom missile, float partialTicks) {
        double d0 = missile.field_70169_q + (missile.field_70165_t - missile.field_70169_q) * (double)partialTicks;
        double d1 = missile.field_70167_r + (missile.field_70163_u - missile.field_70167_r) * (double)partialTicks;
        double d2 = missile.field_70166_s + (missile.field_70161_v - missile.field_70166_s) * (double)partialTicks;
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return new double[]{d0 - d3, d1 - d4, d2 - d5};
    }

    public static double[] getRenderPosFromMissile(EntityCarrier missile, float partialTicks) {
        if (missile.prevPosX2 == 0.0) {
            missile.prevPosX2 = missile.field_70165_t;
        }
        if (missile.prevPosY2 == 0.0) {
            missile.prevPosY2 = missile.field_70163_u;
        }
        if (missile.prevPosZ2 == 0.0) {
            missile.prevPosZ2 = missile.field_70161_v;
        }
        double d0 = missile.prevPosX2 + (missile.field_70165_t - missile.prevPosX2) * (double)partialTicks;
        double d1 = missile.prevPosY2 + (missile.field_70163_u - missile.prevPosY2) * (double)partialTicks;
        double d2 = missile.prevPosZ2 + (missile.field_70161_v - missile.prevPosZ2) * (double)partialTicks;
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return new double[]{d0 - d3, d1 - d4, d2 - d5};
    }

    public static void drawGuiRect(float x, float y, float u, float v, float width, float height, float uMax, float vMax) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)u, (double)vMax).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)uMax, (double)vMax).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)uMax, (double)v).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGuiRectColor(float x, float y, float u, float v, float width, float height, float uMax, float vMax, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)u, (double)vMax).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)uMax, (double)vMax).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)uMax, (double)v).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u, (double)v).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGuiRectBatched(float x, float y, float u, float v, float width, float height, float uMax, float vMax) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)u, (double)vMax).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)uMax, (double)vMax).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)uMax, (double)v).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u, (double)v).func_181675_d();
    }

    public static void drawGuiRectBatchedColor(float x, float y, float u, float v, float width, float height, float uMax, float vMax, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)u, (double)vMax).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)uMax, (double)vMax).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)uMax, (double)v).func_181666_a(r, g, b, a).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)u, (double)v).func_181666_a(r, g, b, a).func_181675_d();
    }

    @Deprecated
    private static void initializeFL() {
        shadowFbo = GL30.glGenFramebuffers();
        shadowFboTex = GL11.glGenTextures();
        GlStateManager.func_179144_i((int)shadowFboTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)33191, (int)1024, (int)1024, (int)0, (int)6402, (int)5125, (FloatBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL30.glBindFramebuffer((int)36160, (int)shadowFbo);
        GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)shadowFboTex, (int)0);
        RenderHelper.clearFLShadowBuffer();
        int bruh = GL30.glCheckFramebufferStatus((int)36160);
        if (bruh != 36053) {
            System.out.println("aaaaaa");
        }
    }

    @Deprecated
    private static void clearFLShadowBuffer() {
        GL30.glBindFramebuffer((int)36160, (int)shadowFbo);
        GlStateManager.func_179151_a((double)1.0);
        GL11.glClear((int)256);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    @Deprecated
    private static void bindFLShadowBuffer() {
        GL30.glBindFramebuffer((int)36160, (int)shadowFbo);
        GlStateManager.func_179083_b((int)0, (int)0, (int)1024, (int)1024);
    }

    @Deprecated
    private static void deleteDeferredFbo() {
        GL11.glDeleteTextures((int)deferredColorTex);
        GL11.glDeleteTextures((int)deferredPositionTex);
        GL11.glDeleteTextures((int)deferredProjCoordTex);
        GL11.glDeleteTextures((int)deferredNormalTex);
        GL11.glDeleteTextures((int)deferredDepthTex);
        GL30.glDeleteFramebuffers((int)deferredFbo);
        deferredColorTex = -1;
        deferredPositionTex = -1;
        deferredProjCoordTex = -1;
        deferredNormalTex = -1;
        deferredDepthTex = -1;
    }

    @Deprecated
    private static void recreateDeferredFbo() {
        deferredFbo = GL30.glGenFramebuffers();
        deferredColorTex = GL11.glGenTextures();
        if (!useFullPost) {
            deferredPositionTex = GL11.glGenTextures();
            deferredProjCoordTex = GL11.glGenTextures();
            deferredNormalTex = GL11.glGenTextures();
        } else {
            deferredDepthTex = GL11.glGenTextures();
        }
        GL30.glBindFramebuffer((int)36160, (int)deferredFbo);
        GlStateManager.func_179144_i((int)deferredColorTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (FloatBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)deferredColorTex, (int)0);
        if (!useFullPost) {
            GlStateManager.func_179144_i((int)deferredPositionTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5126, (FloatBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL30.glFramebufferTexture2D((int)36160, (int)36065, (int)3553, (int)deferredPositionTex, (int)0);
            GlStateManager.func_179144_i((int)deferredProjCoordTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5126, (FloatBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL30.glFramebufferTexture2D((int)36160, (int)36066, (int)3553, (int)deferredProjCoordTex, (int)0);
            GlStateManager.func_179144_i((int)deferredNormalTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5126, (FloatBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL30.glFramebufferTexture2D((int)36160, (int)36067, (int)3553, (int)deferredNormalTex, (int)0);
            GL30.glBindRenderbuffer((int)36161, (int)Minecraft.func_71410_x().func_147110_a().field_147624_h);
            GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)Minecraft.func_71410_x().func_147110_a().field_147624_h);
            IntBuffer buf = GLAllocation.func_74527_f((int)4);
            buf.put(36064);
            buf.put(36065);
            buf.put(36066);
            buf.put(36067);
            buf.rewind();
            GL20.glDrawBuffers((IntBuffer)buf);
        } else {
            GlStateManager.func_179144_i((int)deferredDepthTex);
            GL11.glTexImage2D((int)3553, (int)0, (int)33190, (int)width, (int)height, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)deferredDepthTex, (int)0);
        }
        int bruh = GL30.glCheckFramebufferStatus((int)36160);
        if (bruh != 36053) {
            System.out.println("aaaaaa");
        }
    }

    @Deprecated
    private static void clearDeferredBuffer() {
        GL30.glBindFramebuffer((int)36160, (int)deferredFbo);
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (!useFullPost) {
            GlStateManager.func_179151_a((double)1.0);
            GL11.glClear((int)16640);
        } else {
            GL11.glClear((int)16384);
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    @Deprecated
    public static void renderFlashlights() {
        renderingFlashlights = true;
        if (height != Minecraft.func_71410_x().field_71440_d || width != Minecraft.func_71410_x().field_71443_c) {
            height = Minecraft.func_71410_x().field_71440_d;
            width = Minecraft.func_71410_x().field_71443_c;
            RenderHelper.deleteDeferredFbo();
            RenderHelper.recreateDeferredFbo();
        }
        GL30.glBindFramebuffer((int)36008, (int)Minecraft.func_71410_x().func_147110_a().field_147616_f);
        GL30.glBindFramebuffer((int)36009, (int)deferredFbo);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)256, (int)9728);
        GL11.glPushMatrix();
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        GL11.glPopMatrix();
        GL11.glGetFloat((int)2983, (FloatBuffer)ClientProxy.AUX_GL_BUFFER2);
        Matrix4f view = new Matrix4f();
        Matrix4f proj = new Matrix4f();
        view.load(ClientProxy.AUX_GL_BUFFER);
        proj.load(ClientProxy.AUX_GL_BUFFER2);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER2.rewind();
        view.invert();
        proj.invert();
        Matrix4f.mul((Matrix4f)view, (Matrix4f)proj, (Matrix4f)view);
        view.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER.get(inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
        for (Runnable r : flashlightQueue) {
            r.run();
        }
        flashlightQueue.clear();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        renderingFlashlights = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void renderFlashLight(Vec3d start, Vec3d end, float degrees, float brightness, ResourceLocation cookie, float partialTicks) {
        if (flashlightLock) {
            return;
        }
        if (!renderingFlashlights) {
            flashlightQueue.add(() -> RenderHelper.renderFlashLight(start, end, degrees, brightness, cookie, partialTicks));
            return;
        }
        flashlightLock = true;
        if (!flashlightInit) {
            RenderHelper.initializeFL();
            flashlightInit = true;
        }
        RenderHelper.clearDeferredBuffer();
        double radians = Math.toRadians(degrees);
        Vec3d startToEnd = end.func_178788_d(start);
        double height = startToEnd.func_72433_c();
        double radius = height * Math.tan(radians);
        AxisAlignedBB box = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c).func_186662_g(radius);
        box = new AxisAlignedBB((double)(MathHelper.func_76128_c((double)(box.field_72340_a / 16.0)) * 16), (double)(MathHelper.func_76128_c((double)(MathHelper.func_151237_a((double)box.field_72338_b, (double)0.0, (double)255.0) / 16.0)) * 16), (double)(MathHelper.func_76128_c((double)(box.field_72339_c / 16.0)) * 16), (double)(MathHelper.func_76143_f((double)(box.field_72336_d / 16.0)) * 16), (double)(MathHelper.func_76143_f((double)(MathHelper.func_151237_a((double)box.field_72337_e, (double)0.0, (double)255.0) / 16.0)) * 16), (double)(MathHelper.func_76143_f((double)(box.field_72334_f / 16.0)) * 16));
        ArrayList<RenderChunk> toRender = new ArrayList<RenderChunk>();
        ArrayList<Entity> entitiesToRender = new ArrayList<Entity>();
        ArrayList<TileEntity> tilesToRender = new ArrayList<TileEntity>();
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        int i = (int)box.field_72340_a;
        while ((double)i < box.field_72336_d) {
            int j = (int)box.field_72338_b;
            while ((double)j < box.field_72337_e) {
                int k = (int)box.field_72339_c;
                while ((double)k < box.field_72334_f) {
                    if (Minecraft.func_71410_x().field_71441_e.func_175667_e(new BlockPos(i, j, k))) {
                        RenderChunk chunk = RenderHelper.getRenderChunk(new BlockPos(i, j, k));
                        ClassInheritanceMultiMap classinheritancemultimap = Minecraft.func_71410_x().field_71441_e.func_175726_f(chunk.func_178568_j()).func_177429_s()[chunk.func_178568_j().func_177956_o() / 16];
                        if (Library.isBoxCollidingCone(chunk.field_178591_c, start, end, degrees)) {
                            toRender.add(chunk);
                            for (TileEntity te : chunk.field_178590_b.func_178485_b()) {
                                if (!Library.isBoxCollidingCone(te.getRenderBoundingBox(), start, end, degrees)) continue;
                                tilesToRender.add(te);
                            }
                            for (Entity ent : classinheritancemultimap) {
                                if (ent == renderView || !Library.isBoxCollidingCone(ent.func_184177_bl().func_186662_g(0.5), start, end, degrees)) continue;
                                entitiesToRender.add(ent);
                            }
                        }
                    }
                    k += 16;
                }
                j += 16;
            }
            i += 16;
        }
        try {
            Set globals;
            if (r_setTileEntities == null) {
                r_setTileEntities = ReflectionHelper.findField(RenderGlobal.class, (String)"setTileEntities", (String)"field_181024_n");
            }
            Set set = globals = (Set)r_setTileEntities.get(Minecraft.func_71410_x().field_71438_f);
            synchronized (set) {
                for (TileEntity te : globals) {
                    if (!Library.isBoxCollidingCone(te.getRenderBoundingBox(), start, end, degrees)) continue;
                    tilesToRender.add(te);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        double entPosX = renderView.field_70142_S + (renderView.field_70165_t - renderView.field_70142_S) * (double)partialTicks;
        double entPosY = renderView.field_70137_T + (renderView.field_70163_u - renderView.field_70137_T) * (double)partialTicks;
        double entPosZ = renderView.field_70136_U + (renderView.field_70161_v - renderView.field_70136_U) * (double)partialTicks;
        Vec3d playerPos = new Vec3d(entPosX, entPosY, entPosZ);
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)4.0f);
        RenderGlobal.func_189697_a((AxisAlignedBB)box.func_72317_d(-entPosX, -entPosY, -entPosZ), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)(start.field_72450_a - entPosX), (double)(start.field_72448_b - entPosY), (double)(start.field_72449_c - entPosZ));
        GL11.glVertex3d((double)(end.field_72450_a - entPosX), (double)(end.field_72448_b - entPosY), (double)(end.field_72449_c - entPosZ));
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        RenderHelper.bindBlockTexture();
        GlStateManager.func_179117_G();
        GlStateManager.func_179088_q();
        GlStateManager.func_179089_o();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        RenderHelper.enableBlockVBOs();
        RenderHelper.clearFLShadowBuffer();
        RenderHelper.bindFLShadowBuffer();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GlStateManager.func_179128_n((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Project.gluPerspective((float)(degrees * 2.0f), (float)1.0f, (float)0.05f, (float)((float)height * MathHelper.field_180189_a));
        GlStateManager.func_179128_n((int)5888);
        Vec3d angles = BobMathUtil.getEulerAngles(startToEnd.func_72432_b());
        GL11.glRotated((double)(-angles.field_72448_b + 270.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(-angles.field_72450_a + 180.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(-(start.field_72450_a - entPosX)), (double)(-(start.field_72448_b - entPosY)), (double)(-(start.field_72449_c - entPosZ)));
        GL11.glGetFloat((int)2983, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER2);
        float[] projecion = new float[16];
        float[] view = new float[16];
        ClientProxy.AUX_GL_BUFFER.get(projecion);
        ClientProxy.AUX_GL_BUFFER2.get(view);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER2.rewind();
        ResourceManager.flashlight_depth.use();
        RenderHelper.renderChunks(toRender, entPosX, entPosY, entPosZ);
        RenderHelper.disableBlockVBOs();
        OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
        for (Entity ent : entitiesToRender) {
            Minecraft.func_71410_x().func_175598_ae().func_188388_a(ent, partialTicks, false);
        }
        for (TileEntity te : tilesToRender) {
            TileEntityRendererDispatcher.field_147556_a.func_180546_a(te, partialTicks, -1);
        }
        GlStateManager.func_179128_n((int)5889);
        GL11.glPopMatrix();
        GlStateManager.func_179128_n((int)5888);
        GL11.glPopMatrix();
        GL30.glBindFramebuffer((int)36160, (int)deferredFbo);
        GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)RenderHelper.height);
        if (useFullPost) {
            GL30.glBindFramebuffer((int)36160, (int)deferredFbo);
            ResourceManager.flashlight_post.use();
            RenderHelper.sendFlashLightPostUniforms(ResourceManager.flashlight_post.getShaderId(), playerPos, start, (float)height, brightness, view, projecion, cookie);
            RenderHelper.renderFullscreenTriangle();
            HbmShaderManager2.releaseShader();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179144_i((int)deferredColorTex);
            ResourceManager.blit.use();
        }
        RenderHelper.renderFullscreenTriangle();
        HbmShaderManager2.releaseShader();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        flashlightLock = false;
    }

    @Deprecated
    private static void volumetricRender(Vec3d start, Vec3d end, Vec3d playerPos, float radius, float degrees) {
        Vec3d vec = end.func_178788_d(start);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        ResourceManager.cone_volume.use();
        int shader = ResourceManager.cone_volume.getShaderId();
        float height = (float)vec.func_72433_c();
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"height"), (float)height);
        vec = vec.func_72432_b();
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"cosAngle"), (float)((float)Math.cos(Math.toRadians(degrees))));
        Vec3d pos = start.func_178788_d(playerPos);
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"pos"), (float)((float)pos.field_72450_a), (float)((float)pos.field_72448_b - Minecraft.func_71410_x().func_175606_aa().func_70047_e()), (float)((float)pos.field_72449_c));
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"direction"), (float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c));
        GlStateManager.func_179138_g((int)33987);
        GlStateManager.func_179144_i((int)shadowFboTex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"shadow"), (int)3);
        GlStateManager.func_179138_g((int)33988);
        GlStateManager.func_179144_i((int)deferredDepthTex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"depth"), (int)4);
        GlStateManager.func_179138_g((int)33984);
        ClientProxy.AUX_GL_BUFFER.put(inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"inv_ViewProjectionMatrix"), (boolean)false, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        GlStateManager.func_179089_o();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GlStateManager.func_179128_n((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GlStateManager.func_179128_n((int)5888);
        RenderHelper.renderFullscreenTriangle();
        GlStateManager.func_179128_n((int)5889);
        GL11.glPopMatrix();
        GlStateManager.func_179128_n((int)5888);
        GL11.glPopMatrix();
        HbmShaderManager2.releaseShader();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
    }

    public static void renderConeMesh(Vec3d start, Vec3d normal, float height, float radius, int sides) {
        int i;
        float[] vertices = new float[(1 + sides) * 3];
        vertices[0] = 0.0f;
        vertices[1] = 0.0f;
        vertices[2] = 0.0f;
        Vec3d vertex = new Vec3d((double)radius, 0.0, 0.0);
        for (int i2 = 0; i2 < sides; ++i2) {
            vertex = vertex.func_178785_b((float)(Math.PI * 2 * (double)(1.0f / (float)sides)));
            vertices[(i2 + 1) * 3] = (float)vertex.field_72450_a;
            vertices[(i2 + 1) * 3 + 1] = (float)vertex.field_72448_b - height;
            vertices[(i2 + 1) * 3 + 2] = (float)vertex.field_72449_c;
        }
        GL11.glPushMatrix();
        Vec3d angles = BobMathUtil.getEulerAngles(normal);
        GL11.glTranslated((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
        GL11.glRotated((double)(angles.field_72450_a + 180.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(angles.field_72448_b + 180.0), (double)1.0, (double)0.0, (double)0.0);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        for (i = 2; i <= sides; ++i) {
            buf.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            buf.func_181662_b((double)vertices[(i - 1) * 3], (double)vertices[(i - 1) * 3 + 1], (double)vertices[(i - 1) * 3 + 2]).func_181675_d();
            buf.func_181662_b((double)vertices[i * 3], (double)vertices[i * 3 + 1], (double)vertices[i * 3 + 2]).func_181675_d();
        }
        buf.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        buf.func_181662_b((double)vertices[sides * 3], (double)vertices[sides * 3 + 1], (double)vertices[sides * 3 + 2]).func_181675_d();
        buf.func_181662_b((double)vertices[3], (double)vertices[4], (double)vertices[5]).func_181675_d();
        for (i = 1; i < sides - 1; ++i) {
            buf.func_181662_b((double)vertices[3], (double)vertices[4], (double)vertices[5]).func_181675_d();
            buf.func_181662_b((double)vertices[(i + 2) * 3], (double)vertices[(i + 2) * 3 + 1], (double)vertices[(i + 2) * 3 + 2]).func_181675_d();
            buf.func_181662_b((double)vertices[(i + 1) * 3], (double)vertices[(i + 1) * 3 + 1], (double)vertices[(i + 1) * 3 + 2]).func_181675_d();
        }
        tes.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void enableBlockVBOs() {
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
    }

    public static void disableBlockVBOs() {
        for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
            int k1 = vertexformatelement.func_177369_e();
            switch (vertexformatelement$enumusage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + k1));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                }
            }
        }
    }

    public static void renderChunks(Collection<RenderChunk> toRender, double posX, double posY, double posZ) {
        for (RenderChunk chunk : toRender) {
            GL11.glPushMatrix();
            BlockPos chunkPos = chunk.func_178568_j();
            GL11.glTranslated((double)((double)chunkPos.func_177958_n() - posX), (double)((double)chunkPos.func_177956_o() - posY), (double)((double)chunkPos.func_177952_p() - posZ));
            chunk.func_178572_f();
            for (int i = 0; i < 3; ++i) {
                if (chunk.func_178571_g().func_178491_b(BlockRenderLayer.values()[i]) || chunk.func_178565_b(i) == null) continue;
                if (i == 2) {
                    Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
                }
                VertexBuffer buf = chunk.func_178565_b(i);
                buf.func_177359_a();
                GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
                GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
                GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                buf.func_177358_a(7);
                if (i != 2) continue;
                Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            }
            GL11.glPopMatrix();
        }
    }

    @Deprecated
    private static void sendFlashlightUniforms(int shader, Vec3d playerPos, Vec3d pos, Vec3d normal, float height, float degrees, ResourceLocation flashlight_tex) {
        pos = pos.func_178788_d(playerPos);
        pos = BobMathUtil.viewFromLocal(new Vector4f((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, 1.0f))[0];
        normal = BobMathUtil.viewFromLocal(new Vector4f((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f))[0];
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"angle"), (float)((float)Math.cos(Math.toRadians(degrees))));
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"height"), (float)height);
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"pos"), (float)((float)pos.field_72450_a), (float)((float)pos.field_72448_b), (float)((float)pos.field_72449_c));
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"direction"), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c));
        GlStateManager.func_179138_g((int)33987);
        GlStateManager.func_179144_i((int)shadowFboTex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"shadowTex"), (int)3);
        GlStateManager.func_179138_g((int)33988);
        RenderHelper.bindTexture(flashlight_tex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"flashlightTex"), (int)4);
        GlStateManager.func_179138_g((int)33984);
    }

    @Deprecated
    private static void sendFlashLightPostUniforms(int shader, Vec3d playerPos, Vec3d pos, float height, float brightness, float[] shadowView, float[] shadowProjection, ResourceLocation flashlight_tex) {
        pos = pos.func_178788_d(playerPos);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"height"), (float)height);
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"fs_Pos"), (float)((float)pos.field_72450_a), (float)((float)pos.field_72448_b), (float)((float)pos.field_72449_c));
        GL20.glUniform2f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"zNearFar"), (float)0.05f, (float)((float)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16) * MathHelper.field_180189_a));
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"eyeHeight"), (float)Minecraft.func_71410_x().field_71439_g.func_70047_e());
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"brightness"), (float)brightness);
        GlStateManager.func_179138_g((int)33987);
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"mc_tex"), (int)3);
        GlStateManager.func_179138_g((int)33988);
        GlStateManager.func_179144_i((int)deferredDepthTex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"depthBuffer"), (int)4);
        GlStateManager.func_179138_g((int)33989);
        RenderHelper.bindTexture(flashlight_tex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"flashlightTex"), (int)5);
        GlStateManager.func_179138_g((int)33990);
        GlStateManager.func_179144_i((int)shadowFboTex);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"shadowTex"), (int)6);
        GlStateManager.func_179138_g((int)33984);
        Matrix4f view = new Matrix4f();
        Matrix4f proj = new Matrix4f();
        ClientProxy.AUX_GL_BUFFER.put(shadowView);
        ClientProxy.AUX_GL_BUFFER2.put(shadowProjection);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER2.rewind();
        view.load(ClientProxy.AUX_GL_BUFFER);
        proj.load(ClientProxy.AUX_GL_BUFFER2);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER2.rewind();
        Matrix4f.mul((Matrix4f)proj, (Matrix4f)view, (Matrix4f)view);
        view.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"flashlight_ViewProjectionMatrix"), (boolean)false, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.put(inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GL20.glUniformMatrix4((int)GL20.glGetUniformLocation((int)shader, (CharSequence)"inv_ViewProjectionMatrix"), (boolean)false, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
    }

    public static RenderChunk getRenderChunk(BlockPos pos) {
        try {
            if (r_viewFrustum == null) {
                r_viewFrustum = ReflectionHelper.findField(RenderGlobal.class, (String)"viewFrustum", (String)"field_175008_n");
            }
            if (r_getRenderChunk == null) {
                r_getRenderChunk = ReflectionHelper.findMethod(ViewFrustum.class, (String)"getRenderChunk", (String)"func_178161_a", (Class[])new Class[]{BlockPos.class});
            }
            ViewFrustum v = (ViewFrustum)r_viewFrustum.get(Minecraft.func_71410_x().field_71438_f);
            RenderChunk r = (RenderChunk)r_getRenderChunk.invoke((Object)v, pos);
            return r;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void renderFullscreenTriangle() {
        RenderHelper.renderFullscreenTriangle(false);
    }

    public static void renderFullscreenTriangle(boolean alpha) {
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)alpha);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179142_g();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(3.0, -1.0, 0.0).func_187315_a(2.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 3.0, 0.0).func_187315_a(0.0, 2.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void resetParticleInterpPos(Entity entityIn, float partialTicks) {
        double entPosX = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double entPosY = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double entPosZ = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_70556_an = entPosX;
        Particle.field_70554_ao = entPosY;
        Particle.field_70555_ap = entPosZ;
    }

    public static float[] project(float x, float y, float z) {
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT);
        Project.gluProject((float)x, (float)y, (float)z, (FloatBuffer)MODELVIEW, (FloatBuffer)PROJECTION, (IntBuffer)VIEWPORT, (FloatBuffer)POSITION);
        return new float[]{POSITION.get(0), POSITION.get(1), POSITION.get(2)};
    }

    public static float[] unproject(float x, float y, float z) {
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT);
        Project.gluUnProject((float)x, (float)y, (float)z, (FloatBuffer)MODELVIEW, (FloatBuffer)PROJECTION, (IntBuffer)VIEWPORT, (FloatBuffer)POSITION);
        return new float[]{POSITION.get(0), POSITION.get(1), POSITION.get(2)};
    }

    public static Vec3d unproject_world(float[] inv_mvp, float x, float y, float z) {
        Matrix4f mat = new Matrix4f();
        ClientProxy.AUX_GL_BUFFER.put(inv_mvp);
        ClientProxy.AUX_GL_BUFFER.rewind();
        mat.load(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        Vector4f ndcPos = new Vector4f();
        ndcPos.x = 2.0f * x / (float)Minecraft.func_71410_x().field_71443_c - 1.0f;
        ndcPos.y = 2.0f * y / (float)Minecraft.func_71410_x().field_71440_d - 1.0f;
        float near = 0.0f;
        float far = 1.0f;
        ndcPos.z = (2.0f * z - near - far) / (far - near);
        ndcPos.w = 1.0f;
        Matrix4f.transform((Matrix4f)mat, (Vector4f)ndcPos, (Vector4f)ndcPos);
        float invW = 1.0f / ndcPos.w;
        Vector3f worldPos = new Vector3f(ndcPos.x * invW, ndcPos.y * invW, ndcPos.z * invW);
        Entity ent = Minecraft.func_71410_x().func_175606_aa();
        float partialTicks = MainRegistry.proxy.partialTicks();
        double rPosX = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)partialTicks;
        double rPosY = ent.field_70167_r + (ent.field_70163_u - ent.field_70167_r) * (double)partialTicks;
        double rPosZ = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)partialTicks;
        return new Vec3d((double)worldPos.x + rPosX, (double)worldPos.y + rPosY, (double)worldPos.z + rPosZ);
    }

    public static boolean intersects2DBox(float x, float y, float[] box) {
        return x > box[0] && x < box[2] && y > box[1] && y < box[3];
    }

    public static boolean boxesOverlap(float[] box1, float[] box2) {
        return box1[0] < box2[2] && box1[2] > box2[0] && box1[1] < box2[3] && box1[3] > box2[1];
    }

    public static boolean boxContainsOther(float[] box, float[] other) {
        return box[0] <= other[0] && box[1] <= other[1] && box[2] >= other[2] && box[3] >= other[3];
    }

    public static float[] getBoxCenter(float[] box) {
        return new float[]{box[0] + (box[2] - box[0]) * 0.5f, box[1] + (box[3] - box[1]) * 0.5f};
    }

    static {
        MODELVIEW = GLAllocation.func_74529_h((int)16);
        PROJECTION = GLAllocation.func_74529_h((int)16);
        VIEWPORT = GLAllocation.func_74527_f((int)16);
        POSITION = GLAllocation.func_74529_h((int)4);
        useFullPost = true;
        flashlightInit = false;
        height = 0;
        width = 0;
        deferredColorTex = -1;
        deferredPositionTex = -1;
        deferredProjCoordTex = -1;
        deferredNormalTex = -1;
        deferredDepthTex = -1;
        inv_ViewProjectionMatrix = new float[16];
        renderingFlashlights = false;
        flashlightLock = false;
        flashlightQueue = new ArrayList<Runnable>();
    }
}

