/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.bullet_hit;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.main.ClientProxy;
import com.hbm.main.ResourceManager;
import com.hbm.particle.ParticleLayerBase;
import com.hbm.particle.ParticleRenderLayer;
import com.hbm.render.GLCompat;
import com.hbm.render.RenderHelper;
import com.hbm.render.util.BakedModelUtil;
import com.hbm.util.BobMathUtil;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class ParticleBulletImpact
extends ParticleLayerBase {
    float yaw;
    float pitch;
    float roll;
    Vec3d norm;
    Vec3d[] vertices;
    int[] vbo;
    public static ParticleRenderLayer layer = new ParticleRenderLayer(){

        @Override
        public void preRender() {
            GlStateManager.func_179142_g();
            GlStateManager.func_179091_B();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179129_p();
            RenderHelper.resetColor();
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)-4.0f, (float)-4.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.bullet_impact);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            if (GeneralConfig.bulletHoleNormalMapping) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                ResourceManager.bimpact.use();
                GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.bullet_impact_normal);
                GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 4));
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.bullet_impact_occlusion);
                GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 5));
                GlStateManager.func_179144_i((int)HbmShaderManager2.depthTexture);
                GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
                ResourceManager.bimpact.uniform1i("normalMap", 3);
                ResourceManager.bimpact.uniform1i("occlusionMap", 4);
                ResourceManager.bimpact.uniform1i("depthBuffer", 5);
            } else {
                Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181704_d);
            }
        }

        @Override
        public void postRender() {
            if (GeneralConfig.bulletHoleNormalMapping) {
                HbmShaderManager2.releaseShader();
                GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
            } else {
                Tessellator.func_178181_a().func_78381_a();
            }
            GlStateManager.func_179113_r();
            RenderHelper.resetColor();
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
        }
    };

    public ParticleBulletImpact(World worldIn, double posXIn, double posYIn, double posZIn, float scale, int maxAge, Vec3d normal) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_70544_f = scale;
        this.field_70547_e = maxAge;
        Vec3d angles = BobMathUtil.getEulerAngles(normal);
        this.yaw = (float)angles.field_72450_a;
        this.pitch = (float)angles.field_72448_b;
        this.roll = worldIn.field_73012_v.nextFloat() * 360.0f;
        this.norm = normal;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.vertices = new Vec3d[4];
        if (GeneralConfig.bulletHoleNormalMapping) {
            this.vertices[0] = new Vec3d(-0.5, 0.0, -0.5);
            this.vertices[1] = new Vec3d(0.5, 0.0, -0.5);
            this.vertices[2] = new Vec3d(0.5, 0.0, 0.5);
            this.vertices[3] = new Vec3d(-0.5, 0.0, 0.5);
            this.vbo = BakedModelUtil.generateDecalMesh(worldIn, normal.func_186678_a(-1.0), scale, (float)this.field_187126_f, (float)this.field_187127_g, (float)this.field_187128_h, BakedModelUtil.DecalType.VBO);
        } else {
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glRotated((double)this.yaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)this.pitch, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)this.roll, (double)0.0, (double)1.0, (double)0.0);
            GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
            Matrix4f mat = new Matrix4f();
            mat.load(ClientProxy.AUX_GL_BUFFER);
            ClientProxy.AUX_GL_BUFFER.rewind();
            GL11.glPopMatrix();
            Vector4f out = new Vector4f();
            Matrix4f.transform((Matrix4f)mat, (Vector4f)new Vector4f(-0.5f, 0.0f, -0.5f, 1.0f), (Vector4f)out);
            this.vertices[0] = new Vec3d((double)out.x, (double)out.y, (double)out.z);
            Matrix4f.transform((Matrix4f)mat, (Vector4f)new Vector4f(0.5f, 0.0f, -0.5f, 1.0f), (Vector4f)out);
            this.vertices[1] = new Vec3d((double)out.x, (double)out.y, (double)out.z);
            Matrix4f.transform((Matrix4f)mat, (Vector4f)new Vector4f(0.5f, 0.0f, 0.5f, 1.0f), (Vector4f)out);
            this.vertices[2] = new Vec3d((double)out.x, (double)out.y, (double)out.z);
            Matrix4f.transform((Matrix4f)mat, (Vector4f)new Vector4f(-0.5f, 0.0f, 0.5f, 1.0f), (Vector4f)out);
            this.vertices[3] = new Vec3d((double)out.x, (double)out.y, (double)out.z);
        }
    }

    public ParticleBulletImpact color(float r, float g, float b) {
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
        return this;
    }

    public void func_189213_a() {
        ++this.field_70546_d;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float fade;
        if (GeneralConfig.bulletHoleNormalMapping && this.vbo == null) {
            return;
        }
        this.field_82339_as = fade = 1.0f - MathHelper.func_76131_a((float)((float)this.field_70546_d + partialTicks - (float)(this.field_70547_e - 10)), (float)0.0f, (float)10.0f) * 0.1f;
        double entPosX = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double entPosY = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double entPosZ = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        field_70556_an = entPosX;
        field_70554_ao = entPosY;
        field_70555_ap = entPosZ;
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - entPosX);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - entPosY);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - entPosZ);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        float scale = this.field_70544_f;
        if (GeneralConfig.bulletHoleNormalMapping) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)f5, (double)f6, (double)f7);
            GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, this.vbo[0]);
            BakedModelUtil.enableBlockShaderVBOs();
            GL11.glDrawArrays((int)4, (int)0, (int)this.vbo[1]);
            BakedModelUtil.disableBlockShaderVBOs();
            GL11.glPopMatrix();
        } else {
            buffer.func_181662_b(this.vertices[0].field_72450_a * (double)(scale *= 2.0f) + (double)f5, this.vertices[0].field_72448_b * (double)scale + (double)f6, this.vertices[0].field_72449_c * (double)scale + (double)f7).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(this.vertices[1].field_72450_a * (double)scale + (double)f5, this.vertices[1].field_72448_b * (double)scale + (double)f6, this.vertices[1].field_72449_c * (double)scale + (double)f7).func_187315_a(1.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(this.vertices[2].field_72450_a * (double)scale + (double)f5, this.vertices[2].field_72448_b * (double)scale + (double)f6, this.vertices[2].field_72449_c * (double)scale + (double)f7).func_187315_a(1.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(this.vertices[3].field_72450_a * (double)scale + (double)f5, this.vertices[3].field_72448_b * (double)scale + (double)f6, this.vertices[3].field_72449_c * (double)scale + (double)f7).func_187315_a(0.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        }
    }

    @Override
    public ParticleRenderLayer getRenderLayer() {
        return layer;
    }
}

