/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.bullet_hit;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.ResourceManager;
import com.hbm.particle.ParticleDecal;
import com.hbm.particle.ParticleLayerBase;
import com.hbm.particle.ParticleRenderLayer;
import com.hbm.particle.bullet_hit.ParticleDecalFlow;
import com.hbm.render.util.BakedModelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleBloodParticle
extends ParticleLayerBase {
    public float rotationOverLifetime;
    public int texIdx;
    public float scaleOverLifetime;
    public float prevScale;
    public boolean doesDecal = true;
    public boolean doesFlow = true;
    private static final ParticleRenderLayer layer = new ParticleRenderLayer(){

        @Override
        public void preRender() {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.blood_particles);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179142_g();
            GlStateManager.func_179091_B();
            GlStateManager.func_179145_e();
            RenderHelper.func_74519_b();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            ResourceManager.blood_dissolve.use();
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        @Override
        public void postRender() {
            Tessellator.func_178181_a().func_78381_a();
            HbmShaderManager2.releaseShader();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    };

    public ParticleBloodParticle(World worldIn, double posXIn, double posYIn, double posZIn, int idx, float scale, float scaleOverLife, int lifetime) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_70544_f = 0.5f + worldIn.field_73012_v.nextFloat() * 1.0f;
        this.field_70544_f *= scale;
        this.field_190014_F = (float)((double)this.field_187136_p.nextFloat() * Math.PI * 2.0);
        this.rotationOverLifetime = this.field_187122_b.field_73012_v.nextFloat() * 0.3f - 0.15f;
        this.field_190015_G = this.field_190014_F;
        this.texIdx = idx;
        this.field_70547_e = lifetime;
        this.field_70545_g = 1.0f;
        this.scaleOverLifetime = scaleOverLife;
        this.prevScale = this.field_70544_f;
    }

    public ParticleBloodParticle color(float r, float g, float b) {
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
        return this;
    }

    public ParticleBloodParticle motion(float x, float y, float z) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
        return this;
    }

    public ParticleBloodParticle doDecal(boolean dec) {
        this.doesDecal = dec;
        return this;
    }

    public ParticleBloodParticle doFlow(boolean flow) {
        this.doesFlow = flow;
        return this;
    }

    public void func_189213_a() {
        RayTraceResult r;
        super.func_189213_a();
        this.field_187130_j -= (double)0.04f;
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += this.rotationOverLifetime;
        this.rotationOverLifetime *= this.field_187132_l ? 0.7f : 0.95f;
        this.scaleOverLifetime *= 0.97f;
        this.prevScale = this.field_70544_f;
        this.field_70544_f += this.scaleOverLifetime;
        if ((float)this.field_70546_d * 1.5f < (float)this.field_70547_e && this.doesDecal && (r = this.field_187122_b.func_72933_a(new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h), new Vec3d(this.field_187126_f + this.field_187129_i, this.field_187127_g + this.field_187130_j, this.field_187128_h + this.field_187131_k))) != null && r.field_72313_a == RayTraceResult.Type.BLOCK) {
            Vec3d hit = r.field_72307_f;
            Vec3d direction = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k).func_72432_b();
            if (ParticleDecalFlow.numParticles >= GeneralConfig.flowingDecalAmountMax || !this.doesFlow) {
                int[] dl = BakedModelUtil.generateDecalMesh(this.field_187122_b, direction, this.field_70544_f * 0.1f, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c, BakedModelUtil.DecalType.REGULAR);
                direction = direction.func_186678_a((double)0.001f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleDecal(this.field_187122_b, dl[0], ResourceManager.blood_particles, 120, (double)((float)hit.field_72450_a) - direction.field_72450_a, (double)((float)hit.field_72448_b) - direction.field_72448_b, (double)((float)hit.field_72449_c) - direction.field_72449_c).textureIndex(this.texIdx, 4).shader(ResourceManager.blood_dissolve));
            } else {
                int[] data = BakedModelUtil.generateDecalMesh(this.field_187122_b, direction, this.field_70544_f * 0.1f, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c, BakedModelUtil.DecalType.FLOW, ResourceManager.blood_particles, this.texIdx, 4);
                direction = direction.func_186678_a((double)0.001f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleDecalFlow(this.field_187122_b, data, 150, (double)((float)hit.field_72450_a) - direction.field_72450_a, (double)((float)hit.field_72448_b) - direction.field_72448_b, (double)((float)hit.field_72449_c) - direction.field_72449_c).shader(ResourceManager.blood_dissolve));
            }
            float vel = (float)Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k);
            this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, HBMSoundHandler.blood_splat, SoundCategory.BLOCKS, vel * 0.5f, 0.8f + this.field_187136_p.nextFloat() * 0.4f, false);
            this.func_187112_i();
            return;
        }
        if (this.field_187132_l) {
            this.field_70546_d += 2;
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float size = 0.25f;
        float u = (float)(this.texIdx % 4) * size;
        float v = (float)(this.texIdx / 4) * size;
        this.field_82339_as = 1.0f - MathHelper.func_76131_a((float)((float)this.field_70546_d + partialTicks - (float)(this.field_70547_e - 10)), (float)0.0f, (float)10.0f) * 0.1f;
        float s = this.prevScale + (this.field_70544_f - this.prevScale) * partialTicks;
        float f4 = 0.1f * s;
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleBloodParticle.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleBloodParticle.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleBloodParticle.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)u + (double)size, (double)v + (double)size).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)u + (double)size, (double)v).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)u, (double)v).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)u, (double)v + (double)size).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    @Override
    public ParticleRenderLayer getRenderLayer() {
        return layer;
    }
}

