/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.bullet_hit;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PacketSpecialDeath;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityHitDataHandler {
    public static Map<EntityLivingBase, List<BulletHit>> hitData = new HashMap<EntityLivingBase, List<BulletHit>>();

    public static void updateSystem() {
        if (hitData.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<EntityLivingBase, List<BulletHit>>> itr = hitData.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<EntityLivingBase, List<BulletHit>> entry = itr.next();
            if (GeneralConfig.bloodFX && entry.getValue().size() > 8 && entry.getKey().func_110143_aJ() <= 0.0f) {
                EntityLivingBase ent = entry.getKey();
                List<BulletHit> val = entry.getValue();
                BulletHit hit = val.get(val.size() - 1);
                DamageSource source = ModDamageSource.causeBulletGibDamage(hit.bullet, hit.bullet.shooter == null ? hit.bullet : hit.bullet.shooter);
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PacketSpecialDeath((Entity)ent, 4, new float[0]), (Entity)ent);
                ent.func_110142_aN().func_94547_a(source, ent.func_110143_aJ(), ent.func_110143_aJ());
                ent.func_70106_y();
                ent.func_70645_a(source);
                ent.func_174812_G();
                if (ent instanceof EntityPlayerMP) {
                    PacketDispatcher.wrapper.sendTo((IMessage)new PacketSpecialDeath((Entity)ent, 4, new float[0]), (EntityPlayerMP)ent);
                }
                ent.field_70170_p.func_184148_a(null, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, HBMSoundHandler.mob_gib, SoundCategory.HOSTILE, 1.0f, 1.0f);
                itr.remove();
                continue;
            }
            Iterator<BulletHit> listItr = entry.getValue().iterator();
            while (listItr.hasNext()) {
                BulletHit hit = listItr.next();
                --hit.age;
                if (hit.age > 0) continue;
                listItr.remove();
            }
            if (!entry.getKey().field_70128_L && !entry.getValue().isEmpty()) continue;
            itr.remove();
        }
    }

    public static void addHit(EntityLivingBase ent, EntityBulletBase bullet, Vec3d pos, Vec3d dir) {
        List<BulletHit> data = hitData.get(ent);
        if (data == null) {
            data = new ArrayList<BulletHit>();
            hitData.put(ent, data);
        }
        if (data.size() > 35) {
            return;
        }
        BulletHit hit = new BulletHit();
        hit.pos = pos;
        hit.direction = dir;
        hit.bullet = bullet;
        data.add(hit);
    }

    public static void encodeData(Entity ent, ByteBuf buf) {
        List<BulletHit> data = hitData.get(ent);
        if (data == null) {
            buf.writeByte(0);
            return;
        }
        buf.writeByte(data.size());
        for (int i = 0; i < data.size(); ++i) {
            BulletHit hit = data.get(i);
            buf.writeDouble(hit.pos.field_72450_a);
            buf.writeDouble(hit.pos.field_72448_b);
            buf.writeDouble(hit.pos.field_72449_c);
            buf.writeFloat((float)hit.direction.field_72450_a);
            buf.writeFloat((float)hit.direction.field_72448_b);
            buf.writeFloat((float)hit.direction.field_72449_c);
        }
    }

    public static List<BulletHit> decodeData(ByteBuf buf) {
        ArrayList<BulletHit> list = new ArrayList<BulletHit>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            BulletHit hit = new BulletHit();
            hit.pos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            hit.direction = new Vec3d((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            list.add(hit);
        }
        return list;
    }

    public static class BulletHit {
        public EntityBulletBase bullet;
        public Vec3d pos;
        public Vec3d direction;
        public int age = 2;
    }
}

