/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.interfaces.IAnimatedDoor;
import com.hbm.interfaces.IDoor;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TEDoorAnimationPacket
implements IMessage {
    public int x;
    public int y;
    public int z;
    public byte state;
    public byte texture;

    public TEDoorAnimationPacket() {
    }

    public TEDoorAnimationPacket(BlockPos pos, byte state) {
        this(pos, state, -1);
    }

    public TEDoorAnimationPacket(BlockPos pos, byte state, byte tex) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.state = state;
        this.texture = tex;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.state = buf.readByte();
        if (buf.readableBytes() == 1) {
            this.texture = buf.readByte();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.state);
        if (this.texture != -1) {
            buf.writeByte((int)this.texture);
        }
    }

    public static class Handler
    implements IMessageHandler<TEDoorAnimationPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TEDoorAnimationPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                BlockPos pos = new BlockPos(m.x, m.y, m.z);
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
                if (te instanceof IAnimatedDoor) {
                    ((IAnimatedDoor)te).handleNewState(IDoor.DoorState.values()[m.state]);
                    ((IAnimatedDoor)te).setTextureState(m.texture);
                }
            });
            return null;
        }
    }
}

