/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.items.weapon.ItemGunBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetGunAnimPacket
implements IMessage {
    long time;
    int animIndex;
    EnumHand hand;
    float speedMultiplier = 1.0f;

    public SetGunAnimPacket() {
    }

    public SetGunAnimPacket(long time, int animIndex, EnumHand hand) {
        this.time = time;
        this.animIndex = animIndex;
        this.hand = hand;
    }

    public SetGunAnimPacket(long time, int animIndex, float speedMultiplier, EnumHand hand) {
        this.time = time;
        this.animIndex = animIndex;
        this.speedMultiplier = speedMultiplier;
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        this.time = buf.readLong();
        this.animIndex = buf.readInt();
        this.speedMultiplier = buf.readFloat();
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.time);
        buf.writeInt(this.animIndex);
        buf.writeFloat(this.speedMultiplier);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
    }

    public static class Handler
    implements IMessageHandler<SetGunAnimPacket, IMessage> {
        public IMessage onMessage(SetGunAnimPacket m, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = player.func_184586_b(m.hand);
            if (stack.func_77973_b() instanceof ItemGunBase) {
                NBTTagCompound anim = new NBTTagCompound();
                anim.func_74772_a("time", m.time);
                anim.func_74776_a("mult", m.speedMultiplier);
                anim.func_74768_a("id", m.animIndex);
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("animation", (NBTBase)anim);
            }
            return null;
        }
    }
}

