/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.particle.EnumHbmParticles;
import com.hbm.particle.ParticleManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnumParticlePacket
implements IMessage {
    EnumHbmParticles particle;
    double x;
    double y;
    double z;
    double strength;
    int count;

    public EnumParticlePacket() {
    }

    public EnumParticlePacket(EnumHbmParticles particle, double x, double y, double z, int count, double strength) {
        this.particle = particle;
        this.count = count;
        this.strength = strength;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public EnumParticlePacket(EnumHbmParticles particle, double x, double y, double z, int count) {
        this(particle, x, y, z, count, 0.0);
    }

    public void fromBytes(ByteBuf buf) {
        this.particle = EnumHbmParticles.values()[buf.readInt()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.strength = buf.readDouble();
        this.count = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particle.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.strength);
        buf.writeInt(this.count);
    }

    public static class Handler
    implements IMessageHandler<EnumParticlePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(EnumParticlePacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                switch (message.particle) {
                    case PARTICLES: {
                        ParticleManager.spawnParticles(message.x, message.y, message.z, message.count);
                        break;
                    }
                }
            });
            return null;
        }
    }
}

