/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.AnvilRecipes;
import com.hbm.inventory.container.ContainerAnvil;
import com.hbm.main.AdvancementManager;
import com.hbm.util.InventoryUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AnvilCraftPacket
implements IMessage {
    int recipeIndex;
    int mode;

    public AnvilCraftPacket() {
    }

    public AnvilCraftPacket(AnvilRecipes.AnvilConstructionRecipe recipe, int mode) {
        this.recipeIndex = AnvilRecipes.getConstruction().indexOf(recipe);
        this.mode = mode;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipeIndex = buf.readInt();
        this.mode = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recipeIndex);
        buf.writeInt(this.mode);
    }

    public static class Handler
    implements IMessageHandler<AnvilCraftPacket, IMessage> {
        public IMessage onMessage(AnvilCraftPacket m, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.field_71133_b.func_152344_a(() -> {
                if (m.recipeIndex < 0 || m.recipeIndex >= AnvilRecipes.getConstruction().size()) {
                    return;
                }
                EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
                if (!(p.field_71070_bA instanceof ContainerAnvil)) {
                    return;
                }
                ContainerAnvil anvil = (ContainerAnvil)p.field_71070_bA;
                AnvilRecipes.AnvilConstructionRecipe recipe = AnvilRecipes.getConstruction().get(m.recipeIndex);
                if (!recipe.isTierValid(anvil.tier)) {
                    return;
                }
                int count = m.mode == 1 ? 64 : 1;
                for (int i = 0; i < count && InventoryUtil.doesPlayerHaveAStacks((EntityPlayer)p, recipe.input, true); ++i) {
                    InventoryUtil.giveChanceStacksToPlayer((EntityPlayer)p, recipe.output);
                    if (recipe.output.get((int)0).stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.machine_difurnace_off)) {
                        AdvancementManager.grantAchievement((EntityPlayer)p, AdvancementManager.bobMetalworks);
                    }
                    if (recipe.output.get((int)0).stack.func_77973_b() != Item.func_150898_a((Block)ModBlocks.machine_assembler)) continue;
                    AdvancementManager.grantAchievement((EntityPlayer)p, AdvancementManager.bobAssembly);
                }
                p.field_71069_bz.func_75142_b();
            });
            return null;
        }
    }
}

