/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.modules;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.ArmorUtil;
import com.hbm.inventory.BreederRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class ItemHazardModule {
    public float radiation;
    public float digamma;
    public int fire;
    public int cryogenic;
    public int toxic;
    public boolean blinding;
    public int asbestos;
    public int coal;
    public boolean hydro;
    public float explosive;
    public boolean infohazard;
    public float tempMod = 1.0f;

    public void setMod(float tempMod) {
        this.tempMod = tempMod;
    }

    public boolean isRadioactive() {
        return this.radiation > 0.0f;
    }

    public void addRadiation(float radiation) {
        this.radiation = radiation;
    }

    public void addDigamma(float digamma) {
        this.digamma = digamma;
    }

    public void addFire(int fire) {
        this.fire = fire;
    }

    public void addCryogenic(int cryogenicLvl) {
        this.cryogenic = cryogenicLvl;
    }

    public void addToxic(int toxicLvl) {
        this.toxic = toxicLvl;
    }

    public void addCoal(int coal) {
        this.coal = coal;
    }

    public void addAsbestos(int asbestos) {
        this.asbestos = asbestos;
    }

    public void addBlinding() {
        this.blinding = true;
    }

    public void addHydroReactivity() {
        this.hydro = true;
    }

    public void addExplosive(float bang) {
        this.explosive = bang;
    }

    public void addInfohazard() {
        this.infohazard = true;
    }

    public void applyEffects(EntityLivingBase entity, float mod, int slot, boolean currentItem, EnumHand hand) {
        boolean reacher = false;
        if (entity instanceof EntityPlayer && !GeneralConfig.enable528) {
            reacher = Library.checkForHeld((EntityPlayer)entity, ModItems.reacher);
        }
        if (this.radiation * this.tempMod > 0.0f) {
            float rad = this.radiation * this.tempMod * mod / 20.0f;
            if (reacher) {
                rad = (float)Math.min(Math.sqrt(rad), (double)rad);
            }
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad);
        }
        if (this.digamma * this.tempMod > 0.0f) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.DIGAMMA, ContaminationUtil.ContaminationType.DIGAMMA, this.digamma * this.tempMod * mod / 20.0f);
        }
        if (this.cryogenic > 0 && !reacher && entity instanceof EntityLivingBase) {
            boolean isProtected;
            EntityLivingBase livingCEntity = entity;
            boolean bl = isProtected = entity instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityLivingBase)((EntityPlayer)entity));
            if (!isProtected) {
                livingCEntity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 110, this.cryogenic - 1));
                livingCEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 110, Math.min(4, this.cryogenic - 1)));
                livingCEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 110, this.cryogenic - 1));
                if (this.cryogenic > 4) {
                    livingCEntity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 110, this.cryogenic - 3));
                    entity.func_70066_B();
                }
            }
        }
        if (this.fire > 0 && !reacher && (!(entity instanceof EntityPlayer) || entity instanceof EntityPlayer && !ArmorUtil.checkForAsbestos((EntityLivingBase)((EntityPlayer)entity)))) {
            entity.func_70015_d(this.fire);
        }
        if (this.toxic > 0 && entity instanceof EntityLivingBase) {
            EntityLivingBase livingTEntity = entity;
            boolean hasToxFilter = false;
            boolean hasHazmat = false;
            if (entity instanceof EntityPlayer) {
                if (ArmorRegistry.hasProtection(livingTEntity, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.NERVE_AGENT)) {
                    ArmorUtil.damageGasMaskFilter(livingTEntity, 1);
                    hasToxFilter = true;
                }
                hasHazmat = ArmorUtil.checkForHazmat((EntityLivingBase)((EntityPlayer)entity));
            }
            if (!hasToxFilter && !hasHazmat) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 110, this.toxic - 1));
                if (this.toxic > 2) {
                    livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 110, Math.min(4, this.toxic - 4)));
                }
                if (this.toxic > 4) {
                    livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 110, this.toxic));
                }
                if (this.toxic > 6 && entity.field_70170_p.field_73012_v.nextInt(2000 / this.toxic) == 0) {
                    livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 110, this.toxic - 4));
                }
            }
            if (!hasHazmat || !hasToxFilter) {
                if (this.toxic > 8) {
                    livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 110, this.toxic - 8));
                }
                if (this.toxic > 16) {
                    livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 110, this.toxic - 16));
                }
            }
        }
        if (this.asbestos > 0 && GeneralConfig.enableAsbestos) {
            ContaminationUtil.applyAsbestos((Entity)entity, (int)((float)this.asbestos * mod), 1, (int)(1000.0f / ((float)this.asbestos * mod)));
        }
        if (this.coal > 0 && GeneralConfig.enableCoal) {
            ContaminationUtil.applyCoal((Entity)entity, (int)((float)this.coal * mod), 1, (int)(1000.0f / ((float)this.coal * mod)));
        }
        if (this.hydro && currentItem && !entity.field_70170_p.field_72995_K && entity.func_70090_H() && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack held = player.func_184586_b(hand);
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)held.func_77973_b().getContainerItem(held));
            player.field_71069_bz.func_75142_b();
            player.field_70170_p.func_72885_a(null, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - player.func_70033_W(), player.field_70161_v, 2.0f, true, true);
        }
        if (this.explosive > 0.0f && currentItem && !entity.field_70170_p.field_72995_K && entity.func_70027_ad() && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack held = player.func_184586_b(hand);
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)held.func_77973_b().getContainerItem(held));
            player.field_71069_bz.func_75142_b();
            player.field_70170_p.func_72885_a(null, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - player.func_70033_W(), player.field_70161_v, this.explosive, true, true);
        }
        if (this.blinding && !ArmorRegistry.hasProtection(entity, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.LIGHT)) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 110, 0));
        }
    }

    public static float getNewValue(float radiation) {
        if (radiation < 1000000.0f) {
            return radiation;
        }
        if (radiation < 1.0E9f) {
            return radiation * 1.0E-6f;
        }
        return radiation * 1.0E-9f;
    }

    public static String getSuffix(float radiation) {
        if (radiation < 1000000.0f) {
            return "";
        }
        if (radiation < 1.0E9f) {
            return I18nUtil.resolveKey("desc.mil", new Object[0]);
        }
        return I18nUtil.resolveKey("desc.bil", new Object[0]);
    }

    public void addInformation(ItemStack stack, List<String> list, ITooltipFlag flagIn) {
        int[] breeder;
        if (this.infohazard) {
            list.add(TextFormatting.DARK_GRAY + "[" + I18nUtil.resolveKey("trait.infohazard", new Object[0]) + "]");
        }
        if (this.radiation * this.tempMod > 0.0f) {
            list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("trait.radioactive", new Object[0]) + "]");
            float itemRad = this.radiation * this.tempMod;
            list.add(TextFormatting.YELLOW + Library.roundFloat(ItemHazardModule.getNewValue(itemRad), 3) + ItemHazardModule.getSuffix(itemRad) + " " + I18nUtil.resolveKey("desc.rads", new Object[0]));
            if (stack.func_190916_E() > 1) {
                float stackRad = this.radiation * this.tempMod * (float)stack.func_190916_E();
                list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("desc.stack", new Object[0]) + " " + Library.roundFloat(ItemHazardModule.getNewValue(stackRad), 3) + ItemHazardModule.getSuffix(stackRad) + " " + I18nUtil.resolveKey("desc.rads", new Object[0]));
            }
        }
        if (this.fire > 0) {
            list.add(TextFormatting.GOLD + "[" + I18nUtil.resolveKey("trait.hot", new Object[0]) + "]");
        }
        if (this.cryogenic > 0) {
            list.add(TextFormatting.AQUA + "[" + I18nUtil.resolveKey("trait.cryogenic", new Object[0]) + "]");
        }
        if (this.toxic > 0) {
            if (this.toxic > 16) {
                list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("adjective.extreme", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "]");
            } else if (this.toxic > 8) {
                list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("adjective.veryhigh", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "]");
            } else if (this.toxic > 4) {
                list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("adjective.high", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "]");
            } else if (this.toxic > 2) {
                list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("adjective.medium", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "]");
            } else {
                list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("adjective.little", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "]");
            }
        }
        if (this.blinding) {
            list.add(TextFormatting.DARK_AQUA + "[" + I18nUtil.resolveKey("trait.blinding", new Object[0]) + "]");
        }
        if (this.asbestos > 0 && GeneralConfig.enableAsbestos) {
            list.add(TextFormatting.WHITE + "[" + I18nUtil.resolveKey("trait.asbestos", new Object[0]) + "]");
        }
        if (this.coal > 0 && GeneralConfig.enableCoal) {
            list.add(TextFormatting.DARK_GRAY + "[" + I18nUtil.resolveKey("trait.coal", new Object[0]) + "]");
        }
        if (this.hydro) {
            list.add(TextFormatting.RED + "[" + I18nUtil.resolveKey("trait.hydro", new Object[0]) + "]");
        }
        if (this.explosive > 0.0f) {
            list.add(TextFormatting.RED + "[" + I18nUtil.resolveKey("trait.explosive", new Object[0]) + "]");
        }
        if (this.digamma * this.tempMod > 0.0f) {
            list.add(TextFormatting.RED + "[" + I18nUtil.resolveKey("trait.digamma", new Object[0]) + "]");
            list.add(TextFormatting.DARK_RED + "" + Library.roundFloat(this.digamma * this.tempMod * 1000.0f, 2) + " " + I18nUtil.resolveKey("desc.digammaed", new Object[0]));
            if (stack.func_190916_E() > 1) {
                list.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("desc.stack", new Object[0]) + " " + Library.roundFloat(this.digamma * this.tempMod * (float)stack.func_190916_E() * 1000.0f, 2) + " " + I18nUtil.resolveKey("desc.digammaed", new Object[0]));
            }
        }
        if ((breeder = BreederRecipes.getFuelValue(stack)) != null) {
            list.add(BreederRecipes.getHEATString("[" + I18nUtil.resolveKey("trait.heat", breeder[0]) + "]", breeder[0]));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.breeding", breeder[1]));
            list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("trait.furnace", breeder[0] * breeder[1] * 5));
        }
    }

    public boolean onEntityItemUpdate(EntityItem item) {
        if (!item.field_70170_p.field_72995_K) {
            if (this.hydro && (item.func_70090_H() || item.field_70170_p.func_175727_C(new BlockPos((int)item.field_70165_t, (int)item.field_70163_u, (int)item.field_70161_v)) || item.field_70170_p.func_180495_p(new BlockPos((int)item.field_70165_t, (int)item.field_70163_u, (int)item.field_70161_v)).func_185904_a() == Material.field_151586_h)) {
                item.func_70106_y();
                item.field_70170_p.func_72885_a((Entity)item, item.field_70165_t, item.field_70163_u, item.field_70161_v, 2.0f, true, true);
                return true;
            }
            if (this.explosive > 0.0f && item.func_70027_ad()) {
                item.func_70106_y();
                item.field_70170_p.func_72885_a((Entity)item, item.field_70165_t, item.field_70163_u, item.field_70161_v, this.explosive, true, true);
                return true;
            }
        }
        return false;
    }
}

