/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.blocks.ModBlocks;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemOilDetector
extends Item {
    public ItemOilDetector(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        ModItems.ALL_ITEMS.add(this);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".desc1"), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".desc2"), (Object[])new Object[0]));
    }

    public static boolean isOil(World world, BlockPos b) {
        return world.func_180495_p(b).func_177230_c() == ModBlocks.ore_oil;
    }

    public static boolean isBedrockOil(World world, BlockPos b) {
        return world.func_180495_p(b).func_177230_c() == ModBlocks.ore_bedrock_oil;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean bedrockoil = false;
        boolean oil = false;
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        boolean directoil = false;
        for (int ly = y + 15; ly > 0 && !(directoil |= ItemOilDetector.isOil(world, (BlockPos)mPos.func_181079_c(x, ly, z))); --ly) {
        }
        boolean directBedrock = ItemOilDetector.isBedrockOil(world, new BlockPos(x, 0, z));
        int range = 25;
        int samples = 50;
        int lx = 0;
        int lz = 0;
        for (int i = 0; i < samples && !oil && !bedrockoil; bedrockoil |= ItemOilDetector.isBedrockOil(world, (BlockPos)mPos.func_181079_c(x + lx, 0, z + lz)), ++i) {
            lx = (int)MathHelper.func_151237_a((double)(world.field_73012_v.nextGaussian() * (double)range / 2.0), (double)(-range), (double)range);
            lz = (int)MathHelper.func_151237_a((double)(world.field_73012_v.nextGaussian() * (double)range / 2.0), (double)(-range), (double)range);
            for (int ly = y + 15; ly > 0 && !(oil |= ItemOilDetector.isOil(world, (BlockPos)mPos.func_181079_c(x + lx, ly, z + lz))); --ly) {
            }
        }
        if (!world.field_72995_K) {
            if (directBedrock) {
                player.func_145747_a(new TextComponentTranslation(this.func_77658_a() + ".bullseyeBedrock", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
            } else if (directoil) {
                player.func_145747_a(new TextComponentTranslation(this.func_77658_a() + ".bullseye", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            } else if (bedrockoil) {
                player.func_145747_a(new TextComponentTranslation(this.func_77658_a() + ".detectedBedrock", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            } else if (oil) {
                player.func_145747_a(new TextComponentTranslation(this.func_77658_a() + ".detected", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            } else {
                player.func_145747_a(new TextComponentTranslation(this.func_77658_a() + ".noOil", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.techBleep, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.func_184609_a(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

