/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.forgefluid.HbmFluidHandlerGasCanister;
import com.hbm.forgefluid.SpecialContainerFillLists;
import com.hbm.interfaces.IHasCustomModel;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGasCanister
extends Item
implements IHasCustomModel {
    public static final ModelResourceLocation fluidCanisterModel = new ModelResourceLocation("hbm:gas_empty", "inventory");
    public int cap;

    public ItemGasCanister(String s, int cap) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77637_a(MainRegistry.controlTab);
        this.func_77625_d(1);
        this.func_77656_e(cap);
        this.cap = cap;
        ModItems.ALL_ITEMS.add(this);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemGasCanister.isFullOrEmpty(stack) ? 64 : 1;
    }

    public static boolean isFullOrEmpty(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() == ModItems.gas_canister) {
            FluidStack f = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"));
            if (f == null) {
                return true;
            }
            return f.amount == 4000 || f.amount == 0;
        }
        return stack.func_77973_b() == ModItems.gas_canister;
    }

    public static boolean isEmptyCanister(ItemStack out) {
        return out.func_77973_b() == ModItems.gas_canister && FluidUtil.getFluidContained((ItemStack)out) == null;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        if (f == null || f.getFluid() == null) {
            return I18n.func_135052_a((String)"item.gas_empty.name", (Object[])new Object[0]);
        }
        SpecialContainerFillLists.EnumGasCanister canister = SpecialContainerFillLists.EnumGasCanister.getEnumFromFluid(f.getFluid());
        if (canister == null) {
            return I18n.func_135052_a((String)"item.gas_null.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)canister.getTranslateKey(), (Object[])new Object[0]);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        tooltip.add((f == null ? "0" : Integer.valueOf(f.amount)) + "/" + this.cap + " mb");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (Fluid f : SpecialContainerFillLists.EnumGasCanister.getFluids()) {
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                stack.func_77982_d(new NBTTagCompound());
                if (f != null) {
                    stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, this.cap).writeToNBT(new NBTTagCompound()));
                }
                items.add((Object)stack);
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new HbmFluidHandlerGasCanister(stack, this.cap);
    }

    @Override
    public ModelResourceLocation getResourceLocation() {
        return fluidCanisterModel;
    }

    public static boolean isFullCanister(ItemStack stack, Fluid fluid) {
        return stack != null && stack.func_77973_b() instanceof ItemGasCanister && FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == fluid && FluidUtil.getFluidContained((ItemStack)stack).amount == ((ItemGasCanister)stack.func_77973_b()).cap;
    }

    public static ItemStack getFullCanister(Fluid f) {
        ItemStack stack = new ItemStack(ModItems.gas_canister, 1, 0);
        stack.func_77982_d(new NBTTagCompound());
        if (f != null && SpecialContainerFillLists.EnumGasCanister.contains(f)) {
            stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, 4000).writeToNBT(new NBTTagCompound()));
        }
        return stack;
    }
}

