/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.items.special.ItemHazard;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class WatzFuel
extends ItemHazard {
    public int lifeTime;
    public int power;
    public float powerMultiplier;
    public int heat;
    public float heatMultiplier;
    public float decayMultiplier;
    public float irad;
    public boolean iblind;

    public WatzFuel(float radiation, boolean blinding, int lifeTime, int power, float powerMultiplier, int heat, float heatMultiplier, float decayMultiplier, String s) {
        super(radiation, false, blinding, s);
        this.irad = radiation;
        this.iblind = blinding;
        this.lifeTime = lifeTime * 100;
        this.power = power / 10;
        this.powerMultiplier = powerMultiplier;
        this.heat = heat;
        this.heatMultiplier = heatMultiplier;
        this.decayMultiplier = decayMultiplier;
        this.func_77656_e(100);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn) {
        if (this.irad > 0.0f) {
            list.add("\u00a7a[Radioactive]\u00a7r");
            list.add("\u00a7e" + this.irad + " RAD/s\u00a7r");
        }
        if (this.iblind) {
            list.add("\u00a73[Blinding]\u00a7r");
        }
        list.add("Max age:          " + this.lifeTime / 100 + " ticks");
        list.add("Power per tick:  " + this.power + "HE");
        list.add("Power multiplier: " + (this.powerMultiplier >= 1.0f ? "+" : "") + ((double)Math.round(this.powerMultiplier * 1000.0f) * 0.1 - 100.0) + "%");
        list.add("Heat provided:   " + this.heat + " heat");
        list.add("Heat multiplier:   " + (this.heatMultiplier >= 1.0f ? "+" : "") + ((double)Math.round(this.heatMultiplier * 1000.0f) * 0.1 - 100.0) + "%");
        list.add("Decay multiplier: " + (this.decayMultiplier >= 1.0f ? "+" : "") + ((double)Math.round(this.decayMultiplier * 1000.0f) * 0.1 - 100.0) + "%");
    }

    public static void setLifeTime(ItemStack stack, int time) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("life", time);
    }

    public static void updateDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77964_b((int)((double)WatzFuel.getLifeTime(stack) / (double)((WatzFuel)stack.func_77973_b()).lifeTime * 100.0));
    }

    public static int getLifeTime(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return 0;
        }
        return stack.func_77978_p().func_74762_e("life");
    }
}

