/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.config.MachineConfig;
import com.hbm.items.ModItems;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemFusionShield
extends Item {
    public long field_77699_b;
    public int maxTemp;

    public ItemFusionShield(long maxDamage, int maxTemp, String s) {
        this.field_77699_b = (int)((double)maxDamage * MachineConfig.fusionBlanketMultiplier);
        this.maxTemp = maxTemp;
        this.func_77655_b(s);
        this.setRegistryName(s);
        ModItems.ALL_ITEMS.add(this);
    }

    public static long getShieldDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        return stack.func_77978_p().func_74763_f("damage");
    }

    public static void setShieldDamage(ItemStack stack, long damage) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74772_a("damage", damage);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        long damage = ItemFusionShield.getShieldDamage(stack);
        int percent = (int)((this.field_77699_b - damage) * 100L / this.field_77699_b);
        tooltip.add("Durability: " + (this.field_77699_b - damage) + "/" + this.field_77699_b + " (" + percent + "%)");
        tooltip.add("Maximum Plasma Heat: " + TextFormatting.RED + "" + this.maxTemp + "\u00b0C");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemFusionShield.getShieldDamage(stack) / (double)this.field_77699_b;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) != 0.0;
    }
}

