/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.gear;

import com.hbm.capability.HbmCapability;
import com.hbm.items.armor.JetpackBase;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.model.ModelJetPack;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JetpackBooster
extends JetpackBase {
    private ModelJetPack model;
    public static int maxFuel = 750;

    public JetpackBooster(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, Fluid fuel, int maxFuel, String s) {
        super(materialIn, renderIndexIn, equipmentSlotIn, fuel, maxFuel, s);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("High-powered vectorized jetpack.");
        tooltip.add("Highly increased fuel consumption.");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (armorSlot == EntityEquipmentSlot.CHEST) {
            if (this.model == null) {
                this.model = new ModelJetPack();
            }
            return this.model;
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "hbm:textures/armor/JetPack.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        HbmCapability.IHBMData props = HbmCapability.getData((Entity)player);
        if (!world.field_72995_K && JetpackBooster.getFuel(stack) > 0 && props.isJetpackActive()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "jetpack");
            data.func_74768_a("player", player.func_145782_y());
            data.func_74768_a("mode", 1);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, player.field_70165_t, player.field_70163_u, player.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
        }
        if (JetpackBooster.getFuel(stack) > 0 && props.isJetpackActive()) {
            if (player.field_70181_x < 0.6) {
                player.field_70181_x += 0.1;
            }
            Vec3d look = player.func_70040_Z();
            if (Vec3.createVectorHelper(player.field_70159_w, player.field_70181_x, player.field_70179_y).lengthVector() < 5.0) {
                player.field_70159_w += look.field_72450_a * 0.25;
                player.field_70181_x += look.field_72448_b * 0.25;
                player.field_70179_y += look.field_72449_c * 0.25;
                if (look.field_72448_b > 0.0) {
                    player.field_70143_R = 0.0f;
                }
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.flamethrowerShoot, SoundCategory.PLAYERS, 0.25f, 1.0f);
            this.useUpFuel(player, stack, 1);
        }
    }
}

