/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.material;

import com.hbm.inventory.material.Mats;
import java.util.ArrayList;
import java.util.List;

public class MaterialShapes {
    public static final List<MaterialShapes> allShapes = new ArrayList<MaterialShapes>();
    public static final MaterialShapes QUANTUM = new MaterialShapes(1, new String[0]);
    public static final MaterialShapes NUGGET = new MaterialShapes(8, "nugget");
    public static final MaterialShapes DUSTTINY = new MaterialShapes(MaterialShapes.NUGGET.quantity, "dustTiny");
    public static final MaterialShapes WIRE = new MaterialShapes(9, new String[0]);
    public static final MaterialShapes BILLET = new MaterialShapes(MaterialShapes.NUGGET.quantity * 6, "billet");
    public static final MaterialShapes INGOT = new MaterialShapes(MaterialShapes.NUGGET.quantity * 9, "ingot");
    public static final MaterialShapes GEM = new MaterialShapes(MaterialShapes.INGOT.quantity, "gem");
    public static final MaterialShapes CRYSTAL = new MaterialShapes(MaterialShapes.INGOT.quantity, "crystal");
    public static final MaterialShapes DUST = new MaterialShapes(MaterialShapes.INGOT.quantity, "dust");
    public static final MaterialShapes PLATE = new MaterialShapes(MaterialShapes.INGOT.quantity, "plate");
    public static final MaterialShapes QUART = new MaterialShapes(162, new String[0]);
    public static final MaterialShapes BLOCK = new MaterialShapes(MaterialShapes.INGOT.quantity * 9, "block");
    private int quantity;
    public final String[] prefixes;

    private MaterialShapes(int quantity, String ... prefixes) {
        this.quantity = quantity;
        this.prefixes = prefixes;
        for (String prefix : prefixes) {
            Mats.prefixByName.put(prefix, this);
        }
        allShapes.add(this);
    }

    public int q(int amount) {
        return this.quantity * amount;
    }

    public int q(int unitsUsed, int itemsProduced) {
        return this.quantity * unitsUsed / itemsProduced;
    }

    public String name() {
        return this.prefixes != null && this.prefixes.length > 0 ? this.prefixes[0] : "unknown";
    }
}

