/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.ItemDesignatorPacket;
import com.hbm.packet.PacketDispatcher;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIScreenDesignator
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_designator.png");
    protected int xSize = 176;
    protected int ySize = 126;
    protected int guiLeft;
    protected int guiTop;
    protected short hereButtonCoolDown = 0;
    protected short saveButtonCoolDown = 0;
    private final EntityPlayer player;
    private GuiTextField xField;
    private GuiTextField zField;

    public GUIScreenDesignator(EntityPlayer player) {
        this.player = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.func_179145_e();
        GlStateManager.func_179140_f();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.func_179145_e();
        if (this.isOnXButton(mouseX, mouseY)) {
            this.func_146279_a("Click to Flip X to -X", mouseX, mouseY);
        }
        if (this.isOnZButton(mouseX, mouseY)) {
            this.func_146279_a("Click to Flip Z to -Z", mouseX, mouseY);
        }
        if (this.isOnHereButton(mouseX, mouseY)) {
            this.func_146279_a("Set coordinates to player position", mouseX, mouseY);
        }
        if (this.isOnSaveButton(mouseX, mouseY)) {
            this.func_146279_a("Save coordinates", mouseX, mouseY);
        }
        if (this.isOnDistanceField(mouseX, mouseY)) {
            this.func_146279_a("Distance from player to coordinates", mouseX, mouseY);
        }
    }

    protected void loadSavedCoords() {
        ItemStack stack = this.player.func_184586_b(EnumHand.MAIN_HAND);
        if (!(stack != null && stack.func_77973_b() == ModItems.designator_manual || (stack = this.player.func_184586_b(EnumHand.OFF_HAND)) != null && stack.func_77973_b() == ModItems.designator_manual)) {
            return;
        }
        if (stack.func_77942_o()) {
            this.xField.func_146180_a(Integer.toString(stack.func_77978_p().func_74762_e("xCoord")));
            this.zField.func_146180_a(Integer.toString(stack.func_77978_p().func_74762_e("zCoord")));
        } else {
            this.xField.func_146180_a("0");
            this.zField.func_146180_a("0");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.xField = new GuiTextField(0, this.field_146289_q, this.guiLeft + 38, this.guiTop + 38, 115, 10);
        this.xField.func_146193_g(13378741);
        this.xField.func_146204_h(10034056);
        this.xField.func_146185_a(false);
        this.xField.func_146203_f(10);
        this.zField = new GuiTextField(1, this.field_146289_q, this.guiLeft + 38, this.guiTop + 60, 115, 10);
        this.zField.func_146193_g(13378741);
        this.zField.func_146204_h(10034056);
        this.zField.func_146185_a(false);
        this.zField.func_146203_f(10);
        this.loadSavedCoords();
    }

    protected boolean isOnHereButton(int i, int j) {
        return this.guiLeft + 112 < i && this.guiLeft + 112 + 18 > i && this.guiTop + 87 < j && this.guiTop + 87 + 18 > j;
    }

    protected boolean isOnSaveButton(int i, int j) {
        return this.guiLeft + 139 < i && this.guiLeft + 139 + 18 > i && this.guiTop + 87 < j && this.guiTop + 87 + 18 > j;
    }

    protected boolean isOnXButton(int i, int j) {
        return this.guiLeft + 14 < i && this.guiLeft + 14 + 18 > i && this.guiTop + 33 < j && this.guiTop + 33 + 18 > j;
    }

    protected boolean isOnZButton(int i, int j) {
        return this.guiLeft + 14 < i && this.guiLeft + 14 + 18 > i && this.guiTop + 55 < j && this.guiTop + 55 + 18 > j;
    }

    protected boolean isOnDistanceField(int i, int j) {
        return this.guiLeft + 34 < i && this.guiLeft + 34 + 67 > i && this.guiTop + 89 < j && this.guiTop + 89 + 14 > j;
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        this.xField.func_146192_a(i, j, k);
        this.zField.func_146192_a(i, j, k);
        if (this.player != null) {
            if (this.isOnXButton(i, j)) {
                this.xField.func_146180_a(Integer.toString(-1 * NumberUtils.toInt((String)this.xField.func_146179_b())));
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)HBMSoundHandler.buttonYes, (float)1.0f));
            }
            if (this.isOnZButton(i, j)) {
                this.zField.func_146180_a(Integer.toString(-1 * NumberUtils.toInt((String)this.zField.func_146179_b())));
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)HBMSoundHandler.buttonYes, (float)1.0f));
            }
            if (this.isOnHereButton(i, j)) {
                this.hereButtonCoolDown = (short)20;
                this.xField.func_146180_a(Integer.toString((int)this.player.field_70165_t));
                this.zField.func_146180_a(Integer.toString((int)this.player.field_70161_v));
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)HBMSoundHandler.buttonYes, (float)1.0f));
            }
            if (this.isOnSaveButton(i, j) && this.saveButtonCoolDown == 0) {
                this.saveButtonCoolDown = (short)20;
                this.formatInput();
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)HBMSoundHandler.techBleep, (float)1.0f));
                PacketDispatcher.wrapper.sendToServer((IMessage)new ItemDesignatorPacket(Integer.parseInt(this.xField.func_146179_b()), Integer.parseInt(this.zField.func_146179_b())));
            }
        }
    }

    protected void formatInput() {
        this.xField.func_146180_a(Integer.toString(NumberUtils.toInt((String)this.xField.func_146179_b())));
        this.zField.func_146180_a(Integer.toString(NumberUtils.toInt((String)this.zField.func_146179_b())));
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        String name = "Manual Designator";
        this.field_146289_q.func_78276_b(name, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(name) / 2, this.guiTop + 12, 0xCCCCCC);
        this.formatInput();
        this.xField.func_146194_f();
        this.zField.func_146194_f();
        int posx = NumberUtils.toInt((String)this.xField.func_146179_b());
        int posz = NumberUtils.toInt((String)this.zField.func_146179_b());
        String distance = Math.min((int)Math.sqrt(Math.pow((double)posx - this.player.field_70165_t, 2.0) + Math.pow((double)posz - this.player.field_70161_v, 2.0)), 99999999) + " m";
        this.field_146289_q.func_78276_b(distance, this.guiLeft + 97 - this.field_146289_q.func_78256_a(distance), this.guiTop + 93, 37375);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.xField.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 32, this.guiTop + 33, 0, 126, 125, 18);
        }
        if (this.zField.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 32, this.guiTop + 55, 0, 126, 125, 18);
        }
        if (this.hereButtonCoolDown > 0) {
            this.func_73729_b(this.guiLeft + 112, this.guiTop + 87, 176, 0, 18, 18);
            this.hereButtonCoolDown = (short)(this.hereButtonCoolDown - 1);
        }
        if (this.saveButtonCoolDown > 0) {
            this.func_73729_b(this.guiLeft + 139, this.guiTop + 87, 194, 0, 18, 18);
            this.saveButtonCoolDown = (short)(this.saveButtonCoolDown - 1);
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) throws IOException {
        if (!this.xField.func_146201_a(p_73869_1_, p_73869_2_) && !this.zField.func_146201_a(p_73869_1_, p_73869_2_)) {
            super.func_73869_a(p_73869_1_, p_73869_2_);
        }
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

