/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.main.AdvancementManager;
import com.hbm.packet.ItemBobmazonPacket;
import com.hbm.packet.PacketDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class GUIScreenBobmazon
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_bobmazon.png");
    protected int xSize = 176;
    protected int ySize = 229;
    protected int guiLeft;
    protected int guiTop;
    int currentPage = 0;
    List<Offer> offers = new ArrayList<Offer>();
    List<FolderButton> buttons = new ArrayList<FolderButton>();
    private final EntityPlayer player;

    public GUIScreenBobmazon(EntityPlayer player, List<Offer> offers) {
        this.player = player;
        this.offers = offers;
    }

    int getPageCount() {
        return (int)Math.ceil((this.offers.size() - 1) / 3);
    }

    public void func_73876_c() {
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        if (this.currentPage > this.getPageCount()) {
            this.currentPage = this.getPageCount();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.func_179140_f();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.func_179145_e();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.updateButtons();
    }

    protected void updateButtons() {
        if (!this.buttons.isEmpty()) {
            this.buttons.clear();
        }
        for (int i = this.currentPage * 3; i < Math.min(this.currentPage * 3 + 3, this.offers.size()); ++i) {
            this.buttons.add(new FolderButton(this.guiLeft + 34, this.guiTop + 35 + 54 * (int)Math.floor(i) - this.currentPage * 3 * 54, this.offers.get(i)));
        }
        if (this.currentPage != 0) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 - 18, this.guiTop + 26 + 81, 1, "Previous"));
        }
        if (this.currentPage != this.getPageCount()) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 + 108 + 18, this.guiTop + 26 + 81, 2, "Next"));
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        try {
            for (FolderButton b : this.buttons) {
                if (!b.isMouseOnButton(i, j)) continue;
                b.executeAction();
            }
        }
        catch (Exception ex) {
            this.updateButtons();
        }
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(this.currentPage + 1 + "/" + (this.getPageCount() + 1)), (Object[])new Object[0]), this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)(this.currentPage + 1 + "/" + (this.getPageCount() + 1)), (Object[])new Object[0])) / 2, this.guiTop + 205, 0x404040);
        for (FolderButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.drawString(i, j);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (FolderButton b : this.buttons) {
            b.drawButton(b.isMouseOnButton(i, j));
        }
        for (FolderButton b : this.buttons) {
            b.drawIcon(b.isMouseOnButton(i, j));
        }
        for (int d = this.currentPage * 3; d < Math.min(this.currentPage * 3 + 3, this.offers.size()); ++d) {
            this.offers.get(d).drawRequirement(this, this.guiLeft + 34, this.guiTop + 53 + 54 * (int)Math.floor(d) - this.currentPage * 3 * 54);
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public static enum Requirement {
        STEEL(AdvancementManager.bobMetalworks, "bobmetalworks"),
        ASSEMBLY(AdvancementManager.bobAssembly, "bobassembly"),
        CHEMICS(AdvancementManager.bobChemistry, "bobchemistry"),
        OIL(AdvancementManager.bobOil, "boboil"),
        NUCLEAR(AdvancementManager.bobNuclear, "bobnuclear"),
        HIDDEN(AdvancementManager.bobHidden, "bobhidden");

        private Advancement achievement;
        private String advName;

        private Requirement(Advancement achievement, String advName) {
            this.setAchievement(achievement);
            this.advName = advName;
        }

        public boolean fullfills(EntityPlayerMP player) {
            return player.func_192039_O().func_192747_a(this.getAchievement()).func_192105_a();
        }

        public Advancement getAchievement() {
            if (FMLCommonHandler.instance().getSide().isServer()) {
                return this.achievement;
            }
            return this.getAchClient();
        }

        @SideOnly(value=Side.CLIENT)
        private Advancement getAchClient() {
            return Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(new ResourceLocation("hbm", this.advName));
        }

        public void setAchievement(Advancement achievement) {
            this.achievement = achievement;
        }
    }

    public static class Offer {
        public ItemStack offer;
        public Requirement requirement;
        public int cost;
        public int rating;
        public String comment;
        public String author;

        public Offer(ItemStack offer, Requirement requirement, int cost, int rating, String comment, String author) {
            this.offer = offer;
            this.requirement = requirement;
            this.cost = cost;
            this.rating = rating * 4 - 1;
            this.comment = comment;
            this.author = author;
        }

        public Offer(ItemStack offer, Requirement requirement, int cost) {
            this.offer = offer;
            this.requirement = requirement;
            this.cost = cost;
            this.rating = 0;
            this.comment = "No Ratings";
            this.author = "";
        }

        public void drawRequirement(GUIScreenBobmazon gui, int x, int y) {
            try {
                RenderHelper.func_74520_c();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                gui.func_73729_b(x + 19, y - 4, 176, 62, 39, 8);
                gui.func_73729_b(x + 19, y - 4, 176, 54, this.rating, 8);
                String count = "";
                if (!this.offer.func_190926_b()) {
                    count = " x" + this.offer.func_190916_E();
                }
                GL11.glPushMatrix();
                float scale = 0.65f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                gui.field_146289_q.func_78276_b(I18n.func_135052_a((String)this.offer.func_82833_r(), (Object[])new Object[0]) + count, (int)((float)(x + 20) / scale), (int)((float)(y - 12) / scale), 0x404040);
                GL11.glPopMatrix();
                String price = this.cost + " Cap";
                if (this.cost != 1) {
                    price = price + "s";
                }
                gui.field_146289_q.func_78276_b(price, x + 62, y - 3, 0x404040);
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (!this.author.isEmpty()) {
                    gui.field_146289_q.func_78276_b("- " + this.author, (x + 20) * 2, (y + 18) * 2, 0x222222);
                }
                gui.field_146289_q.func_78276_b(this.comment, (x + 20) * 2, (y + 8) * 2, 0x222222);
                GL11.glPopMatrix();
                GlStateManager.func_179140_f();
                if (this.offer != null) {
                    gui.field_146296_j.func_184391_a(null, this.requirement.getAchievement().func_192068_c().func_192298_b(), x + 1, y + 1);
                }
                GlStateManager.func_179145_e();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class FolderButton {
        int xPos;
        int yPos;
        int type;
        String info;
        Offer offer;

        public FolderButton(int x, int y, int t, String i) {
            this.xPos = x;
            this.yPos = y;
            this.type = t;
            this.info = i;
        }

        public FolderButton(int x, int y, Offer offer) {
            this.xPos = x;
            this.yPos = y;
            this.type = 0;
            this.offer = offer;
        }

        public void updateButton(int mouseX, int mouseY) {
        }

        public boolean isMouseOnButton(int mouseX, int mouseY) {
            return this.xPos <= mouseX && this.xPos + 18 > mouseX && this.yPos < mouseY && this.yPos + 18 >= mouseY;
        }

        public void drawButton(boolean b) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            GUIScreenBobmazon.this.func_73729_b(this.xPos, this.yPos, b ? 194 : 176, this.type == 1 ? 18 : (this.type == 2 ? 36 : 0), 18, 18);
        }

        public void drawIcon(boolean b) {
            try {
                RenderHelper.func_74520_c();
                if (this.offer != null) {
                    GUIScreenBobmazon.this.field_146296_j.func_184391_a((EntityLivingBase)GUIScreenBobmazon.this.player, this.offer.offer, this.xPos + 1, this.yPos + 1);
                }
                RenderHelper.func_74518_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void drawString(int x, int y) {
            if (this.info == null || this.info.isEmpty()) {
                return;
            }
            GUIScreenBobmazon.this.func_146283_a(Arrays.asList(this.info), x, y);
        }

        public void executeAction() {
            GUIScreenBobmazon.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.type == 0) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new ItemBobmazonPacket(GUIScreenBobmazon.this.player, this.offer));
            } else if (this.type == 1) {
                if (GUIScreenBobmazon.this.currentPage > 0) {
                    --GUIScreenBobmazon.this.currentPage;
                }
                GUIScreenBobmazon.this.updateButtons();
            } else if (this.type == 2) {
                if (GUIScreenBobmazon.this.currentPage < GUIScreenBobmazon.this.getPageCount()) {
                    ++GUIScreenBobmazon.this.currentPage;
                }
                GUIScreenBobmazon.this.updateButtons();
            }
        }
    }
}

