/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.container.ContainerMachineBattery;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.lib.Library;
import com.hbm.packet.AuxButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityMachineBattery;
import com.hbm.util.I18nUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GUIMachineBattery
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/storage/gui_battery.png");
    private TileEntityMachineBattery battery;
    private IEnergyUser.ConnectionPriority lastPrio = IEnergyUser.ConnectionPriority.LOW;

    public GUIMachineBattery(InventoryPlayer invPlayer, TileEntityMachineBattery tedf) {
        super(new ContainerMachineBattery(invPlayer, tedf));
        this.battery = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String[] desc;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String deltaText = Library.getShortNumber(Math.abs(this.battery.powerDelta)) + "HE/s";
        deltaText = this.battery.powerDelta > 0L ? TextFormatting.GREEN + "+" + deltaText : (this.battery.powerDelta < 0L ? TextFormatting.RED + "-" + deltaText : TextFormatting.YELLOW + "0HE/s");
        String[] info = new String[]{Library.getShortNumber(this.battery.power) + "HE/" + Library.getShortNumber(this.battery.getMaxPower()) + "HE", deltaText};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 71, this.field_147009_r + 69 - 52, 34, 52, mouseX, mouseY, info);
        String lang = null;
        switch (this.battery.priority) {
            case LOW: {
                lang = "low";
                break;
            }
            case NORMAL: {
                lang = "normal";
                break;
            }
            case HIGH: {
                lang = "high";
            }
        }
        ArrayList<String> priority = new ArrayList<String>();
        priority.add(I18nUtil.resolveKey("battery.priority." + lang, new Object[0]));
        priority.add(I18nUtil.resolveKey("battery.priority.recommended", new Object[0]));
        for (String s : desc = I18nUtil.resolveKeyArray("battery.priority." + lang + ".desc", new Object[0])) {
            priority.add(s);
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 151, this.field_147009_r + 16, 16, 16, mouseX, mouseY, priority.toArray(new String[priority.size()]));
        String[] text = I18nUtil.resolveKeyArray("desc.guimachbattery", new Object[0]);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 16, text);
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        if (this.field_147003_i + 6 <= x && this.field_147003_i + 6 + 18 > x && this.field_147009_r + 33 < y && this.field_147009_r + 33 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.battery.func_174877_v(), 0, 0));
        }
        if (this.field_147003_i + 150 <= x && this.field_147003_i + 150 + 18 > x && this.field_147009_r + 33 < y && this.field_147009_r + 33 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.battery.func_174877_v(), 0, 1));
        }
        if (this.field_147003_i + 151 <= x && this.field_147003_i + 151 + 16 > x && this.field_147009_r + 16 < y && this.field_147009_r + 17 + 16 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.battery.func_174877_v(), 0, 2));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = this.battery.hasCustomInventoryName() ? this.battery.getInventoryName() : I18n.func_135052_a((String)this.battery.getInventoryName(), (Object[])new Object[0]);
        name = name + " (" + Library.getShortNumber(this.battery.power) + " HE)";
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        super.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.battery.power > 0L) {
            i = (int)this.battery.getPowerRemainingScaled(52L);
            this.func_73729_b(this.field_147003_i + 71, this.field_147009_r + 69 - i, 176, 52 - i, 34, i);
        }
        i = this.battery.redLow;
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 34, 176, 52 + i * 18, 18, 18);
        short j = this.battery.redHigh;
        this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 34, 176, 52 + j * 18, 18, 18);
        this.func_73729_b(this.field_147003_i + 152, this.field_147009_r + 17, 194, 52 + this.battery.priority.ordinal() * 16, 16, 16);
        this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36, 16, 16, 2);
    }
}

