/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerCraneRouter;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.modules.ModulePatternMatcher;
import com.hbm.packet.NBTControlPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.network.TileEntityCraneRouter;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUICraneRouter
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/storage/gui_crane_router.png");
    private TileEntityCraneRouter router;

    public GUICraneRouter(InventoryPlayer invPlayer, TileEntityCraneRouter tedf) {
        super(new ContainerCraneRouter(invPlayer, tedf));
        this.router = tedf;
        this.field_146999_f = 256;
        this.field_147000_g = 201;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 3; ++k) {
                int buttonX = this.field_147003_i + 7 + j * 222;
                int buttonY = this.field_147009_r + 16 + k * 26;
                if (buttonX > mouseX || mouseX >= buttonX + 18 || buttonY >= mouseY || mouseY > buttonY + 18) continue;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                NBTTagCompound data = new NBTTagCompound();
                data.func_74768_a("toggle", j * 3 + k);
                PacketDispatcher.wrapper.sendToServer((IMessage)new NBTControlPacket(data, this.router.func_174877_v()));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 3; ++k) {
                int buttonX = this.field_147003_i + 7 + j * 222;
                int buttonY = this.field_147009_r + 15 + k * 26;
                if (buttonX > mouseX || mouseX >= buttonX + 18 || buttonY >= mouseY || mouseY > buttonY + 18) continue;
                String[] text = new String[2];
                int index = j * 3 + k;
                switch (this.router.modes[index]) {
                    case 0: {
                        text = new String[]{"OFF"};
                        break;
                    }
                    case 1: {
                        text[0] = "WHITELIST";
                        text[1] = "Route if filter matches";
                        break;
                    }
                    case 2: {
                        text[0] = "BLACKLIST";
                        text[1] = "Route if filter doesn't match";
                        break;
                    }
                    case 3: {
                        text[0] = "WILDCARD";
                        text[1] = "Route if no other route is valid";
                    }
                }
                this.func_146283_a(Arrays.asList(text), mouseX, mouseY);
            }
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            for (int i = 0; i < 30; ++i) {
                Slot slot = this.field_147002_h.func_75139_a(i);
                ModulePatternMatcher matcher = this.router.patterns[i / 5];
                int index = i % 5;
                if (!this.func_146981_a(slot, mouseX, mouseY) || matcher.modes[index] == null) continue;
                String label = TextFormatting.YELLOW + "";
                switch (matcher.modes[index]) {
                    case "exact": {
                        label = label + "Item and meta match";
                        break;
                    }
                    case "wildcard": {
                        label = label + "Item matches";
                        break;
                    }
                    default: {
                        label = label + "Ore dict key matches: " + matcher.modes[index];
                    }
                }
                this.func_146283_a(Arrays.asList(TextFormatting.RED + "Right click to change", label), mouseX, mouseY - 30);
            }
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int i, int j) {
        String name = this.router.hasCustomInventoryName() ? this.router.getInventoryName() : I18n.func_135052_a((String)this.router.getInventoryName(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 47, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, 93);
        this.func_73729_b(this.field_147003_i + 39, this.field_147009_r + 101, 39, 101, 176, 100);
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 3; ++k) {
                int index = j * 3 + k;
                int mode = this.router.modes[index];
                this.func_73729_b(this.field_147003_i + 7 + j * 222, this.field_147009_r + 16 + k * 26, 238, 93 + mode * 18, 18, 18);
            }
        }
        if (Keyboard.isKeyDown((int)56)) {
            for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
                Slot s = this.field_147002_h.func_75139_a(i);
                this.field_146289_q.func_175063_a(i + "", (float)(this.field_147003_i + s.field_75223_e + 2), (float)(this.field_147009_r + s.field_75221_f), 0xFFFFFF);
                this.field_146289_q.func_175063_a(s.getSlotIndex() + "", (float)(this.field_147003_i + s.field_75223_e + 2), (float)(this.field_147009_r + s.field_75221_f + 8), 0xFF8080);
            }
        }
    }
}

