/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.Node;
import net.minecraft.nbt.NBTTagCompound;

public class NodeBoolean
extends Node {
    public BoolOperation op = BoolOperation.AND;

    public NodeBoolean(float x, float y) {
        super(x, y);
        this.outputs.add(new NodeConnection("Output", this, this.outputs.size(), false, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        NodeDropdown opSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            BoolOperation op = BoolOperation.getByName(s);
            if (op != null) {
                this.setOperation(op);
            }
            return null;
        }, () -> this.op.name());
        for (BoolOperation op : BoolOperation.values()) {
            opSelector.list.addItems(op.name());
        }
        this.otherElements.add(opSelector);
        this.setOperation(BoolOperation.AND);
        this.evalCache = new DataValue[1];
    }

    @Override
    public NodeType getType() {
        return NodeType.BOOLEAN;
    }

    @Override
    public String getDisplayName() {
        return this.op.name();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "boolean");
        tag.func_74768_a("op", this.op.ordinal());
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.op = BoolOperation.values()[tag.func_74762_e("op") % BoolOperation.values().length];
        super.readFromNBT(tag, sys);
    }

    @Override
    public DataValue evaluate(int idx) {
        if (this.cacheValid) {
            return this.evalCache[0];
        }
        this.cacheValid = true;
        DataValue[] evals = new DataValue[this.inputs.size()];
        for (int i = 0; i < evals.length; ++i) {
            evals[i] = ((NodeConnection)this.inputs.get(i)).evaluate();
            if (evals[i] != null) continue;
            return null;
        }
        switch (this.op) {
            case AND: {
                this.evalCache[0] = new DataValueFloat(evals[0].getBoolean() && evals[1].getBoolean());
                return this.evalCache[0];
            }
            case OR: {
                this.evalCache[0] = new DataValueFloat(evals[0].getBoolean() || evals[1].getBoolean());
                return this.evalCache[0];
            }
            case NOT: {
                this.evalCache[0] = new DataValueFloat(!evals[0].getBoolean());
                return this.evalCache[0];
            }
            case XOR: {
                this.evalCache[0] = new DataValueFloat(evals[0].getBoolean() ^ evals[1].getBoolean());
                return this.evalCache[0];
            }
            case NAND: {
                this.evalCache[0] = new DataValueFloat(!evals[0].getBoolean() || !evals[1].getBoolean());
                return this.evalCache[0];
            }
            case NOR: {
                this.evalCache[0] = new DataValueFloat(!evals[0].getBoolean() && !evals[1].getBoolean());
                return this.evalCache[0];
            }
            case XNOR: {
                this.evalCache[0] = new DataValueFloat(evals[0].getBoolean() == evals[1].getBoolean());
                return this.evalCache[0];
            }
        }
        this.evalCache[0] = null;
        return null;
    }

    public void setOperation(BoolOperation op) {
        this.op = op;
        for (NodeConnection c : this.inputs) {
            c.removeConnection();
        }
        this.inputs.clear();
        String s1 = "Input 1";
        String s2 = "Input 2";
        if (op == BoolOperation.NOT) {
            this.inputs.add(new NodeConnection("Input", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        } else {
            this.inputs.add(new NodeConnection(s1, this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
            this.inputs.add(new NodeConnection(s2, this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        }
        this.recalcSize();
    }

    public NodeBoolean setData(BoolOperation op) {
        this.setOperation(op);
        return this;
    }

    public static enum BoolOperation {
        AND,
        OR,
        NOT,
        XOR,
        NAND,
        NOR,
        XNOR;


        public static BoolOperation getByName(String name) {
            for (BoolOperation o : BoolOperation.values()) {
                if (!o.name().equals(name)) continue;
                return o;
            }
            return null;
        }
    }
}

