/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class Label
extends Control {
    private float[] color = new float[]{1.0f, 1.0f, 1.0f};
    private String text = "label";
    private int scale = 25;
    float width = 0.0f;
    float height = 0.0f;

    public Label(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("isLit", new DataValueFloat(0.0f));
        this.configMap.put("colorR", new DataValueFloat(this.color[0]));
        this.configMap.put("colorG", new DataValueFloat(this.color[1]));
        this.configMap.put("colorB", new DataValueFloat(this.color[2]));
        this.configMap.put("text", new DataValueString(this.text));
        this.configMap.put("scale", new DataValueFloat(this.scale));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.LABEL;
    }

    @Override
    public float[] getSize() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public float[] getBox() {
        return new float[]{this.posX, this.posY, this.posX + this.width * (float)this.scale / 500.0f, this.posY + this.height * (float)this.scale / 500.0f};
    }

    @Override
    public void applyConfigs(Map<String, DataValue> configs) {
        super.applyConfigs(configs);
        for (Map.Entry e : this.configMap.entrySet()) {
            switch ((String)e.getKey()) {
                case "colorR": {
                    this.color[0] = ((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "colorG": {
                    this.color[1] = ((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "colorB": {
                    this.color[2] = ((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "text": {
                    this.text = ((DataValue)e.getValue()).toString();
                    break;
                }
                case "scale": {
                    this.scale = (int)((DataValue)e.getValue()).getNumber();
                }
            }
        }
    }

    @Override
    public void render() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float lX = OpenGlHelper.lastBrightnessX;
        float lY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)0.0f, (float)this.posY);
        GlStateManager.func_179132_a((boolean)false);
        boolean isLit = this.getVar("isLit").getBoolean();
        this.width = font.func_78256_a(this.text);
        this.height = font.field_78288_b;
        float s = (float)this.scale / 500.0f;
        GL11.glScalef((float)s, (float)(-s), (float)s);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.1f);
        int r = (int)(this.color[0] * 255.0f);
        int g = (int)(this.color[1] * 255.0f);
        int b = (int)(this.color[2] * 255.0f);
        int rgb = r << 16 | g << 8 | b;
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        GlStateManager.func_179140_f();
        font.func_175065_a(this.text, 0.0f, 0.0f, rgb, false);
        GlStateManager.func_179145_e();
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lX, (float)lY);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    @Override
    public IModelCustom getModel() {
        return ResourceManager.ctrl_display_seven_seg;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_display_seven_seg_gui_tex;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new Label(this.name, panel);
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
    }
}

