/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueEnum;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class DisplayText
extends Control {
    private int scale = 25;
    private float width = 20.0f;
    private float textWidth = 0.0f;
    private float height = 0.0f;

    public DisplayText(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("isLit", new DataValueFloat(0.0f));
        this.vars.put("text", new DataValueString("text"));
        this.vars.put("color", new DataValueEnum(EnumDyeColor.WHITE));
        this.configMap.put("scale", new DataValueFloat(this.scale));
        this.configMap.put("width", new DataValueFloat(this.width));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.DISPLAY;
    }

    @Override
    public float[] getSize() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public float[] getBox() {
        float d = 0.1f;
        return new float[]{this.posX - d, this.posY - d, this.posX + this.width * 1.5f * (float)this.scale / 500.0f + d, this.posY + this.height * (float)this.scale / 500.0f + d};
    }

    @Override
    public void applyConfigs(Map<String, DataValue> configs) {
        super.applyConfigs(configs);
        for (Map.Entry e : this.configMap.entrySet()) {
            switch ((String)e.getKey()) {
                case "scale": {
                    this.scale = (int)((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "width": {
                    this.width = (int)((DataValue)e.getValue()).getNumber();
                }
            }
        }
    }

    @Override
    public void render() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String text = this.getVar("text").toString();
        boolean isLit = this.getVar("isLit").getBoolean();
        EnumDyeColor dyeColor = this.getVar("color").getEnum(EnumDyeColor.class);
        int color = dyeColor.func_193350_e();
        this.textWidth = font.func_78256_a(text);
        this.height = font.field_78288_b;
        float s = (float)this.scale / 500.0f;
        float lX = OpenGlHelper.lastBrightnessX;
        float lY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)0.0f, (float)this.posY);
        GL11.glTranslated((double)0.0, (double)0.03f, (double)0.0);
        GL11.glScalef((float)s, (float)(-s), (float)s);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        GlStateManager.func_179140_f();
        font.func_175065_a(text, 0.0f, 0.0f, color, false);
        GlStateManager.func_179145_e();
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lX, (float)lY);
        }
        GlStateManager.func_179121_F();
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.01f);
        GlStateManager.func_179090_x();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float[] box = this.getBox();
        float[] rgb = new float[]{0.0f, 0.0f, 0.0f};
        float d = 0.0f;
        buf.func_181662_b((double)(box[0] - d), (double)(box[1] - d), -0.01).func_187315_a(0.0, 0.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buf.func_181662_b((double)(box[0] - d), (double)box[3], -0.01).func_187315_a(0.0, 1.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buf.func_181662_b((double)(box[2] + d), (double)box[3], -0.01).func_187315_a(1.0, 1.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buf.func_181662_b((double)(box[2] + d), (double)(box[1] - d), -0.01).func_187315_a(1.0, 0.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        rgb = new float[]{0.3f, 0.3f, 0.3f};
        d = 0.05f;
        buf.func_181662_b((double)(box[0] - d), (double)(box[1] - d), 0.0).func_187315_a(0.0, 0.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buf.func_181662_b((double)(box[0] - d), (double)(box[3] + d), 0.0).func_187315_a(0.0, 1.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buf.func_181662_b((double)(box[2] + d), (double)(box[3] + d), 0.0).func_187315_a(1.0, 1.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        buf.func_181662_b((double)(box[2] + d), (double)(box[1] - d), 0.0).func_187315_a(1.0, 0.0).func_181666_a(rgb[0], rgb[1], rgb[2], 1.0f).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
    }

    @Override
    public IModelCustom getModel() {
        return ResourceManager.ctrl_display_seven_seg;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_display_seven_seg_gui_tex;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new DisplayText(this.name, panel);
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
    }
}

