/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.BedrockOreRegistry;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.lib.Library;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrystallizerRecipes {
    private static LinkedHashMap<Object, ItemStack> itemOutputRecipes = new LinkedHashMap();
    private static HashMap<Object, FluidStack> fluidInputRecipes = new HashMap();
    private static HashSet<Fluid> allowedFluids = new HashSet();
    private static List<CrystallizerRecipe> jeiCrystalRecipes = null;

    public static void register() {
        CrystallizerRecipes.addRecipe(OreDictManager.COAL.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_coal));
        CrystallizerRecipes.addRecipe(OreDictManager.IRON.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_iron));
        CrystallizerRecipes.addRecipe(OreDictManager.GOLD.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_gold));
        CrystallizerRecipes.addRecipe(OreDictManager.REDSTONE.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_redstone));
        CrystallizerRecipes.addRecipe(OreDictManager.LAPIS.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_lapis));
        CrystallizerRecipes.addRecipe(OreDictManager.DIAMOND.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_diamond));
        CrystallizerRecipes.addRecipe(OreDictManager.U.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_uranium));
        CrystallizerRecipes.addRecipe(OreDictManager.TH232.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_thorium));
        CrystallizerRecipes.addRecipe(OreDictManager.PU.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_plutonium));
        CrystallizerRecipes.addRecipe(OreDictManager.TI.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_titanium));
        CrystallizerRecipes.addRecipe(OreDictManager.S.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_sulfur));
        CrystallizerRecipes.addRecipe(OreDictManager.KNO.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_niter));
        CrystallizerRecipes.addRecipe(OreDictManager.CU.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_copper));
        CrystallizerRecipes.addRecipe(OreDictManager.W.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_tungsten));
        CrystallizerRecipes.addRecipe(OreDictManager.AL.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_aluminium));
        CrystallizerRecipes.addRecipe(OreDictManager.F.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_fluorite));
        CrystallizerRecipes.addRecipe(OreDictManager.BE.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_beryllium));
        CrystallizerRecipes.addRecipe(OreDictManager.PB.ore(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_lead));
        CrystallizerRecipes.addRecipe(OreDictManager.SA326.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_schrabidium));
        CrystallizerRecipes.addRecipe(OreDictManager.LI.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_lithium));
        CrystallizerRecipes.addRecipe(OreDictManager.STAR.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_starmetal));
        CrystallizerRecipes.addRecipe(OreDictManager.RAREEARTH.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_rare));
        CrystallizerRecipes.addRecipe(OreDictManager.CO.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_cobalt));
        CrystallizerRecipes.addRecipe(OreDictManager.CINNABAR.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_cinnebar));
        CrystallizerRecipes.addRecipe(OreDictManager.ASBESTOS.ore(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_asbestos));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModBlocks.ore_nether_fire), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_phosphorus));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModBlocks.ore_tikite), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.crystal_trixite));
        CrystallizerRecipes.addRecipe(OreDictManager.SRN.ingot(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.crystal_schraranium));
        CrystallizerRecipes.addRecipe("sand", new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.ingot_fiberglass));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Blocks.field_150347_e), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModBlocks.reinforced_stone));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModBlocks.gravel_obsidian), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModBlocks.brick_obsidian));
        CrystallizerRecipes.addRecipe(OreDictManager.REDSTONE.block(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.nugget_mercury));
        CrystallizerRecipes.addRecipe(OreDictManager.CINNABAR.gem(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.nugget_mercury, 3));
        CrystallizerRecipes.addRecipe(OreDictManager.COAL.block(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModBlocks.block_graphite));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModBlocks.stone_gneiss), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.powder_lithium));
        CrystallizerRecipes.addRecipe(OreDictManager.BORAX.dust(), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.powder_boron_tiny, 3));
        CrystallizerRecipes.addRecipe(OreDictManager.DIAMOND.dust(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(Items.field_151045_i));
        CrystallizerRecipes.addRecipe(OreDictManager.EMERALD.dust(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(Items.field_151166_bC));
        CrystallizerRecipes.addRecipe(OreDictManager.LAPIS.dust(), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(Items.field_151100_aR, 1, 4));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.powder_semtex_mix), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.ingot_semtex));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.powder_desh_ready), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.ingot_desh));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.powder_meteorite), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(ModItems.fragment_meteorite, 1));
        CrystallizerRecipes.addRecipe(OreDictManager.CD.dust(), new FluidStack(ModForgeFluids.fishoil, 250), new ItemStack(ModItems.ingot_rubber));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.powder_impure_osmiridium), new FluidStack(ModForgeFluids.schrabidic, 1000), new ItemStack(ModItems.crystal_osmiridium, 1));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.meteorite_sword_treated), new FluidStack(ModForgeFluids.sulfuric_acid, 8000), new ItemStack(ModItems.meteorite_sword_etched, 1));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Items.field_151126_ay), new FluidStack(FluidRegistry.WATER, 8000), new ItemStack(Blocks.field_150432_aD, 1));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Blocks.field_150432_aD), new FluidStack(ModForgeFluids.coolant, 500), new ItemStack(Blocks.field_150403_cj, 1));
        CrystallizerRecipes.addRecipe("gravel", new FluidStack(FluidRegistry.LAVA, 1000), new ItemStack(ModBlocks.gravel_obsidian, 1));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Items.field_151078_bh), new FluidStack(ModForgeFluids.acid, 500), new ItemStack(Items.field_151116_aA));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Items.field_151103_aS), new FluidStack(ModForgeFluids.sulfuric_acid, 1000), new ItemStack(Items.field_151123_aH, 16));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Items.field_151100_aR, 1, 15), new FluidStack(ModForgeFluids.sulfuric_acid, 250), new ItemStack(Items.field_151123_aH, 4));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.powder_lithium, 1), new FluidStack(ModForgeFluids.heatingoil, 4000), new ItemStack(ModItems.crystal_redstone, 1));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.coal_infernal), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.solid_fuel));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_fallout), new FluidStack(ModForgeFluids.corium_fluid, 8000), new ItemStack(ModItems.powder_balefire));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(Blocks.field_150346_d), new FluidStack(ModForgeFluids.colloid, 1000), new ItemStack(Blocks.field_150435_aG));
        CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModBlocks.sand_quartz), new FluidStack(ModForgeFluids.nitroglycerin, 1000), new ItemStack(ModItems.ball_dynamite, 16));
        CrystallizerRecipes.addRecipe(OreDictManager.NETHERQUARTZ.dust(), new FluidStack(ModForgeFluids.nitroglycerin, 250), new ItemStack(ModItems.ball_dynamite, 4));
        ItemStack quartz = Library.getPreferredOredictItem("crystalCertusQuartz");
        if (!quartz.func_190926_b()) {
            ItemStack qItem = quartz.func_77946_l();
            qItem.func_190920_e(6);
            CrystallizerRecipes.addRecipe("oreCertusQuartz", new FluidStack(ModForgeFluids.acid, 500), qItem);
        }
        for (Integer oreMeta : BedrockOreRegistry.oreIndexes.keySet()) {
            CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_centrifuged, 1, (int)oreMeta), new FluidStack(ModForgeFluids.acid, 8000), new ItemStack(ModItems.ore_bedrock_cleaned, 1, oreMeta.intValue()));
            CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_separated, 1, (int)oreMeta), new FluidStack(ModForgeFluids.sulfuric_acid, 500), new ItemStack(ModItems.ore_bedrock_deepcleaned, 1, oreMeta.intValue()));
            CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_purified, 1, (int)oreMeta), new FluidStack(ModForgeFluids.nitric_acid, 250), new ItemStack(ModItems.ore_bedrock_nitrated, 1, oreMeta.intValue()));
            CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_nitrocrystalline, 1, (int)oreMeta), new FluidStack(ModForgeFluids.solvent, 100), new ItemStack(ModItems.ore_bedrock_seared, 1, oreMeta.intValue()));
            CrystallizerRecipes.addRecipe(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_exquisite, 1, (int)oreMeta), new FluidStack(ModForgeFluids.radiosolvent, 50), new ItemStack(ModItems.ore_bedrock_perfect, 1, oreMeta.intValue()));
        }
    }

    public static void addRecipe(Object itemInput, FluidStack fluidInput, ItemStack itemOutput) {
        itemOutputRecipes.put(itemInput, itemOutput);
        fluidInputRecipes.put(itemInput, fluidInput);
        allowedFluids.add(fluidInput.getFluid());
    }

    public static ItemStack getOutputItem(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null || stack.func_190926_b()) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77952_i());
        if (itemOutputRecipes.containsKey(comp)) {
            return itemOutputRecipes.get(comp).func_77946_l();
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!itemOutputRecipes.containsKey(key)) continue;
            return itemOutputRecipes.get(key).func_77946_l();
        }
        return null;
    }

    public static FluidStack getOutputFluid(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null || stack.func_190926_b()) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77952_i());
        if (fluidInputRecipes.containsKey(comp)) {
            return fluidInputRecipes.get(comp).copy();
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!fluidInputRecipes.containsKey(key)) continue;
            return fluidInputRecipes.get(key).copy();
        }
        return null;
    }

    public static boolean isAllowedFluid(Fluid f) {
        if (f != null) {
            return allowedFluids.contains(f);
        }
        return false;
    }

    public static List<CrystallizerRecipe> getRecipes() {
        if (jeiCrystalRecipes != null) {
            return jeiCrystalRecipes;
        }
        jeiCrystalRecipes = new ArrayList<CrystallizerRecipe>();
        for (Map.Entry<Object, ItemStack> entry : itemOutputRecipes.entrySet()) {
            Object ingredients;
            if (entry.getKey() instanceof String) {
                String oreKey = (String)entry.getKey();
                ingredients = OreDictionary.getOres((String)oreKey);
            } else {
                ItemStack stack = ((RecipesCommon.ComparableStack)entry.getKey()).toStack();
                ingredients = new ArrayList();
                ingredients.add(stack);
            }
            ItemStack inputFluid = ItemFluidIcon.getStackWithQuantity(fluidInputRecipes.get(entry.getKey()));
            ItemStack outputItem = entry.getValue();
            ArrayList<List<ItemStack>> totalInput = new ArrayList<List<ItemStack>>();
            totalInput.add((List<ItemStack>)ingredients);
            totalInput.add(Arrays.asList(inputFluid));
            jeiCrystalRecipes.add(new CrystallizerRecipe(totalInput, outputItem));
        }
        return jeiCrystalRecipes;
    }

    public static class CrystallizerRecipe
    implements IRecipeWrapper {
        public final List<List<ItemStack>> inputs;
        private final ItemStack output;

        public CrystallizerRecipe(List<List<ItemStack>> inputs, ItemStack output) {
            this.inputs = inputs;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }
}

