/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.jei;

import com.hbm.handler.jei.JeiRecipes;
import com.hbm.util.I18nUtil;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class AnvilRecipeHandler
implements IRecipeCategory<JeiRecipes.AnvilRecipe> {
    public static final ResourceLocation gui_rl = new ResourceLocation("hbm", "textures/gui/jei/gui_nei_anvil.png");
    protected final IDrawable background;
    private JeiRecipes.AnvilRecipe currentDrawHack = null;

    public AnvilRecipeHandler(IGuiHelper help) {
        this.background = help.createDrawable(gui_rl, 0, 0, 200, 144);
    }

    public String getUid() {
        return "hbm.anvil";
    }

    public String getTitle() {
        return I18nUtil.resolveKey("hbm.achievement.progress_anvil", new Object[0]);
    }

    public String getModName() {
        return "hbm";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        if (this.currentDrawHack != null) {
            if (this.currentDrawHack.tierUpper == -1) {
                minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("desc.tier", this.currentDrawHack.tierLower), 84, 40, 0x40404040);
            } else {
                minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("desc.mintier", this.currentDrawHack.tierLower), 74, 40, 0x40404040);
                minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("desc.maxtier", this.currentDrawHack.tierUpper), 73, 50, 0x40404040);
            }
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            switch (this.currentDrawHack.overlay) {
                case CONSTRUCTION: {
                    minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("jei.construction", new Object[0]), 166, 164, 0x40404040);
                    break;
                }
                case SMITHING: {
                    minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("jei.smithing", new Object[0]), 178, 164, 0x40404040);
                    break;
                }
                case RECYCLING: {
                    minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("jei.recycling", new Object[0]), 174, 164, 0x40404040);
                    break;
                }
                case NONE: {
                    minecraft.field_71466_p.func_78276_b(I18nUtil.resolveKey("jei.conversion", new Object[0]), 170, 164, 0x40404040);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiRecipes.AnvilRecipe recipe, IIngredients ingredients) {
        int i;
        this.currentDrawHack = recipe;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        for (i = 0; i < recipe.outputs.size(); ++i) {
            guiItemStacks.init(i, false, 18 * (i % 4) + 128, 18 * (i / 4));
        }
        for (i = 0; i < recipe.inputs.size(); ++i) {
            guiItemStacks.init(i + recipe.outputs.size(), true, 18 * (i % 4), 18 * (i / 4));
        }
        guiItemStacks.set(ingredients);
        recipeLayout.getIngredientsGroup(VanillaTypes.ITEM).addTooltipCallback((slot, input, ingredient, tooltip) -> {
            if (slot >= recipe.outputs.size()) {
                return;
            }
            float chance = recipe.chances.get(slot).floatValue();
            if (chance != 1.0f) {
                tooltip.add(chance * 100.0f + "%");
            }
        });
    }
}

